package com.ptteng.wealth.user.service;

import java.math.BigDecimal;
import java.util.List;

import com.ptteng.wealth.user.model.User;
import org.osoa.sca.annotations.Remotable;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface UserService extends BaseDaoService {


    public boolean pay(Long userId,BigDecimal payMoney) throws ServiceException, ServiceDaoException ;

    public Long insert(User user) throws ServiceException, ServiceDaoException;

    /**
     * 纯粹的插入用户
     * @param user
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long insertUser(User user) throws ServiceException, ServiceDaoException;

    public Long getLatestUserId() throws ServiceException, ServiceDaoException;


    public List<User> insertList(List<User> userList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(User user) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<User> userList) throws ServiceException, ServiceDaoException;


    public User getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<User> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserIdsByType(Integer type) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserIdsByType(Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getUserIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countUserIds() throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserIdByMobile(String mobile) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getUserIdByKailinCode(String kailinCode) throws ServiceException, ServiceDaoException;

}