package com.ptteng.wealth.user.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.user.model.PersonApply;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface PersonApplyService extends BaseDaoService {


    public Long insert(PersonApply personApply) throws ServiceException, ServiceDaoException;


    public List<PersonApply> insertList(List<PersonApply> personApplyList) throws ServiceException, ServiceDaoException;

    public boolean delete(Long id) throws ServiceException, ServiceDaoException;

    public boolean update(PersonApply personApply) throws ServiceException, ServiceDaoException;

    public boolean updateList(List<PersonApply> personApplyList) throws ServiceException, ServiceDaoException;

    public PersonApply getObjectById(Long id) throws ServiceException, ServiceDaoException;

    public List<PersonApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getPersonApplyIdByUid(Long uid) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getPersonApplyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException;
    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countPersonApplyIds() throws ServiceException, ServiceDaoException;


}

