package com.ptteng.wealth.user.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.user.model.Organization;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface OrganizationService extends BaseDaoService {

	



   		   
		
		public Long insert(Organization organization)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Organization> insertList(List<Organization> organizationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Organization organization)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Organization> organizationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Organization getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Organization> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countOrganizationIdsByType(Integer type)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getOrganizationIdsByType(Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getOrganizationIdByOrgCode(String orgCode)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getOrganizationIdByCreditCode(String creditCode)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getOrganizationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countOrganizationIds() throws ServiceException, ServiceDaoException;


	public Long  getOrganizationIdByName(String name)throws ServiceException, ServiceDaoException;
}

