package com.ptteng.wealth.user.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.user.model.OrgApply;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface OrgApplyService extends BaseDaoService {


    public Long insert(OrgApply orgApply) throws ServiceException, ServiceDaoException;

    public List<OrgApply> insertList(List<OrgApply> orgApplyList) throws ServiceException, ServiceDaoException;

    public boolean delete(Long id) throws ServiceException, ServiceDaoException;

    public boolean update(OrgApply orgApply) throws ServiceException, ServiceDaoException;

    public boolean updateList(List<OrgApply> orgApplyList) throws ServiceException, ServiceDaoException;

    public OrgApply getObjectById(Long id) throws ServiceException, ServiceDaoException;

    public List<OrgApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;

    public Long getOrgApplyIdByMobile(String mobile) throws ServiceException, ServiceDaoException;

    public List<Long> getOrgApplyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    public Integer countOrgApplyIds() throws ServiceException, ServiceDaoException;

    //用来验证组织机构代码，营业执照，社会统一信用码唯一性的方法
    public List<Long> orgCodeIds(String code) throws ServiceException, ServiceDaoException;

    public List<Long> licenseCodeIds(String code) throws ServiceException, ServiceDaoException;

    public List<Long> creditCodeIds(String code) throws ServiceException, ServiceDaoException;

    //创建机构用户及调用代销接口的方法
    public Integer createOrg(OrgApply orgApply) throws ServiceDaoException, ServiceException;


}

