package com.ptteng.wealth.user.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "user_openid_relation")
public class UserOpenidRelation implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 138271915797733376L;

    public static final String TYPEMOBILE = "mobile";
    public static final String TYPEORGCODE = "org_code";
    public static final String Type_Org_Mobile = "org_mobile";
    public static final String Type_Org_Code = "org_code";
    public static final String Type_Person_Mobile = "mobile";
    private Long id;
    private Long typeId;//userid
    private String openId;//orgCode/creditCode/mobile
    private String status;
    private Long createBy;
    private Long updateBy;
    private Long updateAt;
    private Long createAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getTypeId() {
        return typeId;
    }


    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    @Column(name = "openid")
    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openid) {
        this.openId = openid;
    }

    @Column(name = "type")
    public String getStatus() {
        return status;
    }


    public void setStatus(String status) {
        this.status = status;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

