package com.ptteng.wealth.user.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.gemantic.common.util.PasswordUtils;
import com.ptteng.wealth.user.util.Constant;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "user")
public class User implements Serializable {

    public static final Integer TYPE_PERSON = 0;  //个人用户
    public static final Integer TYPE_ORG = 1;     //机构用户
    public static final Integer NO_AUTH = 0;
    public static final Integer ALREADY_AUTH = 1;
    public static final Integer NO_OPEN_ACCOUNT = 0;
    public static final Integer ALREADY_OPEN_ACCOUNT = 1;
    public static final Integer CARD_NO = 0;
    public static final Integer CARD_HAVE = 1;
    public static final Long USER_ACTIVIATE = 0l;
    public static final Long USER_UNACTIVIATE = 1l;
    public static final Integer FREEZE_YES = 1;   //用户处于冻结状态
    public static final Integer FREEZE_NO = 0;  //用户处于解冻状态
    public static final Integer VERIFY_YES = 0;   //用户处于审核通过状态，针对机构用户，个人用户该状态表示已绑卡，机构户表示已开户绑卡
    public static final Integer VERIFY_NO = 1;   //用户处于审核未通过状态，针对机构用户
    private static final long serialVersionUID = 2329130565766395904L;
    protected int fundAccount;
    protected String kailinCode;   //CRM生成的代码，用于和CRM,B2B,OMS同步
    private Long id;
    private String mobile;//
    private String pwd;//
    private String alias;
    private String name;//
    private String payPwd;
    private Integer type;    //0  用户类型，是机构用户还是个人用户
    private Integer risk = 0;
    private Integer accStatus = NO_OPEN_ACCOUNT;//是否开户
    private Integer authStatus = NO_AUTH;//是否实名认证
    private Integer cardStatus = CARD_NO;//是否绑卡;
    private BigDecimal creditLines = new BigDecimal("0");
    private BigDecimal score = new BigDecimal("0");
    private Long registerAt = System.currentTimeMillis();
    private Long lastLoginAt = System.currentTimeMillis();
    private Long status = USER_ACTIVIATE;   //用户是否被激活，0：表示正常注册，或者已经被激活   1： 表示未激活
    private Long createBy;
    private Long updateBy;
    private Long updateAt = System.currentTimeMillis();
    private Long createAt = System.currentTimeMillis();
    private Integer freezeStatus = FREEZE_NO;  //用户是否处于冻结状态
    private Integer verifyStatus = VERIFY_YES;   //用户的审核状态


    public User() {

    }

    public User(String mobile, String password, int type) {
        this.mobile = mobile;
        this.pwd = PasswordUtils.encode(password);
        this.type = type;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "pwd")
    public String getPwd() {
        return pwd;
    }


    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    @Column(name = "alias")
    public String getAlias() {
        return alias;
    }


    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }


    @Column(name = "pay_pwd")
    public String getPayPwd() {
        return payPwd;
    }


    public void setPayPwd(String payPwd) {
        this.payPwd = payPwd;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "risk")
    public Integer getRisk() {
        return risk;
    }


    public void setRisk(Integer risk) {
        this.risk = risk;
    }

    @Column(name = "acc_status")
    public Integer getAccStatus() {
        return accStatus;
    }


    public void setAccStatus(Integer accStatus) {
        this.accStatus = accStatus;
    }

    @Column(name = "auth_status")
    public Integer getAuthStatus() {
        return authStatus;
    }


    public void setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
    }

    @Column(name = "credit_lines")
    public BigDecimal getCreditLines() {
        return creditLines;
    }


    public void setCreditLines(BigDecimal creditLines) {
        this.creditLines = creditLines;
    }

    @Column(name = "score")
    public BigDecimal getScore() {
        return score;
    }


    public void setScore(BigDecimal score) {
        this.score = score;
    }

    @Column(name = "register_at")
    public Long getRegisterAt() {
        return registerAt;
    }


    public void setRegisterAt(Long registerAt) {
        this.registerAt = registerAt;
    }

    @Column(name = "last_login_at")
    public Long getLastLoginAt() {
        return lastLoginAt;
    }


    public void setLastLoginAt(Long lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
    }

    @Column(name = "status")
    public Long getStatus() {
        return status;
    }


    public void setStatus(Long status) {
        this.status = status;
    }


    @Column(name = "fund_account")
    public Integer getFundAccount() {
        return fundAccount;
    }


    public void setFundAccount(Integer fundAccount) {
        this.fundAccount = fundAccount;
    }


    @Column(name = "card_status")
    public Integer getCardStatus() {
        return cardStatus;
    }


    public void setCardStatus(Integer cardStatus) {
        this.cardStatus = cardStatus;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "kailin_code")
    public String getKailinCode() {
        return kailinCode;
    }

    public void setKailinCode(String kailinCode) {
        this.kailinCode = kailinCode;
    }

    @Column(name = "freeze_status")
    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    @Column(name = "verify_status")
    public Integer getVerifyStatus() {
        return verifyStatus;
    }

    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

