package com.ptteng.wealth.user.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "personApply")
public class PersonApply implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 623186746753377280L;

    /**
     * 1/待审核
     * 2/审核通过
     * 3/审核驳回
     * 4/未认证
     */
    public static final Integer STATUS_1 = 1;
    public static final Integer STATUS_2 = 2;
    public static final Integer STATUS_3 = 3;
    public static final Integer STATUS_4 = 4;


    private Long id;
    private Long uid;
    private String mobile;
    private String idNo;
    private String name;
    private String idFront;
    private String idBack;
    private String personIdImg;
    private Integer status;
    /**
     * 驳回原因
     */
    private String refuseReason;
    private Long createBy;
    private Long updateBy;
    private Long updateAt;
    private Long createAt;
    /**
     * 审核时间
     */
    private Long checkAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "id_no")
    public String getIdNo() {
        return idNo;
    }


    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "id_front")
    public String getIdFront() {
        return idFront;
    }


    public void setIdFront(String idFront) {
        this.idFront = idFront;
    }

    @Column(name = "id_back")
    public String getIdBack() {
        return idBack;
    }


    public void setIdBack(String idBack) {
        this.idBack = idBack;
    }

    @Column(name = "person_id_img")
    public String getPersonIdImg() {
        return personIdImg;
    }


    public void setPersonIdImg(String personIdImg) {
        this.personIdImg = personIdImg;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "refuse_reason")
    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    @Column(name = "check_at")
    public Long getCheckAt() {
        return checkAt;
    }

    public void setCheckAt(Long checkAt) {
        this.checkAt = checkAt;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }
    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

