package com.ptteng.wealth.user.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "person")
public class Person implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 686412070103491584L;


    private Long id;
    private String idNo="";          //  身份证号
    private String name="";          //  真实姓名
    private String idFront="";       //URL  身份证前面照片
    private String idBack="";        //URL  身份证后面照片
    private String personIdImg="";   //URL  身份证照片
    private String orgName = "";
    private Long createBy;
    private Long updateBy;
    private Long updateAt;
    private Long createAt;


    @Id
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "id_no")
    public String getIdNo() {
        return idNo;
    }


    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "id_front")
    public String getIdFront() {
        return idFront;
    }


    public void setIdFront(String idFront) {
        this.idFront = idFront;
    }

    @Column(name = "id_back")
    public String getIdBack() {
        return idBack;
    }


    public void setIdBack(String idBack) {
        this.idBack = idBack;
    }

    @Column(name = "person_id_img")
    public String getPersonIdImg() {
        return personIdImg;
    }


    public void setPersonIdImg(String personIdImg) {
        this.personIdImg = personIdImg;
    }

    @Column(name = "org_name")
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

