package com.ptteng.wealth.user.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.ptteng.wealth.user.util.Constant;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "organization")
public class Organization implements Serializable {

    private static final int THREE_CARD = 1;   //组织机构证，营业执照证都在
    private static final int ONE_CARD = 2;   //三证合一，只有一个信用证件
    private static final long serialVersionUID = 1764058381534503936L;


    private Long id;
    private String name;
    private String licenceImg;

    private String permitImg;


    private String taxImg;


    /**
     * 组织机构代码
     */
    private String orgCode;


    /**
     * 营业许可证
     */
    private String licenceCode;


    /**
     * 信用代码
     */
    private String creditCode;


    /**
     * 是否为经销商 备用字段
     */
    private Integer type;


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;


    @Id
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "licence_img")
    public String getLicenceImg() {
        return licenceImg;
    }


    public void setLicenceImg(String licenceImg) {
        this.licenceImg = licenceImg;
    }

    @Column(name = "permit_img")
    public String getPermitImg() {
        return permitImg;
    }


    public void setPermitImg(String permitImg) {
        this.permitImg = permitImg;
    }

    @Column(name = "tax_img")
    public String getTaxImg() {
        return taxImg;
    }


    public void setTaxImg(String taxImg) {
        this.taxImg = taxImg;
    }

    @Column(name = "org_code")
    public String getOrgCode() {
        return orgCode;
    }


    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @Column(name = "licence_code")
    public String getLicenceCode() {
        return licenceCode;
    }


    public void setLicenceCode(String licenceCode) {
        this.licenceCode = licenceCode;
    }

    @Column(name = "credit_code")
    public String getCreditCode() {
        return creditCode;
    }


    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }


    //获取组织机构代码证
    @Transient
    public String getUseOrgCode() {
        String org = "";
        if (type.equals(Organization.THREE_CARD)) {
            org = this.getOrgCode();
        } else if (type.equals(Organization.ONE_CARD)) {
            org = this.creditCode;
        }
        return org;

    }

    //获取营业执照号
    @Transient
    public String getUseLicenseCode() {
        String license = "";
        if (type.equals(Organization.THREE_CARD)) {
            license = this.getLicenceCode();
        } else if (type.equals(Organization.ONE_CARD)) {
            license = this.creditCode;
        }
        return license;
    }

    @Transient
    public String getUseCertId() {
        String certId = "";
        //组织机构代码的情况
        if (Constant.IDKIND.equals(Constant.IDKIND_ORG)) {
            certId = getUseOrgCode();
        }
        //营业执照的情况
        else if (Constant.IDKIND.equals(Constant.IDKIND_SALESLICENSE)) {
            certId = getUseLicenseCode();
        }
        return certId;
    }
}

