package com.ptteng.wealth.user.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.gemantic.common.util.StringUtil;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "org_apply")
public class OrgApply implements Serializable {

    private static final long serialVersionUID = 1114818053549273088L;

    public static final int THREE_CARD =1;   //组织机构证，营业执照证都在
    public static final int ONE_CARD = 2 ;   //三证合一，只有一个信用证件

    /**
     * 0/从CRM 过来，已经激活，补全信息
     * 1/待审核
     * 2/审核通过
     * 3/审核驳回
     */
    public static final Integer STATUS_0 = 0;
    public static final Integer STATUS_1 = 1;
    public static final Integer STATUS_2= 2;
    public static final Integer STATUS_3 = 3;

    private Long id;
    private String name;
    private String licenceImg;
    private String permitImg;
    private String taxImg;
    private String orgCode;
    private String licenceCode;
    private String creditCode;
    private String payPwd;
    private String bank;//编码
    private String bankCode;//中文名
    private String cardNo;
    private Integer status;
    private Long createBy;
    private Long updateBy;
    private Long updateAt;
    private Long createAt;
    private String mobile;
    private String password;
    private Integer orgType;
    private String kailinCode;
    private String refuseReason;
    private Long uid;
    private Long checkAt;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "licence_img")
    public String getLicenceImg() {
        return licenceImg;
    }


    public void setLicenceImg(String licenceImg) {
        this.licenceImg = licenceImg;
    }

    @Column(name = "permit_img")
    public String getPermitImg() {
        return permitImg;
    }


    public void setPermitImg(String permitImg) {
        this.permitImg = permitImg;
    }

    @Column(name = "tax_img")
    public String getTaxImg() {
        return taxImg;
    }


    public void setTaxImg(String taxImg) {
        this.taxImg = taxImg;
    }

    @Column(name = "org_code")
    public String getOrgCode() {
        return orgCode;
    }


    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @Column(name = "licence_code")
    public String getLicenceCode() {
        return licenceCode;
    }


    public void setLicenceCode(String licenceCode) {
        this.licenceCode = licenceCode;
    }

    @Column(name = "credit_code")
    public String getCreditCode() {
        return creditCode;
    }


    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    @Column(name = "pay_pwd")
    public String getPayPwd() {
        return payPwd;
    }


    public void setPayPwd(String payPwd) {
        this.payPwd = payPwd;
    }

    @Column(name = "bank")
    public String getBank() {
        return bank;
    }


    public void setBank(String bank) {
        this.bank = bank;
    }

    @Column(name = "card_no")
    public String getCardNo() {
        return cardNo;
    }


    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "password")
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Column(name = "org_type")
    public Integer getOrgType() {
        return orgType;
    }

    public void setOrgType(Integer orgType) {
        this.orgType = orgType;
    }

    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "kailin_code")
    public String getKailinCode() {
        return kailinCode;
    }

    public void setKailinCode(String kailinCode) {
        this.kailinCode = kailinCode;
    }

    @Column(name = "bank_code")
    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    @Column(name = "refuse_reason")
    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "check_at")
    public Long getCheckAt() {
        return checkAt;
    }

    public void setCheckAt(Long checkAt) {
        this.checkAt = checkAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

    //获取组织机构代码证
    @Transient
    public String getUseOrgCode() {
      String org = "";
      if(orgType.equals(OrgApply.THREE_CARD)){
          org = this.getOrgCode();
      }
      else if (orgType.equals(OrgApply.ONE_CARD)){
          org = this.creditCode;
      }
      return  org;

    }

    @Transient
    public String getUseLicenseCode() {
       String license = "";
       if(orgType.equals(OrgApply.THREE_CARD)){
           license = this.getLicenceCode();
       }
       else if(orgType.equals(OrgApply.ONE_CARD)){
           license = this.creditCode;
       }
       if(StringUtil.isEmpty(license)){
           license = this.getUseOrgCode();
       }
       return  license;
    }

}

