/**
 * 
 */
package com.ptteng.wealth.user.client;

import java.util.List;
import java.util.Map;

import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.service.OrganizationService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class OrganizationSCAClient implements OrganizationService {

    private OrganizationService organizationService;

	public OrganizationService getOrganizationService() {
		return organizationService;
	}
	
	
	public void setOrganizationService(OrganizationService organizationService) {
		this.organizationService =organizationService;
	}
	
	
			   
		@Override
		public Long insert(Organization organization)throws ServiceException, ServiceDaoException{
		
		return organizationService.insert(organization);
		          
		
		}	
		  
    	   
		@Override
		public List<Organization> insertList(List<Organization> organizationList)throws ServiceException, ServiceDaoException{
		
		return organizationService.insertList(organizationList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return organizationService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Organization organization)throws ServiceException, ServiceDaoException{
		
		return organizationService.update(organization);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Organization> organizationList)throws ServiceException, ServiceDaoException{
		
		return organizationService.updateList(organizationList);
		          
		
		}	
		  
    	   
		@Override
		public Organization getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return organizationService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Organization> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return organizationService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getOrganizationIdsByType(Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return organizationService.getOrganizationIdsByType(type,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getOrganizationIdByOrgCode(String orgCode)throws ServiceException, ServiceDaoException{
		
		return organizationService.getOrganizationIdByOrgCode(orgCode);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getOrganizationIdByCreditCode(String creditCode)throws ServiceException, ServiceDaoException{
		
		return organizationService.getOrganizationIdByCreditCode(creditCode);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countOrganizationIdsByType(Integer type)throws ServiceException, ServiceDaoException{
		
		return organizationService.countOrganizationIdsByType(type);
	
	
	}
	
		
	
		@Override
	public List<Long> getOrganizationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return organizationService.getOrganizationIds(start, limit);
	}

	@Override
	public Integer countOrganizationIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return organizationService.countOrganizationIds();
	}

	@Override
	public Long getOrganizationIdByName(String name) throws ServiceException, ServiceDaoException {
		return organizationService.getOrganizationIdByName(name);
	}


	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return organizationService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return organizationService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   organizationService.deleteList(clz, ids);
		
	}


 
}

