/**
 *
 */
package com.ptteng.wealth.user.client;

import java.util.List;
import java.util.Map;

import com.ptteng.wealth.user.model.OrgApply;
import com.ptteng.wealth.user.service.OrgApplyService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class OrgApplySCAClient implements OrgApplyService {

    private OrgApplyService orgApplyService;

    public OrgApplyService getOrgApplyService() {
        return orgApplyService;
    }

    public void setOrgApplyService(OrgApplyService orgApplyService) {
        this.orgApplyService = orgApplyService;
    }

    @Override
    public Long insert(OrgApply orgApply) throws ServiceException, ServiceDaoException {
        return orgApplyService.insert(orgApply);
    }

    @Override
    public List<OrgApply> insertList(List<OrgApply> orgApplyList) throws ServiceException, ServiceDaoException {
        return orgApplyService.insertList(orgApplyList);
    }

    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        return orgApplyService.delete(id);
    }


    @Override
    public boolean update(OrgApply orgApply) throws ServiceException, ServiceDaoException {
        return orgApplyService.update(orgApply);
    }


    @Override
    public boolean updateList(List<OrgApply> orgApplyList) throws ServiceException, ServiceDaoException {
        return orgApplyService.updateList(orgApplyList);
    }

    @Override
    public OrgApply getObjectById(Long id) throws ServiceException, ServiceDaoException {
        return orgApplyService.getObjectById(id);
    }


    @Override
    public List<OrgApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        return orgApplyService.getObjectsByIds(ids);
    }

    @Override
    public Long getOrgApplyIdByMobile(String mobile) throws ServiceException, ServiceDaoException {
        return orgApplyService.getOrgApplyIdByMobile(mobile);
    }


    @Override
    public List<Long> getOrgApplyIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        return orgApplyService.getOrgApplyIds(start, limit);
    }

    @Override
    public Integer countOrgApplyIds() throws ServiceException, ServiceDaoException {
        return orgApplyService.countOrgApplyIds();
    }

    @Override
    public List<Long> orgCodeIds(String code) throws ServiceException, ServiceDaoException {
        return  orgApplyService.orgCodeIds(code);
    }

    @Override
    public List<Long> licenseCodeIds(String code) throws ServiceException, ServiceDaoException {
        return  orgApplyService.licenseCodeIds(code);
    }

    @Override
    public List<Long> creditCodeIds(String code) throws ServiceException, ServiceDaoException {
        return orgApplyService.creditCodeIds(code);
    }

    @Override
    public Integer createOrg(OrgApply orgApply) throws ServiceDaoException, ServiceException {
       return orgApplyService.createOrg(orgApply);
    }

    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        return orgApplyService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        return orgApplyService.fakeDelete(clz, id);
    }

    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        orgApplyService.deleteList(clz, ids);

    }


}

