/*
 * Decompiled with CFR 0.152.
 */
package com.hczq.hz.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLIOSessionStrategyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SSLIOSessionStrategyFactory.class);
    private static final Pattern resourcePattern = Pattern.compile("(classpath|file|http):(.+)");
    public static final X509HostnameVerifier EMPTY_VERIFIER = new X509HostnameVerifier(){

        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }

        public void verify(String host, SSLSocket ssl) throws IOException {
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
        }
    };

    public static SSLIOSessionStrategy create(Properties conf) throws SSLInitializationException {
        SSLIOSessionStrategy var6;
        InputStream stream = null;
        InputStream rootStream = null;
        try {
            stream = SSLIOSessionStrategyFactory.getResourceAsStream(conf.getProperty("am.httpClient.keystoreFile"));
            KeyStore t = KeyStore.getInstance(conf.getProperty("am.httpClient.keystoreType", "PKCS12"));
            t.load(stream, conf.getProperty("am.httpClient.keystorePass", "").toCharArray());
            rootStream = SSLIOSessionStrategyFactory.getResourceAsStream(conf.getProperty("am.httpClient.truststoreFile"));
            KeyStore root = KeyStore.getInstance(conf.getProperty("am.httpClient.truststoreType", "PKCS12"));
            root.load(rootStream, conf.getProperty("am.httpClient.truststorePass", "").toCharArray());
            SSLContext context = SSLContexts.custom().useTLS().loadKeyMaterial(t, conf.getProperty("am.httpClient.keyPassword", "").toCharArray()).loadTrustMaterial(root).build();
            var6 = new SSLIOSessionStrategy(context, (String[])null, (String[])null, EMPTY_VERIFIER);
        }
        catch (Throwable var10) {
            try {
                throw new SSLInitializationException("create failed.", var10);
            }
            catch (Throwable throwable) {
                SSLIOSessionStrategyFactory.closeIO(stream);
                SSLIOSessionStrategyFactory.closeIO(rootStream);
                throw throwable;
            }
        }
        SSLIOSessionStrategyFactory.closeIO(stream);
        SSLIOSessionStrategyFactory.closeIO(rootStream);
        return var6;
    }

    protected static InputStream getResourceAsStream(String resource) {
        LOG.info("getResourceAsStream from " + resource);
        Matcher m = resourcePattern.matcher(resource);
        if (!m.matches()) {
            return null;
        }
        String type = m.group(1);
        if ("classpath".equals(type)) {
            InputStream t = SSLIOSessionStrategyFactory.class.getClassLoader().getResourceAsStream(m.group(2));
            return t;
        }
        try {
            InputStream t = new URL(resource).openStream();
            return t;
        }
        catch (Throwable var4) {
            LOG.warn("getResourceAsStream " + resource + " failed.", var4);
            return null;
        }
    }

    protected static void closeIO(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

