/*
 * Decompiled with CFR 0.152.
 */
package com.hczq.hz.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.hczq.hz.intf.AmResultList;
import com.hczq.hz.intf.AmServiceResult;
import com.hczq.hz.intf.AmServices;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.nio.util.SharedInputBuffer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class AmHttpUtils {
    public static final Pattern FUNC_NAME_PATTERN = Pattern.compile("fun(\\d+)");
    private static final JsonFactory jsonFactory = new JsonFactory();

    public static String getAuthorization(String auth) {
        return "Basic " + new String(Base64.encodeBase64((byte[])auth.getBytes()));
    }

    public static UrlEncodedFormEntity createUrlPostEntity(Object amRequest, int dataResultType) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        Field[] arr$ = fields = amRequest.getClass().getDeclaredFields();
        int len$ = fields.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Field field = arr$[i$];
            field.setAccessible(true);
            Object value = field.get(amRequest);
            if (value == null) continue;
            nvps.add(new BasicNameValuePair(field.getName(), String.valueOf(value)));
        }
        nvps.add(new BasicNameValuePair("__dataViewType__", String.valueOf(dataResultType)));
        return new UrlEncodedFormEntity(nvps, Consts.UTF_8);
    }

    public static StringBuffer toString(Object amRequest) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        StringBuffer buf = new StringBuffer("");
        Field[] arr$ = fields = amRequest.getClass().getDeclaredFields();
        int len$ = fields.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Field field = arr$[i$];
            field.setAccessible(true);
            Object value = field.get(amRequest);
            if (value == null) continue;
            buf.append(field.getName() + "=" + value + "|");
        }
        return buf;
    }

    public static Object createAmResponseFromJson(int functionId, InputStream inputStream) throws JsonParseException, IOException, InstantiationException, IllegalAccessException {
        AmJsonObject root = null;
        try (JsonParser parser = jsonFactory.createParser(inputStream);){
            Stack<Object> stack = new Stack<Object>();
            JsonToken token = parser.nextToken();
            while (true) {
                AmJsonItem curObj1;
                Object parentObj1;
                Object curObj;
                if (token == JsonToken.START_OBJECT) {
                    if (stack.isEmpty()) {
                        root = new AmJsonObject();
                        stack.push(root);
                    } else {
                        curObj = stack.peek();
                        if (curObj instanceof AmJsonItem) {
                            if (!StringUtils.equals((CharSequence)((AmJsonItem)curObj).name, (CharSequence)"result")) {
                                throw new IOException("invalid return json, unknow obj " + ((AmJsonItem)curObj).name);
                            }
                            AmJsonItem parentObj = (AmJsonItem)stack.pop();
                            Object amResult = AmHttpUtils.createJsonParsingObject(root.type, root.funcId);
                            stack.push(amResult);
                        } else {
                            if (!(curObj instanceof AmResultList)) {
                                throw new IOException("invalid return json");
                            }
                            parentObj1 = AmHttpUtils.createJsonParsingPObject(root.funcId);
                            stack.push(parentObj1);
                        }
                    }
                } else if (token == JsonToken.FIELD_NAME) {
                    curObj1 = new AmJsonItem();
                    stack.push(curObj1);
                    curObj1.name = parser.getCurrentName();
                } else if (token == JsonToken.VALUE_NUMBER_INT) {
                    curObj1 = (AmJsonItem)stack.pop();
                    long parentObj3 = parser.getLongValue();
                    AmHttpUtils.setJsonParsingObjectValue(stack.peek(), curObj1.name, parentObj3);
                } else if (token == JsonToken.VALUE_STRING) {
                    curObj1 = (AmJsonItem)stack.pop();
                    String parentObj2 = parser.getText();
                    AmHttpUtils.setJsonParsingObjectValue(stack.peek(), curObj1.name, parentObj2);
                } else if (token == JsonToken.START_ARRAY) {
                    curObj1 = (AmJsonItem)stack.pop();
                } else if (token != JsonToken.END_ARRAY && token == JsonToken.END_OBJECT) {
                    curObj = stack.pop();
                    parentObj1 = stack.peek();
                    if (parentObj1 instanceof AmResultList) {
                        AmResultList amResult1 = (AmResultList)parentObj1;
                        amResult1.add(curObj);
                    } else if (parentObj1 instanceof AmJsonObject) {
                        root.result = curObj;
                        stack.clear();
                        Object object = root.result;
                        return object;
                    }
                }
                token = parser.nextToken();
            }
        }
    }

    private static void setJsonParsingObjectValue(Object obj, String name, Object value) {
        if (obj instanceof AmJsonObject) {
            AmJsonObject amResult = (AmJsonObject)obj;
            if (StringUtils.equals((CharSequence)"type", (CharSequence)name)) {
                amResult.type = AmHttpUtils.Long2Int(value);
            } else if (StringUtils.equals((CharSequence)"funcId", (CharSequence)name)) {
                amResult.funcId = AmHttpUtils.Long2Int(value);
            }
        } else if (obj instanceof AmServiceResult) {
            AmServiceResult amResult1 = (AmServiceResult)obj;
            if (StringUtils.equals((CharSequence)"errorNo", (CharSequence)name)) {
                amResult1.setErrorNo(AmHttpUtils.Long2Int(value));
            } else if (StringUtils.equals((CharSequence)"errorInfo", (CharSequence)name)) {
                amResult1.setErrorInfo((String)value);
            } else if (StringUtils.equals((CharSequence)"serialNoTrans", (CharSequence)name)) {
                amResult1.setSerialNoTrans((String)value);
            } else {
                AmHttpUtils.trySetObjectField(amResult1, name, (String)value, null);
            }
        } else {
            AmHttpUtils.trySetObjectField(obj, name, (String)value, null);
        }
    }

    private static int Long2Int(Object value) {
        if (value instanceof Long) {
            long v = (Long)value;
            return (int)v;
        }
        if (value.getClass() == Long.TYPE) {
            long v = (Long)value;
            return (int)v;
        }
        throw new IllegalArgumentException("value not type of Long or long");
    }

    private static Object createJsonParsingObject(int type, int funcId) throws IOException, InstantiationException, IllegalAccessException {
        if (type == 0) {
            Class<?> returnType = AmHttpUtils.getReturnType(funcId);
            AmServiceResult amResultList1 = (AmServiceResult)returnType.newInstance();
            return amResultList1;
        }
        if (type == 1) {
            Class<?> returnType = AmHttpUtils.getReturnType(funcId);
            AmResultList amResultList = (AmResultList)returnType.newInstance();
            return amResultList;
        }
        throw new IOException("Invalid type " + type + " of funcId " + funcId);
    }

    private static Object createJsonParsingPObject(int funcId) throws InstantiationException, IllegalAccessException {
        Class<?> returnParamType = AmHttpUtils.getReturnParameterizedType(funcId);
        Object obj = returnParamType.newInstance();
        return obj;
    }

    public static Object createAmResponse(int functionId, InputStream inputStream) throws DocumentException, InstantiationException, IllegalAccessException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(inputStream);
        Element root = document.getRootElement();
        int funcId = -1;
        int type = -1;
        Attribute attribute = root.attribute("funcId");
        if (attribute != null) {
            funcId = Integer.parseInt(attribute.getValue());
        }
        if ((attribute = root.attribute("type")) != null) {
            type = Integer.parseInt(attribute.getValue());
        }
        return 0 == type ? AmHttpUtils.parseType0Result(root, funcId) : (1 == type ? AmHttpUtils.parseType1Result(root, funcId) : null);
    }

    protected static Object parseType0Result(Element root, int funcId) throws InstantiationException, IllegalAccessException {
        Class<?> returnType = AmHttpUtils.getReturnType(funcId);
        AmServiceResult amResponse = (AmServiceResult)returnType.newInstance();
        AmHttpUtils.setObjectFields(root, amResponse);
        return amResponse;
    }

    protected static Object parseType1Result(Element root, int funcId) throws InstantiationException, IllegalAccessException {
        Class<?> returnType = AmHttpUtils.getReturnType(funcId);
        Class<?> returnParamType = AmHttpUtils.getReturnParameterizedType(funcId);
        AmResultList amResultList = (AmResultList)returnType.newInstance();
        List children = root.elements();
        for (Element e : children) {
            String name = e.getName();
            if (AmHttpUtils.isAmServiceResultField(amResultList, name)) {
                String item = e.getTextTrim();
                AmHttpUtils.trySetObjectField(amResultList, name, item, AmServiceResult.class);
                continue;
            }
            if (!StringUtils.equals((CharSequence)"item", (CharSequence)name)) continue;
            Object item1 = returnParamType.newInstance();
            AmHttpUtils.setObjectFields(e, item1);
            amResultList.add(item1);
        }
        return amResultList;
    }

    private static void setObjectFields(Element root, Object obj) {
        List children = root.elements();
        Iterator i$ = children.iterator();
        while (i$.hasNext()) {
            Element child = (Element)i$.next();
            String name = child.getName();
            String value = child.getTextTrim();
            if (obj instanceof AmServiceResult && AmHttpUtils.parseAmServiceResultField((AmServiceResult)obj, name, value)) continue;
            AmHttpUtils.trySetObjectField(obj, name, value, null);
        }
        return;
    }

    private static boolean parseAmServiceResultField(AmServiceResult amResult, String name, String value) {
        if (StringUtils.equals((CharSequence)"errorNo", (CharSequence)name)) {
            amResult.setErrorNo(Integer.parseInt(value));
            return true;
        }
        if (StringUtils.equals((CharSequence)"errorInfo", (CharSequence)name)) {
            amResult.setErrorInfo(value);
            return true;
        }
        if (StringUtils.equals((CharSequence)"serialNoTrans", (CharSequence)name)) {
            amResult.setSerialNoTrans(value);
            return true;
        }
        return false;
    }

    private static boolean isAmServiceResultField(AmServiceResult amResult, String name) {
        return StringUtils.equals((CharSequence)"errorNo", (CharSequence)name) ? true : (StringUtils.equals((CharSequence)"errorInfo", (CharSequence)name) ? true : StringUtils.equals((CharSequence)"serialNoTrans", (CharSequence)name));
    }

    private static void trySetObjectField(Object obj, String name, String value, Class<?> clazz) {
        try {
            Class<?> e = clazz;
            if (clazz == null) {
                e = obj.getClass();
            }
            Field field = e.getDeclaredField(name);
            AmHttpUtils.setFieldValue(obj, field, value);
        }
        catch (Exception var6) {
            // empty catch block
        }
    }

    private static void setFieldValue(Object obj, Field field, String value) throws IllegalArgumentException, IllegalAccessException {
        if (value != null) {
            field.setAccessible(true);
            Class<?> clazz = field.getType();
            if (String.class == clazz) {
                field.set(obj, value);
            } else if (Integer.TYPE == clazz) {
                int t = 0;
                try {
                    t = Integer.parseInt(value);
                }
                catch (Throwable var8) {
                    // empty catch block
                }
                field.set(obj, t);
            } else if (BigInteger.class == clazz) {
                try {
                    field.set(obj, new BigInteger(value));
                }
                catch (Throwable var7) {}
            } else if (BigDecimal.class == clazz) {
                try {
                    field.set(obj, new BigDecimal(value));
                }
                catch (Throwable var6) {
                    // empty catch block
                }
            }
        }
    }

    public static Class<?> getReturnType(int funcId) {
        Method[] methods;
        Method[] arr$ = methods = AmServices.class.getMethods();
        int len$ = methods.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int curFuncId;
            Method method = arr$[i$];
            Matcher matcher = FUNC_NAME_PATTERN.matcher(method.getName());
            if (!matcher.matches() || funcId != (curFuncId = Integer.parseInt(matcher.group(1)))) continue;
            return method.getReturnType();
        }
        return null;
    }

    protected static Class<?> getReturnParameterizedType(int funcId) {
        Method[] methods;
        Method[] arr$ = methods = AmServices.class.getMethods();
        int len$ = methods.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ParameterizedType parameterizedType;
            Type[] types;
            int curFuncId;
            Method method = arr$[i$];
            Matcher matcher = FUNC_NAME_PATTERN.matcher(method.getName());
            if (!matcher.matches() || funcId != (curFuncId = Integer.parseInt(matcher.group(1)))) continue;
            if (!(method.getGenericReturnType() instanceof ParameterizedType) || (types = (parameterizedType = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()).length <= 0) break;
            return (Class)types[0];
        }
        return null;
    }

    public static class AmResponseInputStream
    extends InputStream {
        private SharedInputBuffer buf;

        public AmResponseInputStream(SharedInputBuffer buffer) {
            this.buf = buffer;
        }

        @Override
        public int read() throws IOException {
            return this.buf.read();
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.buf != null) {
                this.buf.shutdown();
            }
        }
    }

    static class AmJsonObject {
        int type;
        int funcId;
        long requestTimestamp;
        long responseTimestamp;
        Object result;

        AmJsonObject() {
        }
    }

    static class AmJsonItem {
        String name;
        Object value;

        AmJsonItem() {
        }
    }
}

