/*
 * Decompiled with CFR 0.152.
 */
package com.hczq.hz.client;

import com.hczq.hz.client.AmHttpAsyncClientFactory;
import com.hczq.hz.client.AmHttpClientInvocation;
import com.hczq.hz.client.AmHttpClientInvocationContext;
import com.hczq.hz.client.AmHttpClientInvocationInterceptorChainImpl;
import com.hczq.hz.client.AmHttpUtils;
import com.hczq.hz.intf.AmServiceResult;
import com.hczq.hz.intf.AmServices;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmHttpServicesStub {
    private static final Logger LOG = LoggerFactory.getLogger(AmHttpServicesStub.class);
    private static final Pattern TIMEOUT_PATTERN = Pattern.compile("am\\.httpClient\\.timeout\\.(\\d+)");
    private static final Pattern P1 = Pattern.compile("am\\.httpClient\\.server\\.(.+)");
    private static final Pattern P2 = Pattern.compile("(\\d+)(.*)");
    public static final String SERVER_CONF_NAME = "am.serverConfs";
    public static final String FUNCTION_CONF_NAME = "am.functionConfs";

    public static AmServices createAmServices() throws Exception {
        InputStream inputStream = AmHttpServicesStub.class.getResourceAsStream("/am-http-client-config.xml");
        if (inputStream == null) {
            throw new IllegalArgumentException("am-http-client-config.xml in classpath doesnot be found.");
        }
        Properties conf = new Properties();
        conf.loadFromXML(inputStream);
        return AmHttpServicesStub.createAmServices(conf);
    }

    public static AmServices createAmServices(Properties conf) throws Exception {
        if (conf == null) {
            throw new IllegalArgumentException("conf must be set.");
        }
        AmHttpServicesStub.parseServerConf(conf);
        AmHttpClientInvocationInterceptorChainImpl.init(conf);
        return (AmServices)Proxy.newProxyInstance(AmServices.class.getClassLoader(), new Class[]{AmServices.class, AmHttpClientInvocationContext.class}, (InvocationHandler)new HttpAmInvocationHandler(conf));
    }

    public static void parseServerConf(Properties conf) {
        HashMap<String, ServerConf> serverConfs = new HashMap<String, ServerConf>();
        HashMap<Integer, ServerConf> functionConfs = new HashMap<Integer, ServerConf>();
        Enumeration<?> propNames = conf.propertyNames();
        while (true) {
            if (!propNames.hasMoreElements()) {
                conf.put(SERVER_CONF_NAME, serverConfs);
                conf.put(FUNCTION_CONF_NAME, functionConfs);
                return;
            }
            String curPropName = String.valueOf(propNames.nextElement());
            Matcher m = P1.matcher(curPropName);
            if (!m.matches()) continue;
            String serverName = m.group(1);
            String serverAddr = conf.getProperty(curPropName);
            String functionsStr = conf.getProperty("am.httpClient.functions." + serverName);
            String maxConn = conf.getProperty("am.httpClient.maxPerRoute." + serverName);
            ServerConf serverConf = new ServerConf();
            serverConf.setName(serverName);
            String[] ss = serverAddr.split(":");
            serverConf.setHost(ss[0]);
            serverConf.setPort(Integer.parseInt(ss[1]));
            String[] arr$ = ss = functionsStr.split(",");
            int len$ = ss.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String s = arr$[i$];
                Matcher matcher = P2.matcher(StringUtils.trimToEmpty((String)s));
                if (!matcher.matches()) continue;
                int curfunc = Integer.parseInt(matcher.group(1));
                serverConf.getFunctions().add(curfunc);
                functionConfs.put(curfunc, serverConf);
            }
            serverConf.setMaxConnections(Integer.parseInt(maxConn));
            serverConfs.put(serverName, serverConf);
        }
    }

    public static void shutdown(AmServices amServices) {
        AmHttpClientInvocationContext context;
        HttpAsyncClient client;
        if (amServices instanceof AmHttpClientInvocationContext && (client = (context = (AmHttpClientInvocationContext)((Object)amServices)).getHttpClient()) != null && client instanceof CloseableHttpAsyncClient) {
            try {
                ((CloseableHttpAsyncClient)client).close();
            }
            catch (IOException var4) {
                LOG.error("shutdown failed.", (Throwable)var4);
            }
        }
    }

    public static Properties getCurrentAmServicesConf(AmServices amServices) {
        if (amServices instanceof AmHttpClientInvocationContext) {
            AmHttpClientInvocationContext context = (AmHttpClientInvocationContext)((Object)amServices);
            return context.getConf();
        }
        return null;
    }

    static class ServerConf {
        private String name;
        private String host;
        private int port;
        private List<Integer> functions = new ArrayList<Integer>();
        private int maxConnections = -1;

        ServerConf() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public List<Integer> getFunctions() {
            return this.functions;
        }

        public void setFunctions(List<Integer> functions) {
            this.functions = functions;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }
    }

    public static class HttpAmInvocationHandler
    implements InvocationHandler,
    AmHttpClientInvocation {
        protected Properties conf;
        protected volatile CloseableHttpAsyncClient client;
        protected AmHttpAsyncClientFactory factory;
        protected int defaultTimeout = 30000;
        protected Map<Integer, Integer> timeouts = new HashMap<Integer, Integer>();

        public HttpAmInvocationHandler(Properties conf) {
            this.conf = conf;
            if (this.conf == null) {
                this.conf = new Properties();
            }
            this.parseTimeouts(conf);
            this.factory = new AmHttpAsyncClientFactory(this.conf);
        }

        public synchronized CloseableHttpAsyncClient getHttpAsyncClient() throws IOException {
            if (this.client == null) {
                this.client = this.factory.createClient();
            }
            if (this.client == null) {
                throw new IOException("HttpAsyncClient is null");
            }
            return this.client;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String mName = method.getName();
            if (StringUtils.equals((CharSequence)"getHttpClient", (CharSequence)mName)) {
                return this.client;
            }
            if (StringUtils.equals((CharSequence)"getConf", (CharSequence)mName)) {
                return this.conf;
            }
            if (StringUtils.equals((CharSequence)"execute", (CharSequence)mName)) {
                return this.batchCall((Map)args[0]);
            }
            Matcher matcher = AmHttpUtils.FUNC_NAME_PATTERN.matcher(mName);
            return matcher.matches() ? this.intercept(Integer.parseInt(matcher.group(1)), args[0]) : null;
        }

        public Map<Integer, Object> batchCall(Map<Integer, Object> params) throws Exception {
            if (params == null) {
                return null;
            }
            HashMap<Integer, Object> result = new HashMap<Integer, Object>();
            for (Integer funcId : params.keySet()) {
                try {
                    Object e = this.intercept(funcId, params.get(funcId));
                    result.put(funcId, e);
                }
                catch (Exception var8) {
                    Class<?> rCls = AmHttpUtils.getReturnType(funcId);
                    AmServiceResult r = (AmServiceResult)rCls.newInstance();
                    r.setErrorNo(-1);
                    r.setErrorInfo(var8.getMessage());
                    result.put(funcId, r);
                }
            }
            return result;
        }

        public Object intercept(int funcId, Object amRequest) throws Exception {
            return new AmHttpClientInvocationInterceptorChainImpl(this).doIntercept(funcId, amRequest);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call(int funcId, Object amRequest) throws Exception {
            long t1;
            long t2 = t1 = System.currentTimeMillis();
            String requestUrl = null;
            try {
                HttpResponse response;
                block11: {
                    Object var18;
                    CloseableHttpAsyncClient client = this.getHttpAsyncClient();
                    int httpRequestType = Integer.parseInt(this.conf.getProperty("am.httpClient.requestType", "0"));
                    requestUrl = httpRequestType == 0 ? String.format("http://%s:%s/am-server/invocation/", this.getHostName(funcId), this.getPort(funcId)) : this.conf.getProperty("am.httpClient.requestUrl", requestUrl);
                    if (!requestUrl.endsWith("/")) {
                        requestUrl = requestUrl + "/";
                    }
                    requestUrl = String.format(requestUrl + "%d?%s", funcId, UUID.randomUUID().toString());
                    HttpPost post = new HttpPost(requestUrl);
                    RequestConfig.Builder b = RequestConfig.custom().setSocketTimeout(this.getReceiveTimeout()).setConnectTimeout(this.getConnectionTimeout()).setConnectionRequestTimeout(this.getConnectionRequestTimeout());
                    post.setConfig(b.build());
                    post.setHeader("Authorization", AmHttpUtils.getAuthorization(this.getAuth()));
                    post.setHeader("am_access_mode", "1");
                    post.setHeader("Connection", "keep-alive");
                    int dataResultType = this.getDataResultType();
                    post.setEntity((HttpEntity)AmHttpUtils.createUrlPostEntity(amRequest, dataResultType));
                    Future future = client.execute((HttpUriRequest)post, (FutureCallback)null);
                    response = (HttpResponse)future.get(this.getTimeout(funcId), TimeUnit.MILLISECONDS);
                    t2 = System.currentTimeMillis();
                    int statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity resEntity = response.getEntity();
                    if (statusCode != 200 || resEntity == null) break block11;
                    InputStream inputStream = resEntity.getContent();
                    if (dataResultType == 0) {
                        Object var182;
                        Object object = var182 = AmHttpUtils.createAmResponse(funcId, inputStream);
                        return object;
                    }
                    Object object = var18 = AmHttpUtils.createAmResponseFromJson(funcId, inputStream);
                    return object;
                    finally {
                        EntityUtils.consume((HttpEntity)resEntity);
                    }
                }
                throw new Exception(String.format("call function [%d] failed. Reason: %s", funcId, response.getStatusLine()));
            }
            finally {
                LOG.info(funcId + "," + new Date(t1) + "," + t1 + "," + (t2 - t1) + "," + (System.currentTimeMillis() - t1) + "," + AmHttpUtils.toString(amRequest) + "," + requestUrl);
            }
        }

        private String getAuth() {
            return this.conf.getProperty("am.httpClient.userName") + ":" + this.conf.getProperty("am.httpClient.password");
        }

        private String getHostName(int funcId) {
            Map funcConfs = (Map)this.conf.get(AmHttpServicesStub.FUNCTION_CONF_NAME);
            ServerConf serverConf = (ServerConf)funcConfs.get(funcId);
            return serverConf == null ? this.conf.getProperty("am.httpClient.serverHostName") : serverConf.getHost();
        }

        private int getPort(int funcId) {
            Map funcConfs = (Map)this.conf.get(AmHttpServicesStub.FUNCTION_CONF_NAME);
            ServerConf serverConf = (ServerConf)funcConfs.get(funcId);
            return serverConf == null ? Integer.parseInt(this.conf.getProperty("am.httpClient.serverPort", "9090")) : serverConf.getPort();
        }

        private int getReceiveTimeout() {
            return Integer.parseInt(this.conf.getProperty("am.httpClient.socketTimeout", "10000"));
        }

        private int getConnectionTimeout() {
            return Integer.parseInt(this.conf.getProperty("am.httpClient.connectTimeout", "10000"));
        }

        private int getConnectionRequestTimeout() {
            return Integer.parseInt(this.conf.getProperty("am.httpClient.connectionRequestTimeout", "10000"));
        }

        private int getDataResultType() {
            int result = 0;
            try {
                result = Integer.parseInt(this.conf.getProperty("am.httpClient.dataResultType", "0"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return result;
        }

        private void parseTimeouts(Properties conf) {
            this.defaultTimeout = this.getIntProp(conf, "am.httpClient.timeout", 30000);
            Enumeration<?> keys = conf.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Matcher matcher = TIMEOUT_PATTERN.matcher(key);
                if (!matcher.matches()) continue;
                int funcId = Integer.parseInt(matcher.group(1));
                int timeout = this.getIntProp(conf, key, this.defaultTimeout);
                this.timeouts.put(new Integer(funcId), new Integer(timeout));
            }
        }

        private int getIntProp(Properties conf, String name, int defaultValue) {
            int result = defaultValue;
            try {
                result = Integer.parseInt(conf.getProperty(name));
            }
            catch (Throwable var6) {
                // empty catch block
            }
            return result;
        }

        private int getTimeout(int funcId) {
            int result = this.defaultTimeout;
            Integer timeout = this.timeouts.get(new Integer(funcId));
            if (timeout != null) {
                result = timeout;
            }
            if (result <= 0) {
                result = this.defaultTimeout;
            }
            return result;
        }
    }
}

