/*
 * Decompiled with CFR 0.152.
 */
package com.hczq.hz.client;

import com.hczq.hz.client.AmHttpServicesStub;
import com.hczq.hz.client.SSLIOSessionStrategyFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.NoopUserTokenHandler;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.ManagedNHttpClientConnectionFactory;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.ManagedNHttpClientConnection;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NHttpConnectionFactory;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.protocol.HttpContext;

public class AmHttpAsyncClientFactory {
    volatile PoolingNHttpClientConnectionManager connectionManager;
    volatile CloseableHttpAsyncClient client;
    boolean isShutdown;
    int maxConnections = 5000;
    int maxPerRoute = 1000;
    int connectionTTL = 60000;
    int ioThreadCount = IOReactorConfig.DEFAULT.getIoThreadCount();
    long selectInterval = IOReactorConfig.DEFAULT.getSelectInterval();
    boolean interestOpQueued = IOReactorConfig.DEFAULT.isInterestOpQueued();
    int soLinger = IOReactorConfig.DEFAULT.getSoLinger();
    int soTimeout = IOReactorConfig.DEFAULT.getSoTimeout();
    boolean soKeepalive = IOReactorConfig.DEFAULT.isSoKeepalive();
    boolean tcpNoDelay = true;
    int connectTimeout = IOReactorConfig.DEFAULT.getConnectTimeout();
    int keepAliveIdleTime = 10000;
    Properties conf;

    public AmHttpAsyncClientFactory(Properties conf) {
        String value = conf.getProperty("am.httpClient.socketTimeout");
        if (StringUtils.isNumeric((CharSequence)value)) {
            this.soTimeout = Integer.parseInt(value);
        }
        if (StringUtils.isNumeric((CharSequence)(value = conf.getProperty("am.httpClient.connectTimeout")))) {
            this.connectTimeout = Integer.parseInt(value);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)(value = conf.getProperty("am.httpClient.soKeepalive"))) || StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)value)) {
            this.soKeepalive = Boolean.parseBoolean(value);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)(value = conf.getProperty("am.httpClient.tcpNoDelay"))) || StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)value)) {
            this.tcpNoDelay = Boolean.parseBoolean(value);
        }
        if (StringUtils.isNumeric((CharSequence)(value = conf.getProperty("am.httpClient.maxConnections")))) {
            this.maxConnections = Integer.parseInt(value);
        }
        if (StringUtils.isNumeric((CharSequence)(value = conf.getProperty("am.httpClient.maxPerRoute")))) {
            this.maxPerRoute = Integer.parseInt(value);
        }
        if (StringUtils.isNumeric((CharSequence)(value = conf.getProperty("am.httpClient.connectionTTL")))) {
            this.connectionTTL = Integer.parseInt(value);
        }
        if (StringUtils.isNumeric((CharSequence)(value = conf.getProperty("am.httpClient.ioThreadCount")))) {
            this.ioThreadCount = Integer.parseInt(value);
        }
        if (StringUtils.isNumeric((CharSequence)(value = conf.getProperty("am.httpClient.selectInterval")))) {
            this.selectInterval = Integer.parseInt(value);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)(value = conf.getProperty("am.httpClient.interestOpQueued"))) || StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)value)) {
            this.interestOpQueued = Boolean.parseBoolean(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = conf.getProperty("am.httpClient.soLinger")))) {
            this.soLinger = Integer.parseInt(value);
        }
        if (StringUtils.isNotBlank((CharSequence)(value = conf.getProperty("am.httpClient.keepAliveIdleTime")))) {
            this.keepAliveIdleTime = Integer.parseInt(value);
        }
        this.conf = conf;
    }

    public void shutdown() {
        if (this.client != null) {
            AmHttpAsyncClientFactory.shutdown(this.client);
            this.connectionManager = null;
            this.client = null;
        }
        this.isShutdown = true;
    }

    private static void shutdown(CloseableHttpAsyncClient client) {
        try {
            client.close();
        }
        catch (IOException var2) {
            var2.printStackTrace();
        }
    }

    public synchronized void setupNIOClient() throws IOReactorException {
        if (this.client == null) {
            int httpRequestType = Integer.parseInt(this.conf.getProperty("am.httpClient.requestType", "0"));
            IOReactorConfig config = IOReactorConfig.custom().setIoThreadCount(this.ioThreadCount).setSelectInterval(this.selectInterval).setInterestOpQueued(this.interestOpQueued).setSoLinger(this.soLinger).setSoTimeout(this.soTimeout).setConnectTimeout(this.connectTimeout).setSoKeepAlive(this.soKeepalive).setTcpNoDelay(this.tcpNoDelay).build();
            RegistryBuilder registryBuilder = RegistryBuilder.create();
            if (httpRequestType == 0) {
                registryBuilder.register("http", (Object)NoopIOSessionStrategy.INSTANCE);
            } else {
                registryBuilder.register("https", (Object)SSLIOSessionStrategyFactory.create(this.conf));
            }
            Registry ioSessionFactoryRegistry = registryBuilder.build();
            ManagedNHttpClientConnectionFactory connectionFactory = new ManagedNHttpClientConnectionFactory(){

                public ManagedNHttpClientConnection create(IOSession iosession, ConnectionConfig config) {
                    ManagedNHttpClientConnection conn = super.create(iosession, config);
                    return conn;
                }
            };
            DefaultConnectingIOReactor ioreactor = new DefaultConnectingIOReactor(config);
            this.connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioreactor, (NHttpConnectionFactory)connectionFactory, ioSessionFactoryRegistry, (SchemePortResolver)DefaultSchemePortResolver.INSTANCE, (DnsResolver)SystemDefaultDnsResolver.INSTANCE, (long)this.connectionTTL, TimeUnit.MILLISECONDS);
            this.connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
            this.connectionManager.setMaxTotal(this.maxConnections);
            Map serverConfs = (Map)this.conf.get("am.serverConfs");
            for (AmHttpServicesStub.ServerConf redirectStrategy : serverConfs.values()) {
                if (redirectStrategy.getMaxConnections() <= 0) continue;
                HttpRoute kaStrategy = new HttpRoute(new HttpHost(redirectStrategy.getHost(), redirectStrategy.getPort()));
                this.connectionManager.setMaxPerRoute(kaStrategy, redirectStrategy.getMaxConnections());
            }
            ConnectionConfig connectionConfig1 = ConnectionConfig.custom().setBufferSize(1024).build();
            this.connectionManager.setDefaultConnectionConfig(connectionConfig1);
            RedirectStrategy redirectStrategy1 = new RedirectStrategy(){

                public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                    return false;
                }

                public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                    return null;
                }
            };
            DefaultConnectionKeepAliveStrategy kaStrategy1 = new DefaultConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long keepAlive = super.getKeepAliveDuration(response, context);
                    if (keepAlive == -1L) {
                        keepAlive = AmHttpAsyncClientFactory.this.keepAliveIdleTime;
                    }
                    return keepAlive;
                }
            };
            this.client = HttpAsyncClients.custom().setUserTokenHandler((UserTokenHandler)NoopUserTokenHandler.INSTANCE).setConnectionManager((NHttpClientConnectionManager)this.connectionManager).setRedirectStrategy(redirectStrategy1).setKeepAliveStrategy((ConnectionKeepAliveStrategy)kaStrategy1).setDefaultCookieStore((CookieStore)new BasicCookieStore(){
                private static final long serialVersionUID = 1L;

                public void addCookie(Cookie cookie) {
                }
            }).build();
            this.client.start();
        }
    }

    public CloseableHttpAsyncClient createClient() throws IOException {
        if (this.client == null) {
            this.setupNIOClient();
        }
        return this.client;
    }
}

