package com.ptteng.wealth.util;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

import javax.crypto.*;
import javax.crypto.spec.SecretKeySpec;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;

public final class CryptoUtil {

	public static final String AES_ALGORITHM = "AES";

	private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

	private static KeyGenerator keyGenerator;

	private static Cipher cipher;

	public static final byte[] encrypt(final byte[] inputBytes, String key)
			throws InvalidKeyException, IllegalBlockSizeException,
			BadPaddingException, NoSuchAlgorithmException,
			NoSuchPaddingException {
		byte[] keyBytes = Base64.decodeBase64(key);
		SecretKey getSecretKey = getSecretKey(keyBytes);
		return encrypt(inputBytes, getSecretKey);
	}

	public static final byte[] decrypt(final byte[] inputBytes, String key)
			throws InvalidKeyException, IllegalBlockSizeException,
			BadPaddingException, NoSuchAlgorithmException,
			NoSuchPaddingException {
		byte[] keyBytes = Base64.decodeBase64(key);
		SecretKey getSecretKey = getSecretKey(keyBytes);
		return decrypt(inputBytes, getSecretKey);
	}

	public static final SecretKey generateSecretKey()
			throws NoSuchAlgorithmException {
		return generateSecretKey(128);
	}

	/**
	 * 把+还成-， 把/换成_
	 * 
	 * @param base64Str
	 * @return
	 */
	public static final String encryptReplace(String base64Str) {
		return StringUtils.isNotBlank(base64Str) ? StringUtils.replace(
				base64Str, "+", "-").replace("/", "_") : base64Str;
	}

	/**
	 * 把-还成+， 把_换成/
	 * 
	 * @param base64Str
	 * @return
	 */
	public static final String decryptReplace(String base64Str) {
		return StringUtils.isNotBlank(base64Str) ? StringUtils.replace(
				base64Str, "-", "+").replace("_", "/") : base64Str;
	}

	private static final synchronized void initKeyGenerator()
			throws NoSuchAlgorithmException {
		if (null == keyGenerator) {
			keyGenerator = KeyGenerator.getInstance(AES_ALGORITHM);
		}
	}

	private static final synchronized void initCipher()
			throws NoSuchAlgorithmException, NoSuchPaddingException {
		if (null == cipher) {
			cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
		}
	}

	private static final synchronized byte[] encrypt(final byte[] inputBytes,
			Key key) throws IllegalBlockSizeException, BadPaddingException,
			NoSuchAlgorithmException, NoSuchPaddingException,
			InvalidKeyException {
		initCipher();
		cipher.init(Cipher.ENCRYPT_MODE, key);
		return cipher.doFinal(inputBytes);
	}

	public static final synchronized byte[] decrypt(final byte[] inputBytes,
			Key key) throws NoSuchAlgorithmException, NoSuchPaddingException,
			InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
		initCipher();
		cipher.init(Cipher.DECRYPT_MODE, key);
		return cipher.doFinal(inputBytes);
	}

	public static final synchronized SecretKey generateSecretKey(
			final int keyLengthInBits) throws NoSuchAlgorithmException {
		initKeyGenerator();
		keyGenerator.init(keyLengthInBits);
		return keyGenerator.generateKey();
	}

	private static final SecretKey getSecretKey(final byte[] key) {
		return new SecretKeySpec(key, AES_ALGORITHM);
	}
	
	
	public static void main(String[] args) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, 
				NoSuchAlgorithmException, NoSuchPaddingException {
		
		byte[] s = CryptoUtil.decrypt(Base64.decodeBase64("UEJwqPrO3uB4WoEQe57NLQ=="), new SecretKeySpec("abcdefgabcdefgaa".getBytes(), "AES"));
		System.out.println(new String(s));
	}

}