package com.ptteng.wealth.interceptor;

import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.model.UserOpenidRelation;
import com.ptteng.wealth.user.service.UserOpenidRelationService;
import com.ptteng.wealth.user.service.UserService;
import com.ptteng.wealth.util.CryptoUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.crypto.spec.SecretKeySpec;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class UserInterceptor extends HandlerInterceptorAdapter {

    private static final Log log = LogFactory.getLog(UserInterceptor.class);

    @Autowired
    private UserService userService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private UserOpenidRelationService userOpenidRelationService;

    @Autowired
    private String secretKey = "abcDEfg12cde89wk";

    public static void main(String[] args) throws UnsupportedEncodingException {
        String x = URLEncoder.encode("p/hello", "utf-8");
        log.info(x);

    }

    /**
     * In this case intercept the request BEFORE it reaches the controller
     */
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
    	log.info("request uri: "+request.getRequestURI());

        Cookie[] cookies = request.getCookies();
        log.info("get cookies  " + (ArrayUtils.isEmpty(cookies) ? "null" : Arrays.asList(cookies)));
        Map<String, String> maps = cookieUtil.getIdentity(request);
        log.info("get maps  from cookie is " + maps);
        Long uid = cookieUtil.getID(request);

        String accessToken = request.getParameter("access_token");

        log.info(" L1:  uid " + uid + " accessToken " + accessToken);
        if (null == uid && StringUtils.isNotBlank(accessToken)) {
            byte[] token = CryptoUtil.decrypt(Base64.decodeBase64(CryptoUtil.decryptReplace(accessToken)), new SecretKeySpec(secretKey.getBytes(), "AES"));
            String secret = new String(token);
            String[] secretArr = secret.split("\\|"); //手机号|用户类型
            if (secretArr.length == 2) {
                //判断Type，如果是机构登录，再判断是否是手机号登录
                String mobile = secretArr[0];
                String type = secretArr[1];
                String t = UserOpenidRelation.Type_Person_Mobile;
                if("org".equals(type)){
                    t = UserOpenidRelation.Type_Org_Mobile;
                }

                Long id = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, t);
                log.info(" L2:  useropendid : "+id);
                if (null != id) {
                    UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(id);
                    log.info(" L3  openidRelation: "+ userOpenidRelation);
                    int code = 0;
                    Long userId = 0L;
                    if (null == userOpenidRelation) {
                        code = -2000;
                    } else {
                        userId = userOpenidRelation.getTypeId();
                        log.info(" L4: USER ID : "+uid);
                        User user = userService.getObjectById(userId);
                        if (null == user) {
                            code = -2000;
                        } else {
                            //用户处于冻结状态时，不允许登陆
                            if(User.FREEZE_YES.equals(user.getFreezeStatus())){
                                code = -2026;
                            }
                            if(user.getStatus().equals(User.USER_UNACTIVIATE)){
                                code = -2024;
                            }
                            if("org".equals(type) && !User.TYPE_ORG.equals(user.getType())){
                                code = -2019;
                            }
                            if("mobile".equals(type) && !User.TYPE_PERSON.equals(user.getType())){
                                code = -2020;
                            }
                        }
                    }

                    if (0 == code) {
                        Map<String, String> cookieMap = new HashMap();
                        cookieMap.put(CookieUtil.USER_ID, userId + "");
                        cookieMap.put(type, mobile);
                        cookieUtil.setCookieMaxAge(2 * 60 * 60);
                        cookieUtil.setIdentity(request, response, maps, userId);
                        uid = userId;
                        log.info("授权成功 mobile " + mobile + ", type " + type);
                    } else {
                        log.info("授权成功 mobile " + mobile + ", type " + type + " error code " + code);
                    }

                } else {
                    log.info("用户不存在 mobile " + mobile + ", type " + type);
                }
            } else {
                log.info("参数不合法,不能授权登录");
            }

        }



        if (uid == null) {
            log.error("not legal user request");
            return noLogin(response,request);

        }
        log.info("get uid  from cookie is " + uid);
        User user = this.userService.getObjectById(uid);
        if (user == null) {
            log.error(uid + " not get any data ");
            return noLogin(response,request);
        } else {
            log.info("get usr " + user);
            request.setAttribute("user", user);
        }
        log.info("get uid is " + uid);

        return true;
    }

    private boolean wrongUser(HttpServletResponse response) throws IOException {
        response.sendRedirect("/a/wrong");
        return false;

    }

    //用户未登录
    private boolean noLogin(HttpServletResponse response,HttpServletRequest request) throws IOException {

        log.info(" user don't login");

        RequestDispatcher rd =  request.getRequestDispatcher("/r/json/noLogin.json");
        try {

            rd.forward(request,response);
        } catch (ServletException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return false;

    }

    @Override
    public void postHandle(HttpServletRequest request,
                           HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {
        log.info("p =========================================== ");
    }

    /**
     * 获取跳转链接的地址
     *
     * @param request
     * @return
     */
    public String getInterceptorUrl(HttpServletRequest request) {

        String interceptorUrl = request.getRequestURI() + (null == request.getQueryString() ? "" : "?" + request.getQueryString()).toString();
        interceptorUrl = interceptorUrl.replace("/app/", "/");
        log.info("get getInterceptorUrl is " + interceptorUrl);
        return interceptorUrl;
    }
}
