package com.ptteng.wealth.finance.controller;

import com.gemantic.common.util.PasswordUtils;
import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.AutoDocBailRechargeIn;
import com.ptteng.wealth.consign.model.in.BindingBankIn;
import com.ptteng.wealth.consign.model.out.AutoDocBailRechargeOut;
import com.ptteng.wealth.consign.model.out.BindingBank;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.FundHistory;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.FundHistoryService;
import com.ptteng.wealth.finance.util.PayAccountUtil;
import com.ptteng.wealth.user.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by asus on 2016/6/26.
 */
@Controller
public class PayContorller extends BaseController {

    @Autowired
    public FundHistoryService fundHistoryService;
    private Log payLog = LogFactory.getLog("user_pay");

    private Integer getVerifyCode(Long uid, Integer paymentType, Long orderId, String paypwd) throws Exception {
        Integer result = 0;
        if (null == paymentType || null == paypwd || null == orderId || null == uid) {
            payLog.info("params is null");
            return -1000;
        }
        payLog.info("Verify Parameter : uid = " + uid + " orderId = " + orderId + " paymentType = " + paymentType + " password = " + paypwd);
        if (!paymentType.equals(Order.Pay_Type_fund) && !paymentType.equals(Order.Pay_Type_check) && !paymentType.equals(Order.Pay_Type_post) && !paymentType.equals(Order.Pay_Type_klfund)) {
            payLog.info("paymentType illegal");
            return -3010;
        }
        User user = userService.getObjectById(uid);
        if (User.FREEZE_YES.equals(user.getFreezeStatus())) {
            payLog.info("paymentType illegal");
            return -3021;
        }
        Order order = orderService.getObjectById(orderId);
        if (Order.STATUS_COMPLETE.equals(order.getStatus())) {
            payLog.info(" order is complete ");
            return -3009;
        }
        if (paymentType == Order.Pay_Type_fund) {
            if (user.getPayPwd().isEmpty()) {
                payLog.info("no payPwd");
                return -3016;
            }
            payLog.info(" inputpass: " + paypwd + "  dbpasswords: " + user.getPayPwd());
            boolean verify = paypwd.equals(user.getPayPwd().trim());
            payLog.info(" verify: " + verify);
            if (!verify) {
                payLog.info(uid + " wrong password " + paypwd);
                return -2004;
            }
        } else if (paymentType == Order.Pay_Type_klfund || paymentType == Order.Pay_Type_check || paymentType == Order.Pay_Type_post) {
            String pass = PasswordUtils.encode(paypwd);
            String passwords = user.getPwd();
            payLog.info(" inputpass: " + pass + "  dbpasswords: " + passwords);
            boolean verify = passwords.trim().equals(pass.trim());
            payLog.info(" verify: " + verify);
            if (!verify) {
                payLog.info(uid + " wrong password " + paypwd);
                return -2004;
            }
        }
        return result;
    }

    //B2B余额支付
    @RequestMapping(value = "/a/u/pay/{orderId}", method = RequestMethod.POST)
    public String b2bPay(HttpServletRequest request, ModelMap model,
                         @PathVariable Long orderId, String paypwd, Integer paymentType) throws Exception {

        try {
            payLog.info("=======================================================================");
            payLog.info("PARAM orderId = " + orderId + " paypassword = " + paypwd + " payment type = " + paymentType);
            Long uid = getUserId(request);
            payLog.info("PARAM uid = " + uid);
            Integer result = getVerifyCode(uid, paymentType, orderId, paypwd);
            payLog.info("Step 1: verify result: " + result);
            if (result.equals(0)) {
                BigDecimal money = new BigDecimal("0");
                User user = userService.getObjectById(uid);
                Order order = orderService.getObjectById(orderId);
                order.setPayType(paymentType);
                orderService.update(order);
                payLog.info("Step 2: user id : " + uid + " order id: " + orderId + " order no: " + order.getOrderNo() + " payment type: " + paymentType);
                //代销接口余额支付
                if (Order.Pay_Type_fund.equals(paymentType)) {

                    payLog.info("Step 3: ===  DAIXIAO PAY .. ");
                    AutoDocBailRechargeIn autoDocBailRechargeIn = new AutoDocBailRechargeIn();
                    AutoDocBailRechargeOut autoDocBailRechargeOut = null;
                    BindingBank bindingBank = null;
                    try {
                        //一.  机构用户处理逻辑
                        BindingBankIn bindingBankIn = new BindingBankIn();
                        bindingBankIn.setUserId(user.getId() + "");
                        bindingBankIn.setFundAccount(user.getFundAccount());
                        bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
                        List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
                        for (BindingBank bank : bindingBanks) {
                            if (bank.getBankNo().equals("ZLRT")) {
                                bindingBank = bank;
                                break;
                            }
                        }
                        payLog.info(" BANK:  " + bindingBank);
                        AutoDocBailRechargeIn organBindCardIn = new AutoDocBailRechargeIn();
                        organBindCardIn.setUserId(user.getId() + "");
                        organBindCardIn.setFundAccount(user.getFundAccount());
                        organBindCardIn.setPassword(paypwd);
                        organBindCardIn.setBranchNo(GlobalConstant.BRANCH_NO);
                        organBindCardIn.setFundAccountG(user.getFundAccount());
                        organBindCardIn.setOpbusinessFlag("8035");
                        organBindCardIn.setOccurBalanceG(order.getPriceTot());
                        organBindCardIn.setTiedCardType("0");
                        organBindCardIn.setMoneyType("0");
                        organBindCardIn.setFundCompany(GlobalConstant.FUND_COMPANY);
                        organBindCardIn.setFundCode(990006 + "");
                        organBindCardIn.setPayType("0");
                        organBindCardIn.setChannelResource("");
                        organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                        organBindCardIn.setBankNoDk("ZLRT");
                        organBindCardIn.setBankAccountDk(bindingBank.getBankAccount());
                        organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                        organBindCardIn.setAutotransNo("");
                        payLog.info("organBindCardIn : " + organBindCardIn);
                        autoDocBailRechargeOut = consignmentService.autoDocBailRecharge(organBindCardIn);
                    } catch (Exception e) {
                        e.printStackTrace(System.out);
                        payLog.error(e.getMessage());
                    }
                    payLog.info(autoDocBailRechargeOut);
                    model.put("code", autoDocBailRechargeOut.getErrorNo());
                    model.put("message", autoDocBailRechargeOut.getErrorInfo());
                    payLog.info("Step 4: error code is " + autoDocBailRechargeOut.getErrorNo());
                    payLog.info("Step 4: error info is " + autoDocBailRechargeOut.getErrorInfo());
                    if (0 == autoDocBailRechargeOut.getErrorNo()) {
                        order.setStatus(Order.STATUS_COMPLETE);
                        order.setPayType(paymentType);
                        order.setPayAt(System.currentTimeMillis());
                        orderService.update(order);

                        //更新最后小额时间与当日小额额度
                        if(Order.Type_small.equals(order.getOrderType())){
                            smallLoanOver(order.getUid(), order.getPriceTot());
                        }

                        payLog.info("Step 5: pay  db result : 0 ");
                        payLog.info("Step 6 : SUCCESS END ========== ");
                    } else {
                        payLog.info("update fund order success , order fail");
                        payLog.info("Step 6 : FAIL ========== ");
                    }
                    return "/common/pay";
                }
                //开磷账户支付
                if (Order.Pay_Type_klfund.equals(paymentType) || Order.Pay_Type_check.equals(paymentType) || Order.Pay_Type_post.equals(paymentType)) {
                    payLog.info("Step 3: ===  KAILIN  PAY ..  payment type: " + paymentType);
                    String accountCode = PayAccountUtil.getRightPayAccount(order.getDepartment());
                    //非常关键，获取要支付的开磷账号
                    Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, accountCode);
                    payLog.info("Step 4: account code:  " + accountCode + "  user account id: " + userAccountId);
                    if (null != userAccountId) {
                        //进行实际订单支付及记录流水操作
                        UserAccountRelation userAccountRelationBefore = userAccountRelationService.getObjectById(userAccountId);
                        BigDecimal before = userAccountRelationBefore.getMoney();
                        payLog.info("account amount before : " + before);

                        result = userAccountRelationService.payOrder(orderId, userAccountId, paymentType);

                        if(result == 0 ){
                            UserAccountRelation userAccountRelationAfter = userAccountRelationService.getObjectById(userAccountId);
                            BigDecimal after = userAccountRelationAfter.getMoney();
                            payLog.info("account amount after : " + after);
                            Long id = fundHistoryService.insertTransaction(order, user, FundHistory.TYPE_Pay, FundHistory.DETAIL_Pay, userAccountId,
                                    order.getPriceTot() , null, FundHistory.FLAG_Out, FundHistory.STATUS_Pass, null, before, after);
                            payLog.info("insert transaction success : id " + id);
                        }else {
                            payLog.info("pay fail and code is " + result);
                        }

                    } else {
                        result = -3022;
                    }

                    //更新最后小额时间与当日小额额度
                    if(Order.Type_small.equals(order.getOrderType())){
                        smallLoanOver(order.getUid(), order.getPriceTot());
                    }

                    payLog.info("Step 5: pay  db result: " + result);
                    model.addAttribute("code", result);
                    payLog.info("Step 6 : SUCCESS END ========== ");
                }
            } else {
                model.addAttribute("code", result);
            }
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            payLog.error(t.getMessage());
            payLog.error("oms pay error", t);
            payLog.info("EXCEPTION END ========== ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //小额订单完成逻辑
    private void smallLoanOver(Long uid, BigDecimal totalFee) throws Exception {

        Fund fund = fundService.getObjectById(uid);

        //更新最后小额申请时间
        Long lastSmallLoan = fund.getLastSmallLoan();
        fund.setLastSmallLoan(System.currentTimeMillis());
        payLog.info("update lastSmallLoan success : " + lastSmallLoan + " >>>>>>>>>> " + fund.getLastSmallLoan());
        //更新今日小额订单数额
        BigDecimal todaySmallLoan = fund.getTodaySmallLoan();
        fund.setTodaySmallLoan(todaySmallLoan.add(totalFee));
        payLog.info("update todaySmallLoan success : " + todaySmallLoan + " >>>>>>>>>> " + fund.getTodaySmallLoan());
        fundService.update(fund);
        payLog.info("update fund success : " + fund);

    }
}
