package com.ptteng.wealth.product.controller;

import com.ptteng.wealth.finance.model.ProductDaily;
import com.ptteng.wealth.finance.service.ProductDailyService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * ProductDaily  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ProductDailyController {
	private static final Log log = LogFactory.getLog(ProductDailyController.class);

	@Autowired
	private ProductDailyService productDailyService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/productDaily", method = RequestMethod.GET)
	public String getproductDailyList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/productDaily  to /productDaily/view/productDailyList");

		return "/wealth-finance-service/productDaily/view/productDailyList";
	}
    
    

    
	
	@RequestMapping(value = "/c/productDaily/{id}", method = RequestMethod.GET)
	public String getProductDaily(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/productDaily/" + id + "  to /productDaily/view/productDailyDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/wealth-finance-service/productDaily/view/productDailyDetail";
	}
	
	
	
	    
	

	@RequestMapping(value = "/a/productDaily/{id}", method = RequestMethod.GET)
	public String getProductDailyJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			ProductDaily productDaily = productDailyService.getObjectById(id);
			log.info("get productDaily data is " + productDaily);

			model.addAttribute("code", 0);

			model.addAttribute("productDaily", productDaily);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get productDaily error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/wealth-finance-service/productDaily/json/productDailyDetailJson";
	}

	@RequestMapping(value = "/a/productDaily/{id}", method = RequestMethod.PUT)
	public String updateProductDailyJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, ProductDaily productDaily) throws Exception {
		
		log.info("update productDaily : productDaily= " + productDaily);
		
		try {
			
			productDailyService.update(productDaily);

			model.addAttribute("code", 0);

			model.addAttribute("productDaily", productDaily);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update productDaily error,id is  " + productDaily.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/productDaily", method = RequestMethod.POST)
	public String addProductDailyJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, ProductDaily productDaily) throws Exception {
		
		log.info("update productDaily : productDaily= " + productDaily);
		
		try { 
			productDaily.setId(null);

			productDailyService.insert(productDaily);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add productDaily error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/productDaily/{id}", method = RequestMethod.DELETE)
	public String deleteProductDailyJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete productDaily : id= " + id);
		try {
			productDailyService.delete(id);

			log.info("add productDaily success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete productDaily error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/productDaily", method = RequestMethod.GET)
	public String getMultiProductDailyJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<ProductDaily> productDailyList = productDailyService.getObjectsByIds(idList);
			log.info("get  productDaily data is " + productDailyList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",productDailyList.size());

			model.addAttribute("productDailyList", productDailyList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get productDaily error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/wealth-finance-service/productDaily/json/productDailyListJson";
	}
	
	
	
	
	
}

