package com.ptteng.wealth.product.controller;

import com.ptteng.wealth.finance.model.Product;
import com.ptteng.wealth.finance.service.ProductService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * Product  crud
 *
 * @author liangxiaojin
 * @Date 2014-4-16 13:43
 */
@Controller
public class ProductController {
    private static final Log log = LogFactory.getLog(ProductController.class);

    @Autowired
    private ProductService productService;

    /**
     * 首页开磷宝产品列表 查询状态是上架的产品
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/product/list", method = RequestMethod.GET)
    public String getproductList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model,Integer page,Integer size ) throws Exception {
        log.info("page===" + page + "size====" + size);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }


        log.info("pageList : page= " + start + " , size=" + size);

        try {
            List<Product> products = new ArrayList<>();
            List<Long> productIds =  productService.getProductIdsByStatus(Product.STATUS_1, start, size);
            log.info(" get product list ids size = "+productIds.size());
            if(CollectionUtils.isEmpty(productIds)){
                log.info(Product.STATUS_1+" get product list ids size = 0");

            }else{
                products = productService.getObjectsByIds(productIds);
                log.info(Product.STATUS_1 + " get product list ids size = " + products.size());
                model.addAttribute("list", products);
            }


            Integer total =  productService.countProductIdsByStatus(Product.STATUS_1);
            log.info(" get product total size = "+total);
            int  totalPage =1;
            if (total>0) {
                totalPage=(total-1)/size +1;
            }
            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("size", size);
            model.addAttribute("page", page);

        }catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lotteryList  error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -1);
        }

        log.info("/web/product  to /product/json/productList");

        return "/wealth-finance-service/product/json/productListJson";
    }




    @RequestMapping(value = "/a/product/{id}", method = RequestMethod.GET)
    public String getProduct(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {
        log.info("get product id = " + id);
        try {
            Product product = productService.getObjectById(id);
            log.info("get product data is " + product);
            if(null == product){
                log.info(" id = "+id+" product is not exit ");
                model.addAttribute("code",-700000015);
                return "/data/json";
            }

            model.addAttribute("code", 0);

            model.addAttribute("product", product);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get product error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/product/json/productDetailJson";
    }


    @RequestMapping(value = "/web/a/product/{id}", method = RequestMethod.GET)
    public String getProductJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Product product = productService.getObjectById(id);
            log.info("get product data is " + product);

            model.addAttribute("code", 0);

            model.addAttribute("product", product);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get product error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/wealth-common-service/product/json/productDetailJson";
    }

    @RequestMapping(value = "/web/a/product/{id}", method = RequestMethod.PUT)
    public String updateProductJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Product product) throws Exception {

        log.info("update product : product= " + product);

        try {

            productService.update(product);

            model.addAttribute("code", 0);

            model.addAttribute("product", product);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update product error,id is  " + product.getId());
            model.addAttribute("code", -6003);

        }

        return "/data/json";
    }

    @RequestMapping(value = "/web/a/product", method = RequestMethod.POST)
    public String addProductJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Product product) throws Exception {

        log.info("update product : product= " + product);

        try {
            product.setId(null);

            productService.insert(product);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add product error ");
            model.addAttribute("code", -6002);
        }

        return "/data/json";
    }

    @RequestMapping(value = "/web/a/product/{id}", method = RequestMethod.DELETE)
    public String deleteProductJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete product : id= " + id);
        try {
            productService.delete(id);

            log.info("add product success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete product error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/web/a/multi/product", method = RequestMethod.GET)
    public String getMultiProductJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<Product> productList = productService.getObjectsByIds(idList);
            log.info("get  product data is " + productList);

            model.addAttribute("code", 0);
            model.addAttribute("total", productList.size());

            model.addAttribute("productList", productList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get product error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/wealth-common-service/product/json/productListJson";
    }


}

