package com.ptteng.wealth.finance.controller;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.PasswordUtils;
import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.admin.service.ConstantService;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.AutoDocBailRechargeIn;
import com.ptteng.wealth.consign.model.in.BalanceInquiryIn;
import com.ptteng.wealth.consign.model.in.BindingBankIn;
import com.ptteng.wealth.consign.model.out.AutoDocBailRechargeOut;
import com.ptteng.wealth.consign.model.out.BalanceInquiryOut;
import com.ptteng.wealth.consign.model.out.BindingBank;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.FundHistory;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.FundHistoryService;
import com.ptteng.wealth.finance.service.FundService;
import com.ptteng.wealth.finance.service.OrderService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.finance.util.FinanceConstant;
import com.ptteng.wealth.finance.util.PayAccountUtil;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.UserService;
import com.ptteng.wealth.user.util.Constant;
import com.ptteng.wealth.util.DebtConstant;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.weaver.ast.Or;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.finance.model.LoanApply;
import com.ptteng.wealth.finance.service.LoanApplyService;
import org.springframework.web.bind.annotation.RequestParam;

import static java.lang.Math.ceil;

/**
 * LoanApply  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class LoanApplyController extends BaseController {
    private static final Log debtLog = LogFactory.getLog("debt_log");
    private static final Log depositPayLog = LogFactory.getLog("deposit_pay_log");

    @Autowired
    public FundHistoryService fundHistoryService;

    //40、取消借款
    @RequestMapping(value = "/a/u/cancel/loan/{id}", method = RequestMethod.PUT)
    public String cancelLoan(HttpServletRequest request, ModelMap model, @PathVariable Long id) throws Exception {
        Long uid = cookieUtil.getID(request);
        debtLog.info("delete debt : " + id);
        if (null == uid) {
            model.addAttribute("code", -2000);
            debtLog.info("user not exist");
            return "/common/success";
        }
        try {
            //判断取消借款是否状态在审核通过之前
            LoanApply loanApply = loanApplyService.getObjectById(id);
            if (null == loanApply) {
                model.addAttribute("code", -3007);
                debtLog.info("debt not exist");
                return "/common/success";
            }
            if (!uid.equals(loanApply.getUid())) {
                debtLog.info("is not your loanApply");
                model.addAttribute("code", -3005);
                return "/common/success";
            }
            Integer status = loanApply.getStatus();
            if (status >= 1) {
                debtLog.info("debt apply verify pass");
                model.addAttribute("code", -3003);
                return "/common/success";
            }

            //取消借款申请
            loanApply.setStatus(LoanApply.STATUS_CANCEL);
            loanApply.setType(LoanApply.TYPE_CANCEL);
            loanApplyService.update(loanApply);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            debtLog.error(t.getMessage());
            debtLog.error("delete debt : " + id + " error");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    /**
     * ============================================================
     * 列表
     */

    //41、各赊销数量
    @RequestMapping(value = "/a/u/loan/count", method = RequestMethod.GET)
    public String getDebtNum(HttpServletRequest request, ModelMap model) throws Exception {

        Long uid = getUserId(request);
        debtLog.info("get user : " + uid + " debt list ");
        try {
            Integer applyCount = loanApplyService.countLoanApplyIdsByUidAndType(uid, LoanApply.TYPE_VERIFYING);
            Integer repayCount = loanApplyService.countLoanApplyIdsByUidAndType(uid, LoanApply.TYPE_REPAY);
            Integer overTimeCount = loanApplyService.countLoanApplyIdsByUidAndType(uid, LoanApply.TYPE_OVERTIME);
            Integer clearCount = loanApplyService.countLoanApplyIdsByUidAndType(uid, LoanApply.TYPE_CLEAR);
            model.addAttribute("code", 0);
            model.addAttribute("applyCount", applyCount);
            model.addAttribute("repayCount", repayCount);
            model.addAttribute("overCount", overTimeCount);
            model.addAttribute("clearCount", clearCount);

            Integer historyTotalLoan = 0;
            Integer totalLoan = 0;
            BigDecimal historyTotalLoanMoney = new BigDecimal("0");
            BigDecimal totalLoanMoney = new BigDecimal("0");
            List<Long> idLs = loanApplyService.getLoanApplyIdsByUid(uid, 0, Integer.MAX_VALUE);
            List<LoanApply> loanApplies = loanApplyService.getObjectsByIds(idLs);
            historyTotalLoan = idLs.size();
            for (LoanApply loanApply : loanApplies) {
                historyTotalLoanMoney = historyTotalLoanMoney.add(loanApply.getDebtCount());
                if (loanApply.getStatus().equals(LoanApply.STATUS_CLEAR) || loanApply.getStatus().equals(LoanApply.STATUS_REFUSE)
                || loanApply.getStatus().equals(LoanApply.STATUS_KAILIN_REFUSE) || loanApply.getStatus().equals(LoanApply.STATUS_CANCEL)) {
                    continue;
                }
                totalLoan++;
                totalLoanMoney = totalLoanMoney.add(loanApply.getDebtCount());
            }

            Fund fund = fundService.getObjectById(uid);
            model.addAttribute("fund", fund);
            model.addAttribute("historyTotalLoan", historyTotalLoan);
            model.addAttribute("totalLoan", totalLoan);
            model.addAttribute("historyTotalLoanMoney", historyTotalLoanMoney);
            model.addAttribute("totalLoanMoney", totalLoanMoney);

        } catch (Throwable t) {
            t.printStackTrace();
            debtLog.error(t.getMessage());
            debtLog.error("et user debt list error, uid is  " + uid);
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/loan/json/getLoanNum";
    }

    //42、申请借款列表
    @RequestMapping(value = "/a/u/loan/apply/list", method = RequestMethod.GET)
    public String getLoanApply(HttpServletRequest request, ModelMap model,
                               @RequestParam(required = false, defaultValue = "1") Integer page,
                               @RequestParam(required = false, defaultValue = "10") Integer size) throws Exception {
        int firstNmuber = (page - 1) * size;
        Long uid = cookieUtil.getID(request);
        debtLog.info("get user : " + uid + " debt list ");

        try {
            List<Long> debtApplieIds = loanApplyService.getLoanApplyIdsByUidAndType(uid, LoanApply.TYPE_VERIFYING, firstNmuber, size);
            List<LoanApply> loanApplys = loanApplyService.getObjectsByIds(debtApplieIds);
            Integer totalSize = loanApplyService.countLoanApplyIdsByUidAndType(uid, LoanApply.TYPE_VERIFYING);
            Integer totalPage = (((totalSize - 1)) / size) + 1;

            model.addAttribute("code", 0);
            model.addAttribute("totalpage", totalPage);
            model.addAttribute("loanApplys", loanApplys);

        } catch (Throwable t) {
            t.printStackTrace();
            debtLog.error(t.getMessage());
            debtLog.error("et user debt list error, uid is  " + uid);
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/loan/json/applyLoanList";
    }

    //43、还款中借款列表
    @RequestMapping(value = "/a/u/loan/repay/list", method = RequestMethod.GET)
    public String getLoanRepay(HttpServletRequest request, ModelMap model,
                               @RequestParam(required = false, defaultValue = "1") Integer page,
                               @RequestParam(required = false, defaultValue = "10") Integer size) throws Exception {


        HashMap<Long, BigDecimal> id_supposeRepay = new HashMap<>();
        BigDecimal dayCount = new BigDecimal("0");
        BigDecimal supposeRepay = new BigDecimal("0");
        BigDecimal debtCount = new BigDecimal("0");
        BigDecimal rate = new BigDecimal("0");
        Long debtStart = 0L;
        Long time = 0L;

        int firstNmuber = (page - 1) * size;
        Long uid = cookieUtil.getID(request);
        debtLog.info("get user : " + uid + " debt list ");
        try {
            List<Long> debtApplieIds = loanApplyService.getLoanApplyIdsByUidAndType(uid, LoanApply.TYPE_REPAY, firstNmuber, size);
            List<LoanApply> loanApplys = loanApplyService.getObjectsByIds(debtApplieIds);
            Integer totalSize = loanApplyService.countLoanApplyIdsByUidAndType(uid, LoanApply.TYPE_REPAY);
            Integer totalPage = (((totalSize - 1)) / size) + 1;
            for (LoanApply loanApply : loanApplys) {
                if(!LoanApply.ORDER_TYPE_SMALL.equals(loanApply.getOrderType())){
                    //借款本金利率
                    debtCount = loanApply.getDebtCount();
                    rate = loanApply.getRate();

                    //获取当前借款时间
                    debtStart = MyTimeUtil.getDateZeroTimeMillions(loanApply.getDebtAt()).getTime();
                    time = System.currentTimeMillis() - debtStart;
                    dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME));

                    //计算当前本息
                    supposeRepay = caculate(debtCount, rate, dayCount).add(debtCount);
                    id_supposeRepay.put(loanApply.getId(), supposeRepay);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("totalpage", totalPage);
            model.addAttribute("loanApplys", loanApplys);
            model.addAttribute("id_supposeRepay", id_supposeRepay);

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            t.printStackTrace(System.err);
            debtLog.error(t.getMessage());
            debtLog.error("et user debt list error, uid is  " + uid);
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/loan/json/repayLoanList";
    }

    //44、逾期借款列表
    @RequestMapping(value = "/a/u/loan/over/list", method = RequestMethod.GET)
    public String getOverTimeRepay(HttpServletRequest request, ModelMap model,
                                   @RequestParam(required = false, defaultValue = "1") Integer page,
                                   @RequestParam(required = false, defaultValue = "10") Integer size) throws Exception {

        HashMap<Long, BigDecimal> id_totalRepay = new HashMap<>();
        HashMap<Long, BigDecimal> id_dayCount = new HashMap<>();
        HashMap<Long, BigDecimal> id_overRepay = new HashMap<>();
        HashMap<Long, BigDecimal> id_totalMoney = new HashMap<>();
        BigDecimal dayCount = new BigDecimal("0");
        BigDecimal overRepay = new BigDecimal("0");
        BigDecimal totalRepay = new BigDecimal("0");
        BigDecimal debtCount = new BigDecimal("0");
        BigDecimal overRate = new BigDecimal("0");
        BigDecimal repayLine = new BigDecimal("0");
        BigDecimal rate = new BigDecimal("0");
        Long debtStart = 0L;
        Long time = 0L;
        int firstNmuber = (page - 1) * size;
        Long uid = cookieUtil.getID(request);
        debtLog.info("get user : " + uid + " debt list ");
        try {
            List<Long> debtApplieIds = loanApplyService.getLoanApplyIdsByUidAndType(uid, LoanApply.TYPE_OVERTIME, firstNmuber, size);
            List<LoanApply> loanApplys = loanApplyService.getObjectsByIds(debtApplieIds);
            Integer totalSize = loanApplyService.countLoanApplyIdsByUidAndType(uid, LoanApply.TYPE_OVERTIME);
            Integer totalPage = (((totalSize - 1)) / size) + 1;
            for (LoanApply loanApply : loanApplys) {
                //借款本金、利率
                debtCount = loanApply.getDebtCount();
                overRate = loanApply.getOverRate();
                rate = loanApply.getRate();

                //获取总借款利息
                repayLine = new BigDecimal(loanApply.getRepayLine());
                totalRepay = caculate(debtCount, rate, repayLine).add(debtCount);
                id_totalRepay.put(loanApply.getId(), totalRepay);

                //获取当前逾期时间
                debtStart = MyTimeUtil.getDateZeroTimeMillions(loanApply.getDebtAt()).getTime();
                time = System.currentTimeMillis() - debtStart;
                dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);
                id_dayCount.put(loanApply.getId(), dayCount);

                //获取当前罚息
                overRepay = caculate(totalRepay, overRate, dayCount);
                id_overRepay.put(loanApply.getId(), overRepay);

                //待还总额
                BigDecimal totalMoney = totalRepay.add(overRepay);
                id_totalMoney.put(loanApply.getId(), totalMoney);
            }

            model.addAttribute("code", 0);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("loanApplys", loanApplys);
            model.addAttribute("id_totalRepay", id_totalRepay);
            model.addAttribute("id_dayCount", id_dayCount);
            model.addAttribute("id_overRepay", id_overRepay);
            model.addAttribute("id_totalMoney", id_totalMoney);

        } catch (Throwable t) {
            t.printStackTrace();
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/loan/json/overTimeRepayLoanList";
    }

    //45、还清借款列表
    @RequestMapping(value = "/a/u/loan/clear/list", method = RequestMethod.GET)
    public String getClearRepay(HttpServletRequest request, ModelMap model,
                                @RequestParam(required = false, defaultValue = "1") Integer page,
                                @RequestParam(required = false, defaultValue = "10") Integer size) throws Exception {
        int firstNmuber = (page - 1) * size;
        Long uid = cookieUtil.getID(request);
        debtLog.info("get user : " + uid + " debt list ");
        User user = userService.getObjectById(uid);

        try {
            List<Long> debtApplieIds = loanApplyService.getLoanApplyIdsByUidAndType(uid, LoanApply.TYPE_CLEAR, firstNmuber, size);
            List<LoanApply> loanApplys = loanApplyService.getObjectsByIds(debtApplieIds);
            Integer totalSize = loanApplyService.countLoanApplyIdsByUidAndType(uid, LoanApply.TYPE_CLEAR);
            Integer totalPage = (((totalSize - 1)) / size) + 1;

            model.addAttribute("code", 0);
            model.addAttribute("totalpage", totalPage);
            model.addAttribute("loanApplys", loanApplys);

        } catch (Throwable t) {
            t.printStackTrace();
            debtLog.error(t.getMessage());
            debtLog.error("et user debt list error, uid is  " + uid);
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/loan/json/clearLoanList";
    }


    /**
     * ========================== 详情页======================================
     */
    //46、查看借款详情
    @RequestMapping(value = "/a/u/loan/detail/{id}", method = RequestMethod.GET)
    public String getLoanDetail(HttpServletRequest request, ModelMap model, @PathVariable Long id) throws Exception {

        Long uid = cookieUtil.getID(request);
        debtLog.info("user : " + uid + " get debt " + id + " detail");
        User user = userService.getObjectById(uid);
        debtLog.info("1 ");
        try {
            //第一步： 获取赊销申请
            LoanApply loanApply = loanApplyService.getObjectById(id);
            //赊销申请是否存在
            if (null == loanApply) {
                model.addAttribute("code", -3007);
                debtLog.info("loan not exist");
                return "/common/success";
            }
            //改订单是否为登陆用户订单
            if (uid == loanApply.getUid()) {
                debtLog.info("is not your loanApply");
                model.addAttribute("code", -3006);
                return "/common/success";
            }
            //第二步： 获取借款申请所对应的订单信息
            Order order = orderService.getObjectById(loanApply.getOrderID());

            //第六步：根据借款申请类型获得详情参数
            if (LoanApply.TYPE_OVERTIME.equals(loanApply.getType())) {
                //借款本金、利率
                BigDecimal debtCount = loanApply.getDebtCount();
                BigDecimal overRate = loanApply.getOverRate();
                BigDecimal rate = loanApply.getRate();

                //获取总借款利息
                BigDecimal repayLine = new BigDecimal(loanApply.getRepayLine());
                BigDecimal overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);

                //获取当前逾期时间
                Long debtStart = MyTimeUtil.getDateZeroTimeMillions(loanApply.getDebtAt()).getTime();
                Long time = System.currentTimeMillis() - debtStart;
                BigDecimal dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);

                //获取当前罚息
                BigDecimal overRepay = caculate(overTotalRepay, overRate, dayCount);
                BigDecimal totalMoney = overTotalRepay.add(overRepay);

                loanApply.setOverDayCount(dayCount);
                loanApply.setClearOverInte(overRepay);
                loanApply.setRepayTot(totalMoney);
            }
            model.addAttribute("code", 0);
            model.addAttribute("loanApply", loanApply);
            model.addAttribute("order", order);
        } catch (Throwable t) {
            t.printStackTrace();
            debtLog.error(t.getMessage());
            debtLog.error("get debt detail error , id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/loan/json/getLoanDetail";
    }

    //47、赊销支付信息
    @RequestMapping(value = "/a/u/loan/pay/{id}", method = RequestMethod.GET)
    public String forRepayDetail(HttpServletRequest request, ModelMap model, @PathVariable Long id) throws Exception {

        Long uid = cookieUtil.getID(request);
        debtLog.info("user : " + uid + " get debt " + id + " detail");
        User user = userService.getObjectById(uid);
        debtLog.info("1 ");
        try {
            //第一步： 获取赊销申请
            LoanApply loanApply = loanApplyService.getObjectById(id);
            //赊销申请是否存在
            if (null == loanApply) {
                model.addAttribute("code", -3007);
                debtLog.info("loan not exist");
                return "/common/success";
            }
            //改订单是否为登陆用户订单
            if (uid == loanApply.getUid()) {
                debtLog.info("is not your loanApply");
                model.addAttribute("code", -3006);
                return "/common/success";
            }
            //第二步： 获取借款申请所对应的订单信息
            Order order = orderService.getObjectById(loanApply.getOrderID());
            debtLog.info("get order id : " + order.getId());

            //第三步：根据借款申请类型获得详情参数
            //1.逾期的处理逻辑
            if (LoanApply.TYPE_OVERTIME.equals(loanApply.getType())) {
                debtLog.info("overTime loanApply ");
                //借款本金、利率
                BigDecimal debtCount = loanApply.getDebtCount();
                BigDecimal overRate = loanApply.getOverRate();
                BigDecimal rate = loanApply.getRate();

                //获取总借款利息
                BigDecimal repayLine = new BigDecimal(loanApply.getRepayLine());
                BigDecimal overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);

                //获取当前逾期时间
                Long debtStart = MyTimeUtil.getDateZeroTimeMillions(loanApply.getDebtAt()).getTime();
                Long time = System.currentTimeMillis() - debtStart;
                BigDecimal dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);

                //获取当前罚息
                BigDecimal overRepay = caculate(overTotalRepay, overRate, dayCount);
                BigDecimal totalMoney = overTotalRepay.add(overRepay);

                loanApply.setOverDayCount(dayCount);
                loanApply.setClearOverInte(overRepay);
                loanApply.setRepayTot(totalMoney);
            }
            //2.还款中的处理逻辑
            else if (LoanApply.TYPE_REPAY.equals(loanApply.getType())) {
                debtLog.info("repay loanApply ");

                if(LoanApply.ORDER_TYPE_LOAN.equals(loanApply.getOrderType())){
                    //借款本金、利率
                    BigDecimal debtCount = loanApply.getDebtCount();
                    BigDecimal overRate = loanApply.getOverRate();
                    BigDecimal rate = loanApply.getRate();

                    //获取总借款利息
                    BigDecimal repayLine = new BigDecimal(loanApply.getRepayLine());
                    BigDecimal overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);
                    loanApply.setRepayTot(overTotalRepay);
                }else if(LoanApply.ORDER_TYPE_SMALL.equals(loanApply.getOrderType())){
                    loanApply.setRepayTot(loanApply.getDebtCount());
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("loanApply", loanApply);
            model.addAttribute("order", order);

            //第四步： 获取开磷账户信息

            String accountCode = PayAccountUtil.getRightPayAccount(order.getDepartment());
            //非常关键，获取要支付的开磷账号
            Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, accountCode);
            debtLog.info("userAccountId : " + userAccountId);
            UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
            Account account = accountService.getObjectById(userAccountRelation.getAccountId());
            userAccountRelation.setAccountName(account.getName());
            model.addAttribute("userAccount", userAccountRelation);
            debtLog.info("use account relation : " + userAccountRelation);

            //第五步: 获取代销账户信息
            BalanceInquiryOut balance = null;
            try {
                BalanceInquiryIn balanceInquiryIn = new BalanceInquiryIn();
                balanceInquiryIn.setBranchNo(GlobalConstant.BRANCH_NO);
                balanceInquiryIn.setFundAccount(user.getFundAccount());
                balanceInquiryIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                balanceInquiryIn.setUserId(user.getId() + "");
                if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
                    Person person = personService.getObjectById(user.getId());
                    balanceInquiryIn.setCertType("0");
                    balanceInquiryIn.setCertId(person.getIdNo());
                    balanceInquiryIn.setUserNameText(user.getName());
                } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
                    Organization organization = organizationService.getObjectById(user.getId());
                    balanceInquiryIn.setCertType(Constant.IDKIND);
                    balanceInquiryIn.setUserNameText(organization.getName());
                    balanceInquiryIn.setCertId(organization.getUseCertId());
                }
                balanceInquiryIn.setPassword(user.getPayPwd());
                balanceInquiryIn.setGtTradePassword(user.getPayPwd());
                balanceInquiryIn.setIfQueryTransitmAmt("1");
                balance = consignmentService.getBalance(balanceInquiryIn);
            } catch (Exception e) {
                debtLog.info(e.getMessage());
            }
            if (null != balance) {
                model.addAttribute("wayFund", balance.getRedeeTransitmAmt());
                model.addAttribute("balance", balance.getTotalAmt());
            } else {
                model.addAttribute("wayFund", 0);
                model.addAttribute("balance", 0);
            }
        } catch (Throwable t) {
            t.printStackTrace();
            debtLog.error(t.getMessage());
            debtLog.error("get debt detail error , id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/loan/json/payDetail";
    }


    //查看借款详情（重复）
    @RequestMapping(value = "/a/u/loan/repay/{id}", method = RequestMethod.GET)
    public String repayInfo(HttpServletRequest request, ModelMap model, @PathVariable Long id) throws Exception {

        Long uid = cookieUtil.getID(request);
        debtLog.info("user : " + uid + " get debt " + id + " detail");
        User user = userService.getObjectById(uid);
        debtLog.info("1 ");
        try {
            //第一步： 获取赊销申请
            LoanApply loanApply = loanApplyService.getObjectById(id);
            //赊销申请是否存在
            if (null == loanApply) {
                model.addAttribute("code", -3007);
                debtLog.info("loan not exist");
                return "/common/success";
            }
            //改订单是否为登陆用户订单
            if (uid == loanApply.getUid()) {
                debtLog.info("is not your loanApply");
                model.addAttribute("code", -3006);
                return "/common/success";
            }
            //第二步： 获取借款申请所对应的订单信息
            Order order = orderService.getObjectById(loanApply.getOrderID());

            //第六步：根据借款申请类型获得详情参数
            if (LoanApply.TYPE_OVERTIME.equals(loanApply.getType())) {

                //借款本金、利率
                BigDecimal debtCount = loanApply.getDebtCount();
                BigDecimal overRate = loanApply.getOverRate();
                BigDecimal rate = loanApply.getRate();

                //获取总借款利息
                BigDecimal repayLine = new BigDecimal(loanApply.getRepayLine());
                BigDecimal overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);

                //获取当前逾期时间
                Long debtStart = MyTimeUtil.getDateZeroTimeMillions(loanApply.getDebtAt()).getTime();
                Long time = System.currentTimeMillis() - debtStart;
                BigDecimal dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);

                //获取当前罚息
                BigDecimal overRepay = caculate(overTotalRepay, overRate, dayCount);
                BigDecimal totalMoney = overTotalRepay.add(overRepay);

                loanApply.setOverDayCount(dayCount);
                loanApply.setClearOverInte(overRepay);
                loanApply.setRepayTot(totalMoney);
            }
            model.addAttribute("code", 0);
            model.addAttribute("loanApply", loanApply);
            model.addAttribute("order", order);
        } catch (Throwable t) {
            t.printStackTrace();
            debtLog.error(t.getMessage());
            debtLog.error("get debt detail error , id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/loan/json/getLoanDetail";
    }


    //48、还款
    @RequestMapping(value = "/a/u/loan/pay/{id}", method = RequestMethod.PUT)
    public String updateDebtDeposi(HttpServletRequest request, ModelMap model,
                                   @PathVariable Long id, String paypwd, Integer paymentType) throws Exception {

        BigDecimal payCount = new BigDecimal("0");
        Integer result = 0;
        Long uid = cookieUtil.getID(request);
        depositPayLog.info("====================================================================");
        depositPayLog.info(" PAY Deposit UserId: " + uid + "  LoanApplyId: " + id + "  paypwd: " + paypwd + "  paymentType: " + paymentType);
        try {
            User user = userService.getObjectById(uid);
            LoanApply loanApply = loanApplyService.getObjectById(id);
            depositPayLog.info("LoanApply  status : " + loanApply.getStatus());
            if (!LoanApply.STATUS_PASS.equals(loanApply.getStatus())&&!LoanApply.STATUS_OVERTIME.equals(loanApply.getStatus())) {
                model.addAttribute("code", -3008);
                depositPayLog.info("PARAMFAIL: the loan not pass");
                return "/common/success";
            }
            Long oid = loanApply.getOrderID();
            Order order = orderService.getObjectById(oid);
            if (null == order) {
                model.addAttribute("code", -3015);
                depositPayLog.info("PARAMFAIL: no such order");
                return "/common/success";
            }
            //缴纳支付密码
            if (paymentType == Order.Pay_Type_fund) {
                if (user.getPayPwd().isEmpty()) {
                    model.addAttribute("code", -3016);
                    depositPayLog.info("USER: no payPwd");
                    return "/common/success";
                }
                depositPayLog.info(" inputpass: " + paypwd + "  dbpasswords: " + user.getPayPwd());
                boolean verify = paypwd.equals(user.getPayPwd().trim());
                depositPayLog.info(" verify: " + verify);
                if (!verify) {
                    depositPayLog.info(uid + " wrong password " + paypwd);
                    model.addAttribute("code", -2004);
                    return "/common/success";
                }
            } else if (Order.Pay_Type_klfund.equals(paymentType)) {
                String pass = PasswordUtils.encode(paypwd);
                String passwords = user.getPwd();
                depositPayLog.info(" inputpass: " + pass + "  dbpasswords: " + passwords);
                boolean verify = passwords.trim().equals(pass.trim());
                depositPayLog.info(" verify: " + verify);
                if (!verify) {
                    depositPayLog.info(uid + " wrong password " + paypwd);
                    model.addAttribute("code", -2004);
                    return "/common/success";
                }
            }

            //生成需要更新的数据，利息，罚息，逾期天数，还款总额，还款时间
            //借款本金、利率
            BigDecimal dayCount = new BigDecimal("0");
            BigDecimal overRepay = new BigDecimal("0");
            BigDecimal totalRepay = new BigDecimal("0");
            BigDecimal debtCount = new BigDecimal("0");
            BigDecimal overRate = new BigDecimal("0");
            BigDecimal repayLine = new BigDecimal("0");
            BigDecimal rate = new BigDecimal("0");
            BigDecimal lx = new BigDecimal("0");
            BigDecimal totalMoney = new BigDecimal("0");

            if(LoanApply.ORDER_TYPE_LOAN.equals(loanApply.getOrderType())){
                debtCount = loanApply.getDebtCount();
                overRate = loanApply.getOverRate();
                rate = loanApply.getRate();

                //获取总借款利息
                repayLine = new BigDecimal(loanApply.getRepayLine());
                lx = caculate(debtCount, rate, repayLine);
                totalRepay = lx.add(debtCount);

                //获取当前逾期时间
                long debtStart = MyTimeUtil.getDateZeroTimeMillions(loanApply.getDebtAt()).getTime();
                long time = System.currentTimeMillis() - debtStart;
                dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);
                if (dayCount.doubleValue() < 0) {
                    dayCount = new BigDecimal("0");
                }

                //获取当前罚息
                overRepay = caculate(totalRepay, overRate, dayCount);

                //待还总额
                totalMoney = totalRepay.add(overRepay);
            }else if(LoanApply.ORDER_TYPE_SMALL.equals(loanApply.getOrderType())){
                totalMoney = loanApply.getDebtCount();
            }



            //第一步：通过代销接口支付保证金
            if (Order.Pay_Type_fund.equals(paymentType)) {
                depositPayLog.info(" DAIXIAO PAY .. ");
                AutoDocBailRechargeOut autoDocBailRechargeOut = null;
                BindingBank bindingBank = null;
                try {
                    //一.  机构用户处理逻辑
                    BindingBankIn bindingBankIn = new BindingBankIn();
                    bindingBankIn.setUserId(user.getId() + "");
                    bindingBankIn.setFundAccount(user.getFundAccount());
                    bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
                    List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
                    for (BindingBank bank : bindingBanks) {
                        if (bank.getBankNo().equals("ZLRT")) {
                            bindingBank = bank;
                            break;
                        }
                    }
                    depositPayLog.info(" BANK:  " + bindingBank);
                    AutoDocBailRechargeIn organBindCardIn = new AutoDocBailRechargeIn();
                    organBindCardIn.setUserId(user.getId() + "");
                    organBindCardIn.setFundAccount(user.getFundAccount());
                    organBindCardIn.setPassword(paypwd);
                    organBindCardIn.setBranchNo(GlobalConstant.BRANCH_NO);
                    organBindCardIn.setFundAccountG(user.getFundAccount());
                    organBindCardIn.setOpbusinessFlag("8035");
                    organBindCardIn.setOccurBalanceG(order.getPriceTot());
                    organBindCardIn.setTiedCardType("0");
                    organBindCardIn.setMoneyType("0");
                    organBindCardIn.setFundCompany(GlobalConstant.FUND_COMPANY);
                    organBindCardIn.setFundCode(990006 + "");
                    organBindCardIn.setPayType("0");
                    organBindCardIn.setChannelResource("");
                    organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                    organBindCardIn.setBankNoDk("ZLRT");
                    organBindCardIn.setBankAccountDk(bindingBank.getBankAccount());
                    organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                    organBindCardIn.setAutotransNo("");
                    depositPayLog.info("organBindCardIn : " + organBindCardIn);
                    autoDocBailRechargeOut = consignmentService.autoDocBailRecharge(organBindCardIn);
                } catch (Exception e) {
                    e.printStackTrace(System.out);
                    depositPayLog.error(e.getMessage());
                }
                depositPayLog.info(autoDocBailRechargeOut);
                model.put("code", autoDocBailRechargeOut.getErrorNo());
                model.put("message", autoDocBailRechargeOut.getErrorInfo());
                depositPayLog.info("error code is " + autoDocBailRechargeOut.getErrorNo());
                depositPayLog.info("error info is " + autoDocBailRechargeOut.getErrorInfo());
                if (0 == autoDocBailRechargeOut.getErrorNo()) {

                    //还原小额额度
                    if(LoanApply.ORDER_TYPE_SMALL.equals(loanApply.getOrderType())){
                        BigDecimal totalFee = loanApply.getDebtCount();
                        Fund fund = fundService.getObjectById(uid);
                        BigDecimal smallLoanTot = fund.getSmallLoanTot();
                        fund.setSmallLoanTot(smallLoanTot.subtract(totalFee));
                        depositPayLog.info("update smallLoanTot success : " + smallLoanTot + " >>>>>>>>>> " + fund.getSmallLoanTot());
                        fundService.update(fund);
                    }

                    depositPayLog.info(" DAI XIAO Success ");
                    result = userAccountRelationService.shexiaoDX(totalMoney.doubleValue(), lx.doubleValue(), overRepay.doubleValue(), Double.parseDouble(dayCount + ""), System.currentTimeMillis(), id, order.getId(), System.currentTimeMillis());
                    depositPayLog.info("DB result:  " + result);
                    model.addAttribute("code", result);
                } else {
                    depositPayLog.info("DAI XIAO fail");
                }
                return "/common/pay";
            }
            //第二步：通过开磷账户进行支付
            else if (Order.Pay_Type_klfund.equals(paymentType)) {
                depositPayLog.info(" KAILIN  PAY .. ");
                String accountCode = PayAccountUtil.getRightPayAccount(order.getDepartment());
                //非常关键，获取要支付的开磷账号
                Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, accountCode);
                depositPayLog.info(" accountCode: " + accountCode + "  userAccountId: " + userAccountId + " payCount: " + payCount.doubleValue() + " debtCount: " + loanApply.getDebtCount().doubleValue() + " orderId: " + order + " loanApply: " + loanApply.getId());
                if (null != userAccountId) {

                    UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
                    BigDecimal beforeTransaction = userAccountRelation.getMoney();
                    log.info("repay beforeTransaction : " + beforeTransaction);

                    result = userAccountRelationService.shexiaoKL(userAccountId, totalMoney.doubleValue(), lx.doubleValue(), overRepay.doubleValue(), Double.parseDouble(dayCount + ""), System.currentTimeMillis(), id, order.getId(), System.currentTimeMillis());

                    if(result == 0){
                        userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
                        BigDecimal afterTransaction = userAccountRelation.getMoney();
                        log.info("repay afterTransaction : " + afterTransaction);

                        Long transactionId = fundHistoryService.insertTransaction(order, user, FundHistory.TYPE_Pay, FundHistory.DETAIL_Repay, userAccountId,
                                totalMoney, null, FundHistory.FLAG_Out, FundHistory.STATUS_Pass, null, beforeTransaction, afterTransaction);
                        log.info("insert transaction success : id " + transactionId);

                        if(LoanApply.ORDER_TYPE_SMALL.equals(loanApply.getOrderType())){
                            BigDecimal totalFee = loanApply.getDebtCount();
                            Fund fund = fundService.getObjectById(uid);
                            BigDecimal smallLoanTot = fund.getSmallLoanTot();
                            fund.setSmallLoanTot(smallLoanTot.subtract(totalFee));
                            depositPayLog.info("update smallLoanTot success : " + smallLoanTot + " >>>>>>>>>> " + fund.getSmallLoanTot());
                            fundService.update(fund);
                        }
                    }


                } else {
                    result = -3022;
                }
                depositPayLog.info("DB result: " + result);
                model.addAttribute("code", result);
            } else {
                model.addAttribute("code", -3011);
            }
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            depositPayLog.error(t.getMessage());
            depositPayLog.error("update updateDebt deposi , id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //计算利息

    public BigDecimal caculate(BigDecimal debtCount, BigDecimal rate, BigDecimal day) {
        debtLog.info("caculate : debtCount = " + debtCount + " rate = " + rate + " day = " + day);
        BigDecimal result = debtCount.multiply(day).multiply(rate).divide(DebtConstant.HUNDRED, 3, BigDecimal.ROUND_HALF_UP).divide(DebtConstant.YEAR, 3, BigDecimal.ROUND_HALF_UP);
        return result;
    }

}

