package com.ptteng.wealth.finance.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.DESUtil;
import com.gemantic.common.util.StringUtil;
import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.LoanProduct;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.util.FinanceConstant;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.util.OrderPayLineUtil;
import com.ptteng.wealth.util.SmallLoanService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by asus on 2016/6/24.
 */
@Controller
public class BtobController extends BaseController {

    @Autowired
    public SmallLoanService smallLoanService;
    private Log b2bPayLog = LogFactory.getLog("b2b_pay");
    private Log log = LogFactory.getLog(BtobController.class);

    private String checkParams(String orderNo, Integer paymentType, String notifyUrl, Double totalFee, String info, String body,
                               String returnUrl, Integer type, String company, Long uid, Integer orderType, String additional) throws Exception {
        //传入参数检查
        if (null == orderNo || null == paymentType || null == totalFee || null == info || null == body || null == notifyUrl
                || null == type || null == company || null == orderType || null == additional) {
            b2bPayLog.info("params is null");
            return "https://" + environment.getFsp() + "/external/externalPayFail?code=-1000&message=参数缺失&url=" + returnUrl;
        }
        //支付类型检查
        if (FinanceConstant.PAYMENT_TYPE_1 != paymentType && FinanceConstant.PAYMENT_TYPE_3 != paymentType &&
                FinanceConstant.PAYMENT_TYPE_4 != paymentType && FinanceConstant.PAYMENT_TYPE_6 != paymentType &&
                FinanceConstant.PAYMENT_TYPE_7 != paymentType) {
            b2bPayLog.info("paymentType illegal");
            return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3010&message=支付方式非法&url=" + returnUrl;
        }
        //冻结用户不能支付订单
        User user = userService.getObjectById(uid);
        b2bPayLog.info("user : id : " + user.getId() + "  freezeStatus: " + user.getFreezeStatus());
        if (User.FREEZE_YES.equals(user.getFreezeStatus())) {
            b2bPayLog.info("paymentType illegal");
            return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3021&message=该用户已被冻结&url=" + returnUrl;
        }

        //个人用户不能融资购肥
        if(User.TYPE_PERSON.equals(user.getType()) && FinanceConstant.PAYMENT_TYPE_7 == paymentType){
            b2bPayLog.info("personal user not allowed debt");
            return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3035&message=个人用户无法使用融资购肥&url=" + returnUrl;
        }

        if(User.VERIFY_NO.equals(user.getVerifyStatus()) && FinanceConstant.PAYMENT_TYPE_7 == paymentType){
            b2bPayLog.info("user not verify");
            return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3028&message=请绑定银行卡后再使用融资购肥&url=" + returnUrl;
        }
        Fund fund = fundService.getObjectById(uid);
        if (null == fund) {
            b2bPayLog.info("user have no fund");
            return "https://" + environment.getFsp() + "/external/externalPayFail?code=-2010&message=用户资产信息不存在&url=" + returnUrl;
        }

        if (orderType == FinanceConstant.PAYMENT_TYPE_5) {

            if(FinanceConstant.PAYMENT_TYPE_7.equals(paymentType)){
                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3031&message=小额订单请不能使用融资购肥&url=" + returnUrl;
            }

            Boolean checkResult = smallLoanService.check(totalFee);
            if (!checkResult) {
                b2bPayLog.info("order Fee not in smallLoan range");
                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3025&message=订单金额不符合小额订单要求&url=" + returnUrl;
            }
            if(paymentType == FinanceConstant.PAYMENT_TYPE_6){
                //第一次小额订单自动授信
                Boolean updateLineResult = smallLoanService.smallLoanLineApply(uid);
            }

        }

        //补款订单先检查支付订单是否支付完成
        if(!orderNo.equals(additional)){
            b2bPayLog.info("additional order");
            Long oldOrderId = orderService.getOrderIdByOrderNo(orderNo);

            if (null == oldOrderId) {//支付订单不存在
                b2bPayLog.info("original order not exist");
                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3036&message=原订单不存在，无法补款&url=" + returnUrl;
            }else {
                b2bPayLog.info("original order : " + oldOrderId + " exist");
                Order order = orderService.getObjectById(oldOrderId);

                if (!Order.STATUS_COMPLETE.equals(order.getStatus())) {//支付订单未完成
                    b2bPayLog.info("original order : " + oldOrderId + " not complete");
                    return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3037&message=原订单未完成，无法补款&url=" + returnUrl;
                }else {
                    b2bPayLog.info("original order : " + oldOrderId + " complete");
                }
            }
        }else {
            b2bPayLog.info("original order");
        }

        //重复订单检查
        Long oldOrderId = orderService.getOrderIdByOrderNoAndAdditional(orderNo, additional);
        log.info("oldOrderId : " + oldOrderId);
        if (null != oldOrderId) {
            Order order = orderService.getObjectById(oldOrderId);
            b2bPayLog.info(" OLD Order id : " + order.getId() + " orderNo: " + order.getOrderNo() + " status: " + order.getStatus());
            if (Order.STATUS_COMPLETE.equals(order.getStatus())) {
                b2bPayLog.info(" old order Id : " + oldOrderId + " has complete ");
                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3009&message=该订单已支付成功&url=" + returnUrl;
            }
            if (!uid.equals(order.getUid())) {
                b2bPayLog.info("proccessOrder uid not match");
                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3018&message=支付中订单用户身份不匹配&url=" + returnUrl;
            }
            order.setNotifyUrl(notifyUrl);
            order.setPayType(paymentType);
            orderService.update(order);

            //代销余额支付 | 开磷余额支付 | 承兑汇票 |电汇 的处理流程
            if (Order.Pay_Type_fund.equals(order.getPayType()) || Order.Pay_Type_post.equals(order.getPayType()) || Order.Pay_Type_check.equals(order.getPayType()) || Order.Pay_Type_klfund.equals(order.getPayType())) {
                //跳转B2B支付页面
                b2bPayLog.info(" JUMP TO Before Url ==== pamentType: " + paymentType);
                return "https://" + environment.getFsp() + "/external/externalPay" + "?orderId=" + oldOrderId;
            }
            //信用支付的处理流程
            else if ( ( Order.Pay_Type_Debt.equals(order.getPayType()) || Order.Pay_Type_Loan.equals(order.getPayType()) )
                    && Order.product_status_not_choice.equals(order.getProductStatus())) {
                b2bPayLog.info(" JUMP TO Before Url ==== pamentType: " + paymentType);
                return "https://" + environment.getFsp() + "/external/loanChooseProduct" + "?orderId=" + order.getId();
            }
            else if(Order.Pay_Type_Debt.equals(order.getPayType())){
                //借贷的处理流程
                return  "https://" + environment.getFsp() + "/account/loan";
            }
            //已选择产品的赊销的处理流程
            else if(Order.Pay_Type_Loan.equals(order.getPayType())){
                b2bPayLog.info(" JUMP TO Before Url ==== order PayType : " + order.getPayType());
                return "https://" + environment.getFsp() + "/account/loan";
            } //小额的处理流程
            else{
                b2bPayLog.info(" JUMP TO Before Url ==== order PayType : " + order.getPayType());
                return "https://" + environment.getFsp() + "/account/loan?processId=2";
            }
        } else if (orderType == FinanceConstant.PAYMENT_TYPE_5) {
            Integer ifLineEnough = 0;
            if(FinanceConstant.PAYMENT_TYPE_6.equals(paymentType)){
                ifLineEnough = smallLoanService.smallLoanLineCheck(totalFee, uid);
            }else {
                ifLineEnough = smallLoanService.onlyDailySmallLoanLineCheck(totalFee, uid);
            }
            if(ifLineEnough == 1){
                b2bPayLog.info("user small loan line not enough");
                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3026&message=用户小额订单额度不足&url=" + returnUrl;
            }else if(ifLineEnough == 2){
                b2bPayLog.info("user small loan line not enough");
                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3027&message=用户当日小额订单额度不足&url=" + returnUrl;
            }
        }

        return null;
    }

    private Integer checkParamsReturnCode(String orderNo, Integer paymentType, String notifyUrl, Double totalFee, String info, String body,
                               String returnUrl, Integer type, String company, Long uid, Integer orderType, String additional) throws Exception {
        //传入参数检查
        if (null == orderNo || null == paymentType || null == totalFee || null == info || null == body || null == notifyUrl
                || null == type || null == company || null == orderType || null == additional) {
            b2bPayLog.info("params is null");
            return -1000;
//            return "https://" + environment.getFsp() + "/external/externalPayFail?code=-1000&message=参数缺失&url=" + returnUrl;
        }
        //支付类型检查
        if (FinanceConstant.PAYMENT_TYPE_1 != paymentType && FinanceConstant.PAYMENT_TYPE_3 != paymentType &&
                FinanceConstant.PAYMENT_TYPE_4 != paymentType && FinanceConstant.PAYMENT_TYPE_6 != paymentType &&
                FinanceConstant.PAYMENT_TYPE_7 != paymentType) {
            b2bPayLog.info("paymentType illegal");
            return -3010;
//            return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3010&message=支付方式非法&url=" + returnUrl;
        }
        //冻结用户不能支付订单
        User user = userService.getObjectById(uid);
        b2bPayLog.info("user : id : " + user.getId() + "  freezeStatus: " + user.getFreezeStatus());
        if (User.FREEZE_YES.equals(user.getFreezeStatus())) {
            b2bPayLog.info("paymentType illegal");
//            return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3021&message=该用户已被冻结&url=" + returnUrl;
            return -3021;
        }

        //个人用户不能融资购肥
        if(User.TYPE_PERSON.equals(user.getType()) && FinanceConstant.PAYMENT_TYPE_7 == paymentType){
            b2bPayLog.info("personal user not allowed debt");
//            return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3035&message=个人用户无法使用融资购肥&url=" + returnUrl;
            return -3035;
        }

        if(User.VERIFY_NO.equals(user.getVerifyStatus()) && FinanceConstant.PAYMENT_TYPE_7 == paymentType){
            b2bPayLog.info("user not verify");
//            return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3028&message=请绑定银行卡后再使用融资购肥&url=" + returnUrl;
            return -3028;
        }
        Fund fund = fundService.getObjectById(uid);
        if (null == fund) {
            b2bPayLog.info("user have no fund");
//            return "https://" + environment.getFsp() + "/external/externalPayFail?code=-2010&message=用户资产信息不存在&url=" + returnUrl;
            return -2010;
        }

        if (orderType == FinanceConstant.PAYMENT_TYPE_5) {

            if(FinanceConstant.PAYMENT_TYPE_7.equals(paymentType)){
//                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3031&message=小额订单请不能使用融资购肥&url=" + returnUrl;
                return -3031;
            }

            Boolean checkResult = smallLoanService.check(totalFee);
            if (!checkResult) {
                b2bPayLog.info("order Fee not in smallLoan range");
//                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3025&message=订单金额不符合小额订单要求&url=" + returnUrl;
                return -3025;
            }
            if(paymentType == FinanceConstant.PAYMENT_TYPE_6){
                //第一次小额订单自动授信
                Boolean updateLineResult = smallLoanService.smallLoanLineApply(uid);
            }

        }

        //补款订单先检查支付订单是否支付完成
        if(!orderNo.equals(additional)){
            b2bPayLog.info("additional order");
            Long oldOrderId = orderService.getOrderIdByOrderNo(orderNo);

            if (null == oldOrderId) {//支付订单不存在
                b2bPayLog.info("original order not exist");
//                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3036&message=原订单不存在，无法补款&url=" + returnUrl;
                return -3036;
            }else {
                b2bPayLog.info("original order : " + oldOrderId + " exist");
                Order order = orderService.getObjectById(oldOrderId);

                if (!Order.STATUS_COMPLETE.equals(order.getStatus())) {//支付订单未完成
                    b2bPayLog.info("original order : " + oldOrderId + " not complete");
//                    return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3037&message=原订单未完成，无法补款&url=" + returnUrl;
                    return -3037;
                }else {
                    b2bPayLog.info("original order : " + oldOrderId + " complete");
                }
            }
        }else {
            b2bPayLog.info("original order");
        }

        //重复订单检查
        Long oldOrderId = orderService.getOrderIdByOrderNoAndAdditional(orderNo, additional);
        log.info("oldOrderId : " + oldOrderId);
        if (null != oldOrderId) {
            Order order = orderService.getObjectById(oldOrderId);
            b2bPayLog.info(" OLD Order id : " + order.getId() + " orderNo: " + order.getOrderNo() + " status: " + order.getStatus());
            if (Order.STATUS_COMPLETE.equals(order.getStatus())) {
                b2bPayLog.info(" old order Id : " + oldOrderId + " has complete ");
//                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3009&message=该订单已支付成功&url=" + returnUrl;
                return -3009;
            }
            if (!uid.equals(order.getUid())) {
                b2bPayLog.info("proccessOrder uid not match");
//                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3018&message=支付中订单用户身份不匹配&url=" + returnUrl;
                return -3018;
            }
            order.setNotifyUrl(notifyUrl);
            order.setPayType(paymentType);
            orderService.update(order);

            //代销余额支付 | 开磷余额支付 | 承兑汇票 |电汇 的处理流程
            if (Order.Pay_Type_fund.equals(order.getPayType()) || Order.Pay_Type_post.equals(order.getPayType()) || Order.Pay_Type_check.equals(order.getPayType()) || Order.Pay_Type_klfund.equals(order.getPayType())) {
                //跳转B2B支付页面
                b2bPayLog.info(" JUMP TO Before Url ==== pamentType: " + paymentType);
//                return "https://" + environment.getFsp() + "/external/externalPay" + "?orderId=" + oldOrderId;
                return 100;
            }
            //信用支付的处理流程
            else if ( ( Order.Pay_Type_Debt.equals(order.getPayType()) || Order.Pay_Type_Loan.equals(order.getPayType()) )
                    && Order.product_status_not_choice.equals(order.getProductStatus())) {
                b2bPayLog.info(" JUMP TO Before Url ==== pamentType: " + paymentType);
//                return "https://" + environment.getFsp() + "/external/loanChooseProduct" + "?orderId=" + order.getId();
                return 202;
            }
            else if(Order.Pay_Type_Debt.equals(order.getPayType())){
                //借贷的处理流程
//                return  "https://" + environment.getFsp() + "/account/loan";
                return 201;
            }
            //已选择产品的赊销的处理流程
            else if(Order.Pay_Type_Loan.equals(order.getPayType())){
                b2bPayLog.info(" JUMP TO Before Url ==== order PayType : " + order.getPayType());
//                return "https://" + environment.getFsp() + "/account/loan";
                return 300;
            } //小额的处理流程
            else{
                b2bPayLog.info(" JUMP TO Before Url ==== order PayType : " + order.getPayType());
//                return "https://" + environment.getFsp() + "/account/loan?processId=2";
                return 301;
            }
        } else if (orderType == FinanceConstant.PAYMENT_TYPE_5) {
            Integer ifLineEnough = 0;
            if(FinanceConstant.PAYMENT_TYPE_6.equals(paymentType)){
                ifLineEnough = smallLoanService.smallLoanLineCheck(totalFee, uid);
            }else {
                ifLineEnough = smallLoanService.onlyDailySmallLoanLineCheck(totalFee, uid);
            }
            if(ifLineEnough == 1){
                b2bPayLog.info("user small loan line not enough");
//                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3026&message=用户小额订单额度不足&url=" + returnUrl;
                return -3026;
            }else if(ifLineEnough == 2){
                b2bPayLog.info("user small loan line not enough");
//                return "https://" + environment.getFsp() + "/external/externalPayFail?code=-3027&message=用户当日小额订单额度不足&url=" + returnUrl;
                return -3027;
            }
        }

        return null;
    }

    @RequestMapping(value = "/bpay/order/{orderNo}")
    public String b2bPay(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                         @PathVariable String orderNo, Integer paymentType, String notifyUrl,
                         String token, Double totalFee, String info, String body,
                         String returnUrl, Integer type, String company, Integer orderType, String additional, String dataType) throws Exception {

        b2bPayLog.info("=======================================================================================");
        b2bPayLog.info("PARAMS : orderNo = " + orderNo + " paymentType = " + paymentType + " type=" + type + "  token = " + token
                + " totalFee = " + totalFee + " info = " + info + " notifyUrl = " + notifyUrl + " body = " + body
                + " returnUrl = " + returnUrl + " company = " + company + " orderType " + orderType + " additional " + additional + " dataType " + dataType);

        if(StringUtil.isEmpty(additional)){
            additional = orderNo;
        }
        boolean jsonFlag = false;
        if (StringUtils.isNotBlank(dataType) && "json".equalsIgnoreCase(dataType)) {
            jsonFlag = true;
        }
        String userKailinCode = DESUtil.decrypt(token.getBytes());
        b2bPayLog.info("PARAMS: kailinCode : " + userKailinCode);
        Long uid = userService.getUserIdByKailinCode(userKailinCode);
        b2bPayLog.info("PARAMS: uid : " + uid);
        if (null == uid && !jsonFlag) {
            b2bPayLog.info("FAIL: user not exist");
            return "redirect:https://" + environment.getFsp() + "/external/externalPayFail?code=-2000&message=用户不存在&url=" + returnUrl;
        } else if (null == uid && jsonFlag) {
            b2bPayLog.info("FAIL: user not exist");
            model.addAttribute("code", -2000);
            return "/common/success";
        }

        // 第一步：种cookie
        cookieUtil.clearCookie(response);
        Map<String, String> maps = new HashMap();
        maps.put(CookieUtil.USER_ID, uid + "");
        cookieUtil.setIdentity(request, response, maps, uid);

        //第二步： 获取跳转到的URL
        String jumpUrl = "";
        try {
            // 第二步：检查参数是否合法
            if (jsonFlag) {
                Integer code = checkParamsReturnCode(orderNo, paymentType, notifyUrl, totalFee, info, body, returnUrl, type, company, uid, orderType, additional);
                if (null == code) {
                    // 第三步: 创建支付记录
                    b2bPayLog.info("==== Parameter Check SUCCESS");
                    Order order = new Order();
                    if (orderType == 0 || !FinanceConstant.PAYMENT_TYPE_6.equals(paymentType)) {
                        order = createOrder(orderNo, paymentType, notifyUrl, totalFee, info, type, uid, returnUrl, company, orderType, additional);
                    }

                    b2bPayLog.info("Order create Id : " + order.getId() + " orderNo: " + orderNo);

                    // 第四步： 生成需要跳转到的URL
                    // 1. 余额支付|电汇|承兑汇票
                    if (FinanceConstant.PAYMENT_TYPE_1.equals(paymentType) || FinanceConstant.PAYMENT_TYPE_3.equals(paymentType) || FinanceConstant.PAYMENT_TYPE_4.equals(paymentType)) {
                        //跳转B2B支付页面
                        model.addAttribute("code", 100);
                    }
                    //2. 赊销支付
                    else if (FinanceConstant.PAYMENT_TYPE_6.equals(paymentType)) {
                        //跳转产品选择页面
                        model.addAttribute("code", 202);
                        //3. 小额支付
                        if (orderType == 1) {
                            //跳转我的借款页面
                            order = createSmallOrder(orderNo, paymentType, notifyUrl, totalFee, info, type, uid, returnUrl, company, additional);
                            model.addAttribute("code", 301);
                        }
                    }
                    //3.融资购肥
                    else if (FinanceConstant.PAYMENT_TYPE_7.equals(paymentType)){
                        //跳转产品选择页面
                        model.addAttribute("code", 202);
                    }
                } else {
                    model.addAttribute("code", code);
                }
            } else {
                String checkResult = checkParams(orderNo, paymentType, notifyUrl, totalFee, info, body, returnUrl, type, company, uid, orderType, additional);
                if (StringUtil.isNotEmpty(checkResult)) {
                    jumpUrl = checkResult;
                    b2bPayLog.info("==== Parameter Check FAIL Or Continue Before URL :  " + jumpUrl);
                } else {

                    // 第三步: 创建支付记录
                    b2bPayLog.info("==== Parameter Check SUCCESS");
                    Order order = new Order();
                    if (orderType == 0 || !FinanceConstant.PAYMENT_TYPE_6.equals(paymentType)) {
                        order = createOrder(orderNo, paymentType, notifyUrl, totalFee, info, type, uid, returnUrl, company, orderType, additional);
                    }

                    b2bPayLog.info("Order create Id : " + order.getId() + " orderNo: " + orderNo);

                    // 第四步： 生成需要跳转到的URL
                    // 1. 余额支付|电汇|承兑汇票
                    if (FinanceConstant.PAYMENT_TYPE_1.equals(paymentType) || FinanceConstant.PAYMENT_TYPE_3.equals(paymentType) || FinanceConstant.PAYMENT_TYPE_4.equals(paymentType)) {
                        //跳转B2B支付页面
                        jumpUrl = "https://" + environment.getFsp() + "/external/externalPay" + "?orderId=" + order.getId();
                    }
                    //2. 赊销支付
                    else if (FinanceConstant.PAYMENT_TYPE_6.equals(paymentType)) {
                        //跳转产品选择页面
                        jumpUrl = "https://" + environment.getFsp() + "/external/loanChooseProduct" + "?orderId=" + order.getId();
                        //3. 小额支付
                        if (orderType == 1) {
                            //跳转我的借款页面
                            order = createSmallOrder(orderNo, paymentType, notifyUrl, totalFee, info, type, uid, returnUrl, company, additional);
                            jumpUrl = "https://" + environment.getFsp() + "/account/loan?processId=2";
                        }
                    }
                    //3.融资购肥
                    else if (FinanceConstant.PAYMENT_TYPE_7.equals(paymentType)){
                        //跳转产品选择页面
                        jumpUrl = "https://" + environment.getFsp() + "/external/loanChooseProduct" + "?orderId=" + order.getId();
                    }
                }
            }
        } catch (Exception e) {
            b2bPayLog.info(e.getMessage());
            e.printStackTrace(System.out);
            jumpUrl = "https://" + environment.getFsp() + "/external/externalPayFail?code=-1000&message=参数缺失&url=" + returnUrl;
        }
        b2bPayLog.info("Jump Url: " + jumpUrl);
        if (jsonFlag) {
            return "/common/success";
        } else {
            model.addAttribute("jumpurl", jumpUrl);
            return "b2bPay";
        }

    }

    private Order createOrder(@PathVariable String orderNo, Integer paymentType, String notifyUrl, Double totalFee, String info,
                              Integer type, Long uid, String returnUrl, String company, Integer orderType, String additional) throws ServiceException, ServiceDaoException {

        Order order = new Order();
        order.setOrderNo(orderNo);
        order.setDepartment(type);
        order.setResource(Order.Pay_Resource_b2b);
        order.setUid(uid);
        order.setInfo(info);
        order.setPayType(paymentType);
        order.setStatus(Order.STATUS_PROCCESS);
        order.setOrderAt(System.currentTimeMillis());
        order.setPriceTot(new BigDecimal(totalFee.toString()));
        order.setNotifyUrl(notifyUrl);
        order.setPayLine(OrderPayLineUtil.getPayLine(paymentType));
        order.setReturnUrl(returnUrl);
        order.setCompany(company);
        order.setAdditional(additional);
        if(orderType.equals(FinanceConstant.PAYMENT_TYPE_5)){
            order.setOrderType(Order.Type_small);
        }else {
            order.setOrderType(Order.Type_normal);
        }
        Long id = orderService.insert(order);
        order.setId(id);
        return order;
    }

    private Order createSmallOrder(@PathVariable String orderNo, Integer paymentType, String notifyUrl, Double totalFee,
                                   String info, Integer type, Long uid, String returnUrl, String company, String additional
    ) throws ServiceException, ServiceDaoException {

        b2bPayLog.info("create small loan order");
        String verifyLine = constantService.getValue("verifyLine", "smallLoan");
        User user = userService.getObjectById(uid);
        Boolean verifyResult = smallLoanService.ifVerify(totalFee);
        Order order = new Order();

        //判断是否可以自动审核
        if (verifyResult) {
            order.setStatus(Order.STATUS_COMPLETE);
        } else {
            order.setStatus(Order.STATUS_PROCCESS);
        }
        order.setOrderNo(orderNo);
        order.setDepartment(type);
        order.setResource(Order.Pay_Resource_b2b);
        order.setUid(uid);
        order.setInfo(info);
        order.setPayType(Order.Pay_Type_Small);
        order.setOrderAt(System.currentTimeMillis());
        order.setPriceTot(new BigDecimal(totalFee.toString()));
        order.setNotifyUrl(notifyUrl);
        order.setPayLine(OrderPayLineUtil.getPayLine(paymentType));
        order.setReturnUrl(returnUrl);
        order.setCompany(company);
        order.setProductStatus(Order.product_status_choice);
        order.setOrderType(Order.Type_small);
        order.setAdditional(additional);
        order.setPayAt(System.currentTimeMillis());
        Long id = orderService.insert(order);
        order.setId(id);
        b2bPayLog.info("insert order success : " + order);

        //插入小额借款申请
        Boolean result = loanApplyService.addSmallLoanApply(order, user, verifyResult);

        Fund fund = fundService.getObjectById(uid);

        //更新最后小额申请时间
        Long lastSmallLoan = fund.getLastSmallLoan();
        fund.setLastSmallLoan(System.currentTimeMillis());
        b2bPayLog.info("update lastSmallLoan success : " + lastSmallLoan + " >>>>>>>>>> " + fund.getLastSmallLoan());
        //更新今日小额订单数额，在拒绝时会还原
        BigDecimal todaySmallLoan = fund.getTodaySmallLoan();
        fund.setTodaySmallLoan(todaySmallLoan.add(new BigDecimal(totalFee.toString())));
        b2bPayLog.info("update todaySmallLoan success : " + todaySmallLoan + " >>>>>>>>>> " + fund.getTodaySmallLoan());
        fundService.update(fund);
        b2bPayLog.info("update fund success : " + fund);

        if(result && verifyResult){
            fund = fundService.getObjectById(uid);
            BigDecimal smallLoanTot = fund.getSmallLoanTot();
            fund.setSmallLoanTot(smallLoanTot.add(new BigDecimal(totalFee.toString())));
            b2bPayLog.info("update smallLoanTot success : " + smallLoanTot + " >>>>>>>>>> " + fund.getSmallLoanTot());
            fundService.update(fund);
            b2bPayLog.info("update fund success : " + fund);
        }

        return order;
    }

    /**
     * @param
     * @return
     * @throws Exception
     */
    //info查询
    @RequestMapping(value = "/a/order/detail", method = RequestMethod.GET)
    public String infoDetal(ModelMap model, Long orderId) throws Exception {
        try {
            log.info("get order no  order id:  " + orderId);
            Order order = orderService.getObjectById(orderId);
            model.addAttribute("code", 0);
            model.addAttribute("order", order);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get account : " + orderId + " error ");
            // for test
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/pay/json/orderDetail";
    }

    // 借款理财产品列表
    @RequestMapping(value = "/a/loan/list", method = RequestMethod.GET)
    public String loanProductLs(ModelMap model) throws Exception {

        try {
            List<Long> idLs = loanProductService.getLoanIds(0, Integer.MAX_VALUE);
            List<LoanProduct> loanProducts = loanProductService.getObjectsByIds(idLs);

            model.addAttribute("code", 0);
            model.addAttribute("loanProducts", loanProducts);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/loanproduct/json/loanProductListJson";
    }


    // 借款理财产品列表
    @RequestMapping(value = "/a/loan/list/{type}", method = RequestMethod.GET)
    public String loanProductLs(ModelMap model, @PathVariable Integer type) throws Exception {

        try {
            if (LoanProduct.SALE_ON_CREDIT != type && LoanProduct.SALE_ON_CREDIT_NOT != type){
                log.info("wrong type");
                model.addAttribute("code", -3032);
                return "/common/success";
            }

            List<LoanProduct> loanProducts = loanProductService.getLoanProductByManner(type);

            model.addAttribute("code", 0);
            model.addAttribute("loanProducts", loanProducts);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/loanproduct/json/loanProductListJson";
    }



}
