package com.ptteng.wealth.user.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.StringUtil;
import com.google.gson.JsonObject;
import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.Environment;
import com.ptteng.wealth.common.model.Sms;
import com.ptteng.wealth.common.service.SmsService;
import com.ptteng.wealth.consign.constant.FunctionConstants;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.*;
import com.ptteng.wealth.consign.model.out.CardBindingOut;
import com.ptteng.wealth.consign.model.out.CommonOut;
import com.ptteng.wealth.consign.model.out.MessageAuthenticationCodeOut;
import com.ptteng.wealth.consign.model.out.OpenAccountOut;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.model.UserOpenidRelation;
import com.ptteng.wealth.user.model.work.CardModel;
import com.ptteng.wealth.user.service.PersonService;
import com.ptteng.wealth.user.service.UserOpenidRelationService;
import com.ptteng.wealth.user.service.UserService;
import com.ptteng.wealth.user.util.Constant;
import com.ptteng.wealth.user.util.InterfaceCodeConstant;
import com.qding.common.util.http.cookie.CookieUtil;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by arthur on 16/6/25.
 */
@Controller
public class UserRegisterController extends BaseController {

    private static final Log register_log = LogFactory.getLog("user_register_log");


    @Autowired
    private UserService userService;
    @Autowired
    private PersonService personService;
    @Autowired
    private ConsignmentService consignmentService;
    @Autowired
    private UserOpenidRelationService userOpenidRelationService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private SmsService smsService;

    @Autowired
    private Environment environment;

    private boolean isCaptcha = false;

    private String CAPTCHA = "captch";


    // 1.个人用户注册
    @RequestMapping(value = "/a/user/register", method = RequestMethod.POST)
    public String register(HttpServletRequest request,
                           HttpServletResponse response, ModelMap model, String mobile,
                           String verify, String password) throws Exception {
        register_log.info("\n\n  =========================================================== \n");
        register_log.info(mobile + " is mobile " + verify + " is verify " + password + " is password ");
        int openAccount = User.NO_OPEN_ACCOUNT;
        int fundAccount = 0;
        Long userID = null;
        if (mobile == null || StringUtils.isBlank(verify) || StringUtils.isBlank(password)) {
            model.addAttribute("code", -1000);
            register_log.info("params is null");
            return "/common/success";
        }
        try {
            //第一步： 确认用户是否已注册
            Long relationID = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Person_Mobile);
            if (relationID != null) {
                register_log.info(mobile + " is already exist relationID is  " + relationID);
                model.addAttribute("code", -2003);
                return "/common/success";
            } else {
                register_log.info(mobile + " not exist ,so can register ");
            }

            //第二步：校验用户验证码
            boolean result = false;
            if ("666666".equals(verify)) {
                result = true;
            } else {
                result = verifyMobileCode(model, mobile, "register", verify);
            }
//            result = verifyMobileCode(model, mobile, "register", verify);
            register_log.info(" mobile: " + mobile + "  verify: " + verify + "  result: " + result);
            if (result) {
                Long userId = userService.getLatestUserId();

                //第三步： 创建用户
                User user = new User(mobile, password, User.TYPE_PERSON);
                user.setId(userId);
                user.setFundAccount(fundAccount);
                user.setAccStatus(openAccount);
                user.setVerifyStatus(User.VERIFY_NO);
                user.setAuthStatus(User.NO_AUTH);
                user.setStatus(User.USER_ACTIVIATE);
                userID = userService.insert(user);
                register_log.info(mobile + " register success,userID is " + userID);

                //第四步： 创建Person
                Person person = new Person();
                person.setId(userID);
                personService.insert(person);

                //第五步： 创建用户关系表
                UserOpenidRelation userOpenidRelation = new UserOpenidRelation();
                userOpenidRelation.setTypeId(userID);
                userOpenidRelation.setOpenId(mobile);
                userOpenidRelation.setStatus(Constant.Person_type);
                userOpenidRelationService.insert(userOpenidRelation);

                //第六步: 用户自动登录
                Map<String, String> maps = new HashMap();
                maps.put(CookieUtil.USER_ID, userID + "");
                cookieUtil.setIdentity(request, response, maps, userID);

                //获取kailincod
                //第八步： 调用CRM的接口，获取开磷code
                register_log.info("  kailin  code  take start ... ");
                String CRMUrl = "http://" + environment.getCrm() + "/api/account/new?type=1&mobile=" + mobile + "&contact=" + mobile + "&organcode=" + "&idno="
                        + "&name=" + mobile + "&bank=" + "&bankno=" + "&liccode=" + "&sfrom=fsp" + "&provincecode=" + "" + "&citycode=" + "" + "&address=" + "" + "&taxno=" + "" + "&loginID=" + mobile + "&inipwd=" + password + "&token=" + user.getKailinCode();

                register_log.info("URL : " + CRMUrl);
                try {
                    String code = com.qding.common.util.HttpClientUtil.sendPostRequest(CRMUrl, "", false);
                    JSONObject jsStr = JSONObject.fromObject(code);
                    User oldUser = userService.getObjectById(userID);

                    String crmcode = jsStr.get("scode") + "";
                    oldUser.setKailinCode(crmcode);
                    register_log.info("CRM code: " + code);
                    register_log.info("KAILIN CODE: " + oldUser.getKailinCode());
                    userService.update(oldUser);
                } catch (Exception e) {
                    e.printStackTrace(System.out);
                }
                register_log.info(" \n\n");
                model.put("uid", userID);
                model.addAttribute("code", 0);

            } else {
                register_log.error("wrong verifycode");
                model.addAttribute("code", -1006);
                return "/common/success";
            }
        } catch (Throwable t) {
            register_log.error(t.getMessage());
            register_log.error("add user error ");
            model.addAttribute("code", -1);
        }
        return "/wealth-user-service/user/json/register";
    }


    //验证码校验
    private boolean verifyMobileCode(ModelMap model, String mobile, String type, String verify) throws ServiceException, ServiceDaoException {
        log.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
        // 是否有发送验证码
        Long sid = smsService.getSmsIdByMobileAndType(mobile, type);
        log.info("sid is " + sid);

        if (sid == null) {
            return false;
        }
        // 获取验证码信息
        Sms sms = smsService.getObjectById(sid);
        log.info("sms is " + sms);
        // 获取验证码
        String message = sms.getMessage();
        log.info("message is " + message);
        //发送是否超时
        Long delay = System.currentTimeMillis() - sms.getSendAt();
        if (delay > 600000) {
            model.addAttribute("code", -1005);
            log.info("require verify too long");
            return false;
        }
        if (message.equals(verify)) {
            return true;
        } else {
            return false;
        }

    }


/**
 * ==============================  验证码   ================================================
 */

    // 个人注册，开户绑卡，通过代销发送验证码

    /**
     * 个人开户绑卡，发送短信验证码
     */

    //2、证联短信验证码
    @RequestMapping(value = "/a/u/zhenglian/send")
    public String sendMessage(HttpServletRequest request, HttpServletResponse response, ModelMap model, String bank, String bankNo) throws Exception {
        Long uid = cookieUtil.getID(request);
        log.info("person " + uid + " add card " + " bank: " + bank + " bankNo: " + bankNo);
        User user = userService.getObjectById(uid);
        try {
            Long time = System.currentTimeMillis();
            SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat date1 = new SimpleDateFormat("hhmmss");
            Integer intDate = Integer.parseInt(date.format(new Date(time)));
            Integer fundTime = Integer.parseInt(date1.format(new Date(time)));
            log.info(intDate + "============================" + fundTime);
            MessageAuthenticationCodeIn messageAuthenticationCodeIn = new MessageAuthenticationCodeIn();
            //	public MessageAuthenticationCodeIn(int fundDate, int fundTime, String userNameText, String fundSeqId, String tradeType, String mobile) {
            messageAuthenticationCodeIn.setFunctionId(9910);
            messageAuthenticationCodeIn.setUserNameText("clientname");
            messageAuthenticationCodeIn.setUserId(uid.toString());
            messageAuthenticationCodeIn.setFundAccount(user.getFundAccount());
            messageAuthenticationCodeIn.setFundDate(intDate);
            messageAuthenticationCodeIn.setFundTime(fundTime);
            messageAuthenticationCodeIn.setTradeType("01");
            messageAuthenticationCodeIn.setMobile(user.getMobile());
            messageAuthenticationCodeIn.setFundSeqId(intDate + fundTime + "5094");
            messageAuthenticationCodeIn.setBranchNo(GlobalConstant.BRANCH_NO);
            messageAuthenticationCodeIn.setCertType("0");
            messageAuthenticationCodeIn.setCertId("350128199509120928");
            messageAuthenticationCodeIn.setBankCode(bank);
            messageAuthenticationCodeIn.setCardNo(bankNo);
            messageAuthenticationCodeIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
            MessageAuthenticationCodeOut messageAuthenticationCodeOut = consignmentService.getMessageCode(messageAuthenticationCodeIn);
            log.info("========= MessageOut : " + messageAuthenticationCodeOut);
            if ("RC00".equals(messageAuthenticationCodeOut.getRespCode())) {
                model.addAttribute("code", 0);
            }
            model.addAttribute("messageAuthenticationCodeOut", messageAuthenticationCodeOut);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("person " + uid + " add card error");
            // for test
            model.addAttribute("code", -100000);
        }

        return "/wealth-user-service/user/json/addBankCard";
    }

}
