package com.ptteng.wealth.user.controller;

import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.common.service.SmsService;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.model.UserOpenidRelation;
import com.ptteng.wealth.user.service.PersonService;
import com.ptteng.wealth.user.service.UserOpenidRelationService;
import com.ptteng.wealth.user.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;
import com.gemantic.common.util.PasswordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by arthur on 16/6/25.
 */

@Controller
public class  UserLoginController extends BaseController {


    private static final Log log = LogFactory.getLog("login");
    @Autowired
    private UserService userService;
    @Autowired
    private PersonService personService;
    @Autowired
    private ConsignmentService consignmentService;
    @Autowired
    private UserOpenidRelationService userOpenidRelationService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private SmsService smsService;

    private boolean isCaptcha = false;
    private String CAPTCHA = "captch";

    //3、用户登录
    @RequestMapping(value = "/a/user/login", method = RequestMethod.POST)
    public String login(HttpServletRequest request, ModelMap model, HttpServletResponse response, String inputValue, String password, String type) throws Exception {
        log.info(" ====================================================================================");
        log.info(" L1:   inputValue: " + inputValue+ "   type: " + type + "   password: " + password );
        if (inputValue == null) {
            model.addAttribute("code", -2001);
            return "/common/success";
        }
        //判断Type，如果是机构登录，再判断是否是手机号登录
        String t=type;
        if("org".equals(type)){
            if(inputValue.length()==10 || inputValue.length()>11){
                log.info("  org code ");
                t=UserOpenidRelation.Type_Org_Code;
            }else{
                log.info(" mobile ");
                //手机号用户登录
                t=UserOpenidRelation.Type_Org_Mobile;
            }
        }

        Long id = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(inputValue, t);
        log.info(" L2:  useropendid : "+id);
        if (null == id) {
            model.addAttribute("code", -2000);
            return "/common/success";
        }
        UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(id);
        log.info(" L3  openidRelation: "+userOpenidRelation);
        if (null == userOpenidRelation) {
            model.addAttribute("code", -2000);
            return "/common/success";
        }
        Long uid = userOpenidRelation.getTypeId();
        log.info(" L4: USER ID : "+uid);
        User user = userService.getObjectById(uid);
        if (null == user) {
            model.addAttribute("code", -2000);
            return "/common/success";
        }
        //用户处于冻结状态时，不允许登陆
        else if(User.FREEZE_YES.equals(user.getFreezeStatus())){
            model.addAttribute("code",-2026 );
            return "/common/success";
        }
        else if(user.getStatus().equals(User.USER_UNACTIVIATE)){
            model.addAttribute("code",-2024 );
            return "/common/success";
        }
        else{
        	if("org".equals(type)){
        		if(!User.TYPE_ORG.equals(user.getType())){
        			 model.addAttribute("code",-2019 );
      			     return "/common/success";
        		}
        	}else{
               if(!User.TYPE_PERSON.equals(user.getType())){
        			 model.addAttribute("code",-2020 );
      			   return "/common/success";
        		}
        	}
        }
        if (password == null) {
            model.addAttribute("code", -2005);
            return "/common/success";
        }
        String pass = PasswordUtils.encode(password);
        String passwords = user.getPwd();
        log.info(" L5:  inputpass: "+pass +"  dbpasswords: "+passwords);
        log.info(" passwords: "+passwords);
        boolean verify = passwords.trim().equals(pass.trim());
        log.info(" L6:  verify: "+verify);
        if (verify) {
            log.info(" L7: "+inputValue + "  LOGIN SUCCESS ");
            Map<String, String> maps = new HashMap();
            maps.put(CookieUtil.USER_ID, uid + "");
            maps.put(type, inputValue);
            cookieUtil.setCookieMaxAge(2 * 60 * 60);
            cookieUtil.setIdentity(request, response, maps, uid);
            model.addAttribute("code", 0);
            model.addAttribute("user", user);
            log.info(" ====================================================================================");
        } else {
            log.info(" L7: "+inputValue + "  LOGIN SUCCESS ");
            log.info(inputValue + " wrong password " + password);
            model.put("code", -2004);
            log.info(" ====================================================================================");
            return "/common/success";
        }

        return "/wealth-user-service/user/json/userDetailJson";
    }

}
