package com.ptteng.wealth.user.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.DESUtil;
import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.PasswordUtils;
import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.Environment;
import com.ptteng.wealth.consign.constant.FunctionConstants;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.BalanceInquiryIn;
import com.ptteng.wealth.consign.model.in.OpenAccountIn;
import com.ptteng.wealth.consign.model.out.BalanceInquiryOut;
import com.ptteng.wealth.consign.model.out.OpenAccountOut;
import com.ptteng.wealth.finance.model.*;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.AccountRecord;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.*;
import com.ptteng.wealth.finance.service.account.AccountRecordService;
import com.ptteng.wealth.user.model.*;
import com.ptteng.wealth.user.service.OrgApplyService;
import com.ptteng.wealth.user.service.OrganizationService;
import com.ptteng.wealth.user.util.Constant;
import com.ptteng.wealth.util.DebtConstant;
import com.ptteng.wealth.util.sqlUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

import static java.lang.Math.ceil;

/**
 * Created by arthur on 16/6/24.
 */
@Controller
public class CrmController extends BaseController {

    protected Log log = LogFactory.getLog("crm");
    protected Log crmAgencyRegisterLog = LogFactory.getLog("crm_agency_register");
    protected Log crmPersonRegisterLog = LogFactory.getLog("crm_person_register");
    @Autowired
    private OrgApplyService orgApplyService;

    @Autowired
    private FundHistoryService fundHistoryService;

    @Autowired
    private CreditApplyService creditApplyService;

    @Autowired
    private LoanApplyService loanApplyService;

    @Autowired
    private DebtApplyService debtApplyService;

    @Autowired
    private AccountRecordService accountRecordService;

    @Autowired
    private OrganizationService organizationService;

    @Autowired
    private RefundsService refundsService;
    @Autowired
    private Environment environment;

    // 用户注册
    @RequestMapping(value = "/a/crmuser/person")
    public String register(ModelMap model, String token, String mobile, String cityNo, String provinceNo, String clientName, String orgName, String idNo/*,String bankAccount,String bankNo,String identifyingCode*/) throws Exception {
        try {
            crmPersonRegisterLog.info("======================================================================");
            crmPersonRegisterLog.info(" P1: MOBILE: " + mobile + " cityNo: " + cityNo + " provinceNo: " + provinceNo + " name: " + clientName + " orgName: " + orgName + " id: " + idNo);

            if(StringUtils.isEmpty(token) || StringUtils.isEmpty(mobile) || StringUtils.isEmpty(clientName)){
                crmPersonRegisterLog.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            //第一步：获取token
            String userKailinCode = DESUtil.decrypt(token.getBytes());
            crmPersonRegisterLog.info(" P1: CRM CODE: " + userKailinCode);
            Long uid = userService.getUserIdByKailinCode(userKailinCode);
            clientName = clientName.trim();
            if(StringUtils.isEmpty(orgName)){
                orgName = clientName;
            }
            if (uid != null) {
                crmPersonRegisterLog.info("KailinCode : " + userKailinCode + " is already exist  " + uid);
                // 判断是不是CRM修改了客户名称，如果是就是CRM中相应的表进行更新
                User user = userService.getObjectById(uid);
                if (!clientName.equals(user.getName())) {
                    user.setName(clientName);
                    userService.update(user);
                    crmPersonRegisterLog.info("KailinCode : " + userKailinCode + " update user name  " + clientName);

                    Person person = personService.getObjectById(uid);
                    if (person != null) {
                        person.setName(clientName);
                        person.setOrgName(orgName);
                        personService.update(person);
                        crmPersonRegisterLog.info("person id : " + uid + ", update person name  " + clientName );
                    }

                    updateHistoryData(uid, clientName, orgName);
                }
                model.addAttribute("code", -2032);
                return "/common/success";
            } else {
                crmPersonRegisterLog.info("KailinCode : " + userKailinCode + " not exist ,so can register ");
            }
            //第一步： 是否已注册
            Long uoid = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Person_Mobile);
            if (uoid != null) {
                crmPersonRegisterLog.info("P2: " + mobile + " is already exist userOpenidRelation " + uoid);
                model.addAttribute("code", -2003);
                return "/common/success";
            } else {
                crmPersonRegisterLog.info("P3: " + mobile + " not exist ,so can register ");
            }
            //第二步：创建用户  和 UserOpenIdRelation

            User user = new User(mobile, "", User.TYPE_PERSON);
            user.setName(clientName);
            user.setKailinCode(userKailinCode);
            user.setStatus(User.USER_UNACTIVIATE);
            user.setVerifyStatus(User.VERIFY_NO);
            user.setAuthStatus(User.NO_AUTH);
            Long userID = userService.insert(user);

            Person person = new Person();
            person.setId(userID);
            person.setName(clientName);
            person.setOrgName(orgName);
            person.setIdNo(idNo);
            crmPersonRegisterLog.info("insert person " + person);
            personService.insert(person);

            crmPersonRegisterLog.info("P3: " + mobile + " register success,userID is " + userID);
            UserOpenidRelation userOpenidRelation = new UserOpenidRelation();
            userOpenidRelation.setTypeId(userID);
            userOpenidRelation.setOpenId(mobile);
            userOpenidRelation.setStatus(Constant.Person_type);
            uoid = userOpenidRelationService.insert(userOpenidRelation);
            crmPersonRegisterLog.info("P4: mobile: " + mobile + "  uoid: " + uoid);

            //第三步： 开户
            if (null != userID) {
                try {
                    OpenAccountIn openAccountIn = new OpenAccountIn();
                    openAccountIn.setFunctionId(FunctionConstants.OPENAccount);
                    openAccountIn.setMobiletelephone(mobile);
                    openAccountIn.setUserId(userID.toString());
                    openAccountIn.setCityNo("");
                    openAccountIn.setProvinceNo("");  //CRM 系统提到的省市编码，超过代销系统要求
                    openAccountIn.setClientName(clientName);
                    openAccountIn.setMobiletelephone(mobile);
                    openAccountIn.setIdNo(idNo);
                    openAccountIn.setIdKind("0");
                    openAccountIn.setPassword("123456");  //代销系统的交易密码
                    OpenAccountOut openAccountOut = consignmentService.openAccount(openAccountIn);
                    crmPersonRegisterLog.info(" P5: " + openAccountOut);
                    if (0 != openAccountOut.getFundAccount()) {
                        user.setFundAccount(openAccountOut.getFundAccount());
                        user.setAccStatus(User.ALREADY_OPEN_ACCOUNT);
                        userService.update(user);
                        crmPersonRegisterLog.info(" P6: update user: " + user.getId() + " fundcode: " + user.getFundAccount());
                    }
                } catch (Exception e) {
                    crmPersonRegisterLog.info(e.getMessage());
                }
            }

            Map<String, String> maps = new HashMap();
            maps.put(CookieUtil.USER_ID, userID + "");
            model.put("uid", userID);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            crmPersonRegisterLog.error(t.getMessage());
            crmPersonRegisterLog.error("add user error ");
            model.addAttribute("code", -1);
        }
        return "/wealth-user-service/user/json/register";
    }

    private void updateHistoryData(Long uid, String clientName, String orgName) throws ServiceException, ServiceDaoException {
        List<Long> fundHistoryIds = new ArrayList<Long>();

        //上账 转账充值
        fundHistoryIds.addAll(fundHistoryService.getFundHistoryIdsByUidAndType(uid, FundHistory.TYPE_Charge_Account, 0, Integer.MAX_VALUE));
        //转账至其他账户
        fundHistoryIds.addAll(fundHistoryService.getFundHistoryIdsByUidAndType(uid, FundHistory.TYPE_Draw_Account, 0, Integer.MAX_VALUE));
        //支付记录
        fundHistoryIds.addAll(fundHistoryService.getFundHistoryIdsByUidAndType(uid, FundHistory.TYPE_Pay, 0, Integer.MAX_VALUE));
        //退款记录
        fundHistoryIds.addAll(fundHistoryService.getFundHistoryIdsByUidAndType(uid, FundHistory.TYPE_Refund, 0, Integer.MAX_VALUE));

        if (CollectionUtils.isNotEmpty(fundHistoryIds)) {
            List<FundHistory> fundHistories = fundHistoryService.getObjectsByIds(fundHistoryIds);
            for (FundHistory fh : fundHistories) {
                fh.setName(clientName);
            }
            fundHistoryService.updateList(fundHistories);
        }

        List<Long> creditApplyIds = creditApplyService.getCreditApplyIdsByUid(uid, 0, Integer.MAX_VALUE);
        if (CollectionUtils.isNotEmpty(creditApplyIds)) {
            List<CreditApply> creditApplies = creditApplyService.getObjectsByIds(creditApplyIds);
            for (CreditApply ca : creditApplies) {
                ca.setOrgName(orgName);
            }
            creditApplyService.updateList(creditApplies);
        }
        List<Long> accountRecordIds = accountRecordService.getAccountRecordIdsByUserIdOrderByUpdateAt(uid, 0, Integer.MAX_VALUE);
        if (CollectionUtils.isNotEmpty(accountRecordIds)) {
            List<AccountRecord> accountRecords = accountRecordService.getObjectsByIds(accountRecordIds);
            for (AccountRecord ar : accountRecords) {
                ar.setOrgName(orgName);
            }
            accountRecordService.updateList(accountRecords);
        }

        List<Long> loanApplyIds = loanApplyService.getLoanApplyIdsByUid(uid, 0, Integer.MAX_VALUE);
        if (CollectionUtils.isNotEmpty(loanApplyIds)) {
            List<LoanApply> loanApplies = loanApplyService.getObjectsByIds(loanApplyIds);
            for (LoanApply la : loanApplies) {
                la.setUserName(orgName);
            }
            loanApplyService.updateList(loanApplies);
        }

        List<Long> debtApplyIds = debtApplyService.getDebtApplyIdsByUid(uid, 0, Integer.MAX_VALUE);
        if (CollectionUtils.isNotEmpty(debtApplyIds)) {
            List<DebtApply> debtApplies = debtApplyService.getObjectsByIds(debtApplyIds);
            for (DebtApply da : debtApplies) {
                da.setUserName(orgName);
            }
            debtApplyService.updateList(debtApplies);
        }

        List<Long> refundIds = refundsService.getRefundsIdsByUid(uid, 0, Integer.MAX_VALUE);
        if (CollectionUtils.isNotEmpty(refundIds)) {
            List<Refunds> refunds = refundsService.getObjectsByIds(refundIds);
            for (Refunds r : refunds) {
                r.setName(orgName);
            }
            refundsService.updateList(refunds);
        }
    }

    //CRM  机构注册开户绑卡
    @RequestMapping(value = "/a/crmuser/agency")
    public String orgApply(ModelMap model, String token, String mobile, String name, String personName, String organCode, String password,
                           String bank, String cardNo, String licenceCode) throws Exception {


        crmAgencyRegisterLog.info(" ===============================================================");
        crmAgencyRegisterLog.info(" crm org apply  organCode: " + organCode + "  mobile: " + mobile + "  name: " + name + " personName: " + personName + " licenceCode: " + licenceCode + " bank: " + bank + "  cardNo: " + cardNo);
        try {

            if(StringUtils.isEmpty(token) || StringUtils.isEmpty(mobile) || StringUtils.isEmpty(name)){
                crmPersonRegisterLog.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            if(StringUtils.isEmpty(personName)){
                personName = name;
            }

            //第一步： 是否已注册
            Long uoid = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(mobile, UserOpenidRelation.Type_Org_Mobile);
            if (uoid != null) {
                crmAgencyRegisterLog.info("mobile : " + mobile + " is already exist userOpenidRelation " + uoid);
                UserOpenidRelation userOpenidRelation = userOpenidRelationService.getObjectById(uoid);
                Long uid = userOpenidRelation.getTypeId();
                User user = userService.getObjectById(uid);
                if (!name.equals(user.getName())) {
                    user.setName(name);
                    userService.update(user);
                    crmAgencyRegisterLog.info("KailinCode : " + user.getKailinCode() + " update user name  " + name);

                    Long orgApplyId = orgApplyService.getOrgApplyIdByMobile(mobile);
                    OrgApply orgApply = orgApplyService.getObjectById(orgApplyId);
                    if (orgApply != null) {
                        orgApply.setName(personName);
                        orgApplyService.update(orgApply);
                        crmAgencyRegisterLog.info("ortApply id : " + orgApplyId + ", update orgApply personName  " + personName );
                    }

                    Organization organization = organizationService.getObjectById(uid);
                    if (organization != null) {
                        organization.setName(personName);
                        organizationService.update(organization);
                        crmAgencyRegisterLog.info("organization id : " + uid + ", update personName  " + personName );
                    }

                    updateHistoryData(uid, name, name);
                }
                model.addAttribute("code", -2003);
                return "/common/success";
            } else {
                crmAgencyRegisterLog.info("mobile : " + mobile + " not exist ,so can register ");
            }

            //第一步：获取token
            String userKailinCode = DESUtil.decrypt(token.getBytes());
            crmAgencyRegisterLog.info("CRM CODE: " + userKailinCode);

            Long uid = userService.getUserIdByKailinCode(userKailinCode);
            if (uid != null) {
                crmAgencyRegisterLog.info("KailinCode : " + userKailinCode + " is already exist  " + uid);
                model.addAttribute("code", -2032);
                return "/common/success";
            } else {
                crmAgencyRegisterLog.info("KailinCode : " + userKailinCode + " not exist ,so can register ");
            }

            //第三步：

            OrgApply orgApply = new OrgApply();
            orgApply.setName(personName);
            orgApply.setPassword(PasswordUtils.encode(password));
            orgApply.setMobile(mobile);
            orgApply.setOrgCode(organCode);
            orgApply.setBank(bank);
            orgApply.setCardNo(cardNo);
            orgApply.setLicenceCode(licenceCode);
            orgApply.setKailinCode(userKailinCode);
            //区分一下三证合一
            if (licenceCode != null && organCode != null && licenceCode.equals(organCode)) {
                orgApply.setOrgType(OrgApply.ONE_CARD);//三证合一
                orgApply.setCreditCode(licenceCode);
            } else {
                orgApply.setOrgType(OrgApply.THREE_CARD);//组织机构证，营业执照证都在
            }
            orgApply.setStatus(OrgApply.STATUS_0);

            //第四步： 创建用户表，并且设置用户为未激活状态
            User user = createUserInfo(orgApply, null, name, crmAgencyRegisterLog, userKailinCode, true);

            //第五步: 创建机构申请记录
            Long oldOrgApplyId = orgApplyService.getOrgApplyIdByMobile(mobile);
            if (null != oldOrgApplyId) {
                OrgApply oldOrgApply = orgApplyService.getObjectById(oldOrgApplyId);
                if (null != oldOrgApply) {
                    updateOrgApplyInfo(orgApply, oldOrgApplyId, oldOrgApply, crmAgencyRegisterLog);
                    model.addAttribute("code", 0);
                    return "/data/json";
                }
            } else {
                orgApply.setUid(user.getId());
                Long orgApplyId = orgApplyService.insert(orgApply);
                crmAgencyRegisterLog.info("  create orgApplyId =  " + orgApplyId);
            }
            crmAgencyRegisterLog.info("========================================================================");
            model.addAttribute("code", 0);
        } catch (Exception e) {
            crmAgencyRegisterLog.error("get  error", e);
            model.addAttribute("code", -1);
        }
        return "/common/success1";
    }


    // 8、本人资金信息读取
    @RequestMapping(value = "/a/crmuser/fund", method = RequestMethod.GET)
    public String getUserFund(HttpServletRequest request, ModelMap model, String token) throws Exception {

        log.info("token : " + token);

        if (null == token) {
            model.addAttribute("code", -2000);
            log.info(" token is null");
            return "/common/success";
        }

        //第一步：获取token
        String userKailinCode = DESUtil.decrypt(token.getBytes());
        log.info("CRM CODE: " + userKailinCode);

        //第二步：获取Userid
        Long uid = userService.getUserIdByKailinCode(userKailinCode);


        //第一步： 获取用户信息
        User user = userService.getObjectById(uid);
        log.info("S1 userid: " + uid);
        if (null == uid) {
            model.addAttribute("code", -2000);
            log.info(" userid : " + uid + " not exist");
            return "/common/success";
        }
        try {
            Fund fund = fundService.getObjectById(uid);
            BigDecimal totalRepay = caculateRepayTotal(uid);
            log.info("totalRepay is : " + totalRepay);
            fund.setRepayTot(totalRepay);
            fundService.update(fund);

            List<UserAccountRelation> relations = new ArrayList<UserAccountRelation>();
            List<Long> relationIds = userAccountRelationService.getUserAccountRelationIdsByUserId(uid, 0, Integer.MAX_VALUE);
            relations = userAccountRelationService.getObjectsByIds(relationIds);
            log.info("relations : " + relations.size());

            List<Account> accounts = accountService.getObjectsByIds(accountService.getAccountIds(0, Integer.MAX_VALUE));
            HashMap<String, String> accountName = new HashMap();
            for(Account account : accounts){
                accountName.put(account.getAccCode(), account.getName());
            }


            BalanceInquiryOut balance = null;

            try {
                BalanceInquiryIn balanceInquiryIn = new BalanceInquiryIn();
                balanceInquiryIn.setBranchNo(GlobalConstant.BRANCH_NO);
                balanceInquiryIn.setFundAccount(user.getFundAccount());
                balanceInquiryIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                balanceInquiryIn.setUserId(user.getId() + "");

                if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
                    log.info("user type : " + user.getType());
                    Person person = personService.getObjectById(user.getId());
                    log.info("person : " + person);
                    balanceInquiryIn.setCertType("0");
                    balanceInquiryIn.setCertId(person.getIdNo());
                    balanceInquiryIn.setUserNameText(user.getName());
                } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
                    log.info("user type : " + user.getType());
                    Organization organization = organizationService.getObjectById(user.getId());
                    log.info("organization : " + organization);
                    balanceInquiryIn.setCertType(Constant.IDKIND);
                    balanceInquiryIn.setUserNameText(organization.getName());
                    balanceInquiryIn.setCertId(organization.getUseCertId());
                }
                balanceInquiryIn.setPassword(user.getPayPwd());
                balanceInquiryIn.setGtTradePassword(user.getPayPwd());
                balanceInquiryIn.setIfQueryTransitmAmt("1");
                balance = consignmentService.getBalance(balanceInquiryIn);
                log.info(balance);
            } catch (Exception e) {
                log.info(e.getMessage());
            }

            BigDecimal overTotalRepay = new BigDecimal("0");
            BigDecimal repayLine = new BigDecimal("0");
            BigDecimal overRepay = new BigDecimal("0");
            BigDecimal overRate = new BigDecimal("0");
            BigDecimal supposeRepay = new BigDecimal("0");
            BigDecimal debtCount = new BigDecimal("0");
            BigDecimal rate = new BigDecimal("0");
            BigDecimal dayCount = new BigDecimal("0");
            Long debtStart = 0L;
            Long time = 0L;

            //还款中金额
            String repaySql = sqlUtil.getDynamicSql(null, uid, null, DebtApply.TYPE_REPAY, 0 , Integer.MAX_VALUE);
            log.info("get repay apply sql is " + repaySql);
            List<DebtApply> repayApply = debtApplyService.getObjectsBySql(DebtApply.class, repaySql);
            log.info("get debt repay data is " + repayApply.size());

            for (DebtApply debtApply : repayApply) {
                //借款本金利率
                debtCount = debtApply.getDebtCount();
                rate = debtApply.getRate();

                //获取当前借款时间
                debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
                time = System.currentTimeMillis() - debtStart;
                dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME));

                //加上本息
                supposeRepay = caculate(debtCount, rate, dayCount).add(debtCount);
                totalRepay = totalRepay.add(supposeRepay);
            }

            String debtSql = sqlUtil.getDynamicSql(null, uid, null, DebtApply.TYPE_OVERTIME, 0, Integer.MAX_VALUE);
            log.info("get overtime apply sql is " + debtSql);
            List<DebtApply> debtApplys = debtApplyService.getObjectsBySql(DebtApply.class, debtSql);
            log.info("get debt over time data is " + debtApplys.size());

            for (DebtApply debtApply : debtApplys) {
                //借款本金、利率
                debtCount = debtApply.getDebtCount();
                overRate = debtApply.getOverRate();
                rate = debtApply.getRate();

                //获取总借款利息
                repayLine = new BigDecimal(debtApply.getRepayLine());
                overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);

                //获取当前逾期时间
                debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
                time = System.currentTimeMillis() - debtStart;
                dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);

                //获取当前罚息
                overRepay = caculate(overTotalRepay, overRate, dayCount).add(overTotalRepay);
                totalRepay = totalRepay.add(overRepay);
            }

            fund.setRepayTot(totalRepay);

            //借贷总金额
            BigDecimal totalDebtMoney = new BigDecimal("0");
            BigDecimal totalDebtOvertimeMoney = new BigDecimal("0");
            BigDecimal historyTotalDebtMoney = new BigDecimal("0");
            List<Long> debtIdLs = debtApplyService.getDebtApplyIdsByUid(uid, 0, Integer.MAX_VALUE);
            List<DebtApply> debtApplies = debtApplyService.getObjectsByIds(debtIdLs);
            for (DebtApply debtApply : debtApplies) {
                historyTotalDebtMoney = historyTotalDebtMoney.add(debtApply.getDebtCount());
                if (debtApply.getStatus().equals(DebtApply.STATUS_CLEAR) || debtApply.getStatus().equals(DebtApply.STATUS_REFUSE)
                        || debtApply.getStatus().equals(DebtApply.STATUS_KAILIN_REFUSE) || debtApply.getStatus().equals(DebtApply.STATUS_CANCEL)) {
                    continue;
                }
                if(debtApply.getStatus().equals(DebtApply.STATUS_OVERTIME)){
                    totalDebtOvertimeMoney = totalDebtOvertimeMoney.add(debtApply.getDebtCount());
                }
                totalDebtMoney = totalDebtMoney.add(debtApply.getDebtCount());
            }

            //赊销总金额
            BigDecimal totalLoanMoney = new BigDecimal("0");
            BigDecimal totalLoanOvertimeMoney = new BigDecimal("0");
            BigDecimal historyTotalLoanMoney = new BigDecimal("0");
            List<Long> loanIdLs = loanApplyService.getLoanApplyIdsByUid(uid, 0, Integer.MAX_VALUE);
            List<LoanApply> loanApplies = loanApplyService.getObjectsByIds(loanIdLs);
            for (LoanApply loanApply : loanApplies) {
                historyTotalLoanMoney = historyTotalLoanMoney.add(loanApply.getDebtCount());
                if (loanApply.getStatus().equals(LoanApply.STATUS_CLEAR) || loanApply.getStatus().equals(LoanApply.STATUS_REFUSE)
                        || loanApply.getStatus().equals(LoanApply.STATUS_KAILIN_REFUSE) || loanApply.getStatus().equals(LoanApply.STATUS_CANCEL)) {
                    continue;
                }
                if(loanApply.getStatus().equals(LoanApply.STATUS_OVERTIME)){
                    totalLoanOvertimeMoney = totalLoanOvertimeMoney.add(loanApply.getDebtCount());
                }
                totalLoanMoney = totalLoanMoney.add(loanApply.getDebtCount());
            }

            BigDecimal debtTot = totalDebtMoney.add(totalLoanMoney);

            fund.setOverdueTot(totalDebtOvertimeMoney.add(totalLoanOvertimeMoney));
            fundService.update(fund);

            BigDecimal availableLine = fund.getCreditLine().subtract(debtTot);
            Integer zeroVerify = availableLine.compareTo(new BigDecimal("0"));
            if (-1 == zeroVerify) {
                availableLine = new BigDecimal("0");
            }
            log.info("availableLine : " + availableLine);

            //证联余额
            BigDecimal balanceFee = new BigDecimal("0");
            if (null != balance && 0 == balance.getErrorNo()) {
                model.addAttribute("wayFund", balance.getRedeeTransitmAmt());
                model.addAttribute("balance", balance.getTotalAmt());
                balanceFee = balance.getTotalAmt();
            } else {
                model.addAttribute("wayFund", 0);
                model.addAttribute("balance", 0);
            }

            //资产总额
            BigDecimal fundTot = balanceFee;
            for (UserAccountRelation userAccountRelation : relations) {
                fundTot = fundTot.add(userAccountRelation.getMoney());
            }
            log.info("fundTot : " + fundTot);

            log.info("accountName " + accountName);
            log.info("relations " + relations);
            model.addAttribute("code", 0);
            model.addAttribute("fund", fund);
            model.addAttribute("accountName", accountName);
            model.addAttribute("relations", relations);
            model.addAttribute("fundTot", fundTot);
            model.addAttribute("loanNowTot", debtTot);
            model.addAttribute("loanTot", historyTotalDebtMoney.add(historyTotalLoanMoney));
            model.addAttribute("availableLine", availableLine);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get user error");
            model.addAttribute("code", -1);
        }
        return "/wealth-user-service/user/json/crmUserFundDetail";
    }

    //36、申请借款列表
    @RequestMapping(value = "/a/crm/debt/apply/list", method = RequestMethod.GET)
    public String getDebtApply(HttpServletRequest request, HttpServletResponse response, ModelMap model,String token, Integer page, Integer size) throws Exception {

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        log.info("token : " + token);

        if (null == token) {
            model.addAttribute("code", -2000);
            log.info(" token is null");
            return "/common/success";
        }

        //第一步：获取token
        String userKailinCode = DESUtil.decrypt(token.getBytes());
        log.info("CRM CODE: " + userKailinCode);

        //第二步：获取Userid
        Long uid = userService.getUserIdByKailinCode(userKailinCode);


        //第一步： 获取用户信息
        User user = userService.getObjectById(uid);
        log.info("userId: " + uid);
        if (null == uid) {
            model.addAttribute("code", -2000);
            log.info(" userid : " + uid + " not exist");
            return "/common/success";
        }

        try {
            String verifySql = sqlUtil.getDynamicSql(null, uid, null, DebtApply.TYPE_VERIFYING, firstNmuber, size);
            log.info("get verify apply sql is " + verifySql);
            List<DebtApply> verifyApplys = debtApplyService.getObjectsBySql(DebtApply.class, verifySql);
            log.info("get debt verify data is " + verifyApplys.size());

            List<Long> uids = new ArrayList<>();

            for(DebtApply debtApply : verifyApplys){
                uids.add(debtApply.getUid());
            }

            List<User> users = userService.getObjectsByIds(uids);
            Map<Long, Order> id_user = MyListUtil.convert2Map(User.class.getDeclaredField("id"), users);
            model.addAttribute("id_user", id_user);

            log.info("   total = " + verifyApplys.size());
            Integer totalPage = (((verifyApplys.size() - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            if (verifyApplys != null && verifyApplys.size() > 0) {
                if (size.equals(verifyApplys.size())) {
                    next = true;
                }
            }

            HashMap<Integer, String> statusName = new HashMap<>();
            statusName.put(1, "审核中");
            statusName.put(2, "初审通过");
            statusName.put(3, "终审通过");
            statusName.put(4, "还款中");
            statusName.put(5, "逾期");
            statusName.put(6, "已还清");
            statusName.put(7, "终审拒绝");
            statusName.put(8, "初审拒绝");
            statusName.put(9, "取消借款");
            model.addAttribute("statusName", statusName);

            HashMap<Integer, String> orderTypeName = new HashMap<>();
            orderTypeName.put(1, "贵州开磷息峰合成氨有限责任公司");
            orderTypeName.put(2, "贵州开磷化肥有限责任公司");
            orderTypeName.put(3, "贵州开磷有限责任公司");
            orderTypeName.put(4, "贵州开磷集团国际贸易有限公司");
            model.addAttribute("orderTypeName", orderTypeName);

            HashMap<Integer, String> repayWay = new HashMap<>();
            repayWay.put(1, "一次性还本付息");
            model.addAttribute("repayWay", repayWay);

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("debtApplys", verifyApplys);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("et user debt list error, uid is  " + uid);
            model.addAttribute("code", -1);
        }

        return "/wealth-user-service/user/json/crmDebtApply";
    }

    //38、借款列表
    @RequestMapping(value = "/a/crm/debt/list", method = RequestMethod.GET)
    public String getDebtList(HttpServletRequest request, HttpServletResponse response, ModelMap model,String token, Integer page, Integer size) throws Exception {
        HashMap<Long, BigDecimal> id_supposeRepay = new HashMap<>();
        HashMap<Long, BigDecimal> id_dayCount = new HashMap<>();
        HashMap<Long, String> id_overDate = new HashMap<>();
        BigDecimal supposeRepay = new BigDecimal("0");
        BigDecimal dayCount = new BigDecimal("0");
        BigDecimal overRepay = new BigDecimal("0");
        BigDecimal totalRepay = new BigDecimal("0");
        BigDecimal debtCount = new BigDecimal("0");
        BigDecimal overRate = new BigDecimal("0");
        BigDecimal repayLine = new BigDecimal("0");
        BigDecimal rate = new BigDecimal("0");
        Long debtStart = 0L;
        Long time = 0L;
        String overDate = "";
        Long overAt = 0L;
        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        log.info("token : " + token);

        if (null == token) {
            model.addAttribute("code", -2000);
            log.info(" token is null");
            return "/common/success";
        }

        //第一步：获取token
        String userKailinCode = DESUtil.decrypt(token.getBytes());
        log.info("CRM CODE: " + userKailinCode);

        //第二步：获取Userid
        Long uid = userService.getUserIdByKailinCode(userKailinCode);


        //第一步： 获取用户信息
        User user = userService.getObjectById(uid);
        log.info("userId: " + uid);
        if (null == uid) {
            model.addAttribute("code", -2000);
            log.info(" userid : " + uid + " not exist");
            return "/common/success";
        }

        try {
            String overtimeSql = sqlUtil.getNotDynamicSql(null, uid, null, DebtApply.TYPE_VERIFYING, firstNmuber, size);
            log.info("get apply sql is " + overtimeSql);
            List<DebtApply> debtApplys = debtApplyService.getObjectsBySql(DebtApply.class, overtimeSql);
            log.info("get debt data is " + debtApplys.size());

            List<Long> uids = new ArrayList<>();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String date = "";

            for (DebtApply debtApply : debtApplys) {

                uids.add(debtApply.getUid());

                overAt = debtApply.getOverAt();
                if(null != overAt){
                    overDate = dateFormat.format(new Date(overAt));
                    id_overDate.put(debtApply.getId(), overDate);
                }

                if(DebtApply.TYPE_OVERTIME.equals(debtApply.getType())){
                    //借款本金、利率
                    debtCount = debtApply.getDebtCount();
                    overRate = debtApply.getOverRate();
                    rate = debtApply.getRate();

                    //获取总借款利息
                    repayLine = new BigDecimal(debtApply.getRepayLine());
                    totalRepay = caculate(debtCount, rate, repayLine).add(debtCount);

                    //获取当前逾期时间
                    debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
                    time = System.currentTimeMillis() - debtStart;
                    dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);
                    id_dayCount.put(debtApply.getId(), dayCount);

                    //获取当前罚息
                    overRepay = caculate(totalRepay, overRate, dayCount);

                    id_supposeRepay.put(debtApply.getId(), totalRepay.add(overRepay));

                }else if(DebtApply.TYPE_REPAY.equals(debtApply.getType())){
                    //借款本金利率
                    debtCount = debtApply.getDebtCount();
                    rate = debtApply.getRate();

                    //获取当前借款时间
                    debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getDebtAt()).getTime();
                    time = System.currentTimeMillis() - debtStart;
                    dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME));

                    //计算当前本息
                    supposeRepay = caculate(debtCount, rate, dayCount).add(debtCount);
                    id_supposeRepay.put(debtApply.getId(), supposeRepay);
                }

            }
            log.info("   total = " + debtApplys.size());
            Integer totalPage = (((debtApplys.size() - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);
            if (debtApplys != null && debtApplys.size() > 0) {
                if (size.equals(debtApplys.size())) {
                    next = true;
                }
            }

            model.addAttribute("id_overDate", id_overDate);

            List<User> users = userService.getObjectsByIds(uids);

            Map<Long, Order> id_user = MyListUtil.convert2Map(User.class.getDeclaredField("id"), users);
            model.addAttribute("id_user", id_user);

            HashMap<Integer, String> statusName = new HashMap<>();
            statusName.put(1, "审核中");
            statusName.put(2, "初审通过");
            statusName.put(3, "终审通过");
            statusName.put(4, "还款中");
            statusName.put(5, "逾期");
            statusName.put(6, "已还清");
            statusName.put(7, "终审拒绝");
            statusName.put(8, "初审拒绝");
            statusName.put(9, "取消借款");
            model.addAttribute("statusName", statusName);

            HashMap<Integer, String> orderTypeName = new HashMap<>();
            orderTypeName.put(1, "贵州开磷息峰合成氨有限责任公司");
            orderTypeName.put(2, "贵州开磷化肥有限责任公司");
            orderTypeName.put(3, "贵州开磷有限责任公司");
            orderTypeName.put(4, "贵州开磷集团国际贸易有限公司");
            model.addAttribute("orderTypeName", orderTypeName);

            HashMap<Integer, String> repayWay = new HashMap<>();
            repayWay.put(1, "一次性还本付息");
            model.addAttribute("repayWay", repayWay);

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("debtApplys", debtApplys);
            model.addAttribute("id_supposeRepay", id_supposeRepay);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("et user debt list error, uid is  " + uid);
            model.addAttribute("code", -1);
        }
        return "/wealth-user-service/user/json/crmDebtList";
    }


    public BigDecimal caculateRepayTotal(Long uid) throws Exception {
        BigDecimal overTotalRepay = new BigDecimal("0");
        BigDecimal repayLine = new BigDecimal("0");
        BigDecimal overRepay = new BigDecimal("0");
        BigDecimal overRate = new BigDecimal("0");
        BigDecimal supposeRepay = new BigDecimal("0");
        BigDecimal totalRepay = new BigDecimal("0");
        BigDecimal debtCount = new BigDecimal("0");
        BigDecimal rate = new BigDecimal("0");
        BigDecimal dayCount = new BigDecimal("0");
        Long debtStart = 0L;
        Long time = 0L;

        //还款中金额
        List<Long> repayIds = debtApplyService.getDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_REPAY, 0, Integer.MAX_VALUE);
        List<DebtApply> repayApply = debtApplyService.getObjectsByIds(repayIds);
        log.info("get debt repay data is " + repayApply.size());

        for (DebtApply debtApply : repayApply) {
            //借款本金利率
            debtCount = debtApply.getDebtCount();
            rate = debtApply.getRate();

            //获取当前借款时间
            debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
            time = System.currentTimeMillis() - debtStart;
            dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME));

            //加上本息
            supposeRepay = caculate(debtCount, rate, dayCount).add(debtCount);
            totalRepay = totalRepay.add(supposeRepay);
        }

        List<Long> debtApplieIds = debtApplyService.getDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_OVERTIME, 0, Integer.MAX_VALUE);
        List<DebtApply> debtApplys = debtApplyService.getObjectsByIds(debtApplieIds);
        log.info("get debt over time data is " + debtApplys.size());

        for (DebtApply debtApply : debtApplys) {
            //借款本金、利率
            debtCount = debtApply.getDebtCount();
            overRate = debtApply.getOverRate();
            rate = debtApply.getRate();

            //获取总借款利息
            repayLine = new BigDecimal(debtApply.getRepayLine());
            overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);

            //获取当前逾期时间
            debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
            time = System.currentTimeMillis() - debtStart;
            dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);

            //获取当前罚息
            overRepay = caculate(overTotalRepay, overRate, dayCount).add(overTotalRepay);
            totalRepay = totalRepay.add(overRepay);
        }

        return totalRepay;
    }

    //计算利息
    public BigDecimal caculate(BigDecimal debtCount, BigDecimal rate, BigDecimal day) {
        log.info("caculate : debtCount = " + debtCount + " rate = " + rate + " day = " + day);
        if(null == rate){
            return BigDecimal.ZERO;
        }
        BigDecimal result = debtCount.multiply(day).multiply(rate).divide(DebtConstant.HUNDRED, 3, BigDecimal.ROUND_HALF_UP).divide(DebtConstant.YEAR, 3, BigDecimal.ROUND_HALF_UP);
        return result;
    }
}
