package com.ptteng.wealth.finance.controller;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.wealth.consign.constant.FunctionConstants;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.*;
import com.ptteng.wealth.consign.model.out.*;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.finance.model.FundHistory;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.service.FundHistoryService;
import com.ptteng.wealth.finance.service.OrderService;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.OrganizationService;
import com.ptteng.wealth.user.service.PersonService;
import com.ptteng.wealth.user.service.UserService;
import com.ptteng.wealth.user.util.Constant;
import com.ptteng.wealth.util.ConsignConstructor;
import com.ptteng.wealth.util.DebtConstant;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.service.FundService;

/**
 * Fund  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 *
 */
@Controller
public class FundHistoryController {
    private static final Log log = LogFactory.getLog("transaction");

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private FundHistoryService fundHistoryService;

    @Autowired
    private OrderService orderService;

    @Autowired
    private UserService userService;

    @Autowired
    private PersonService personService;

    @Autowired
    private OrganizationService organizationService;

    @Autowired
    private ConsignmentService consignmentService;

    //开磷账户流水
    @RequestMapping(value = "/a/u/user/transaction/list", method = RequestMethod.GET)
    public String transactionList(HttpServletRequest request, ModelMap model, HttpServletResponse response, Integer type, Integer page, Integer size) throws Exception {

        log.info("get user transaction list : type : "+ type);

        if(null == type){
            log.info("type can't be null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        try {
            Long uid = cookieUtil.getID(request);
            log.info("get user detail : " + uid);
            User user = userService.getObjectById(uid);

            List<Long> ids = fundHistoryService.getFundHistoryIdsByUidAndType(uid, type, firstNmuber, size);
            log.info("get transaction data is " + ids.size());

            Integer total = fundHistoryService.countFundHistoryIdsByUidAndType(uid, type);
            log.info("get total transaction data size is " + total);

            List<FundHistory> fundHistories = fundHistoryService.getObjectsByIds(ids);

            if(CollectionUtils.isNotEmpty(fundHistories)){
                model.addAttribute("fundHistories", fundHistories);
            }else{
                log.info("no type : " + type + " transaction ");
            }

            Integer totalPage = (((total - 1)) / size) + 1;
            log.info("   totalPage = " + totalPage);

            if (ids != null && ids.size() > 0) {
                if (size.equals(ids.size())) {
                    next = true;
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" get transaction list : type " + type + " error ");
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/fundHistory/json/fundHistoryListJson";
    }


    //余额账户线上充值记录
    @RequestMapping(value = "/a/u/user/recharge/list", method = RequestMethod.GET)
    public String fundRechargeList(HttpServletRequest request, ModelMap model, HttpServletResponse response, Integer page, Integer size) throws Exception {

        log.info("get user recharge list ");

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        try {
            Long uid = cookieUtil.getID(request);
            log.info("get user detail : " + uid);
            User user = userService.getObjectById(uid);

            RechargeWaterQueryIn in = new RechargeWaterQueryIn();
            in.setUserId(user.getId()+"");
            in.setBranchNo(GlobalConstant.BRANCH_NO);
            in.setFundAccount(user.getFundAccount());
            in.setUserNameText(user.getName());
            in.setPassword(user.getPayPwd());
            in.setCurrentPage(page);
            in.setPageSize(size);
            if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
                Person person = personService.getObjectById(user.getId());
                if(null == person){
                    model.addAttribute("code", -3013);
                    return "/common/success";
                }
                in.setCertType("0");
                in.setCertId(person.getIdNo());
            } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
                Organization organization = organizationService.getObjectById(user.getId());
                if(null == organization){
                    model.addAttribute("code", -3014);
                    return "/common/success";
                }
                in.setCertType(Constant.IDKIND);
                in.setCertId(organization.getUseCertId());
            }

            List<RechargeWaterQueryOut> outs = consignmentService.getRechargeWaterQuery(in);
            log.info("outs : " + outs);

            if(CollectionUtils.isNotEmpty(outs)){
                RechargeWaterQueryOut out = outs.get(0);
                model.addAttribute("respCode", out.getRespCode());
                model.addAttribute("respDesc", out.getRespDesc());
                model.addAttribute("totalPage", out.getTotalPage());
            }

            model.addAttribute("code", 0);
            model.addAttribute("outs", outs);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" get fund recharge list error ");
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/fundHistory/json/fundRechargeWaterJson";
    }


    //余额账户线上提现记录
    @RequestMapping(value = "/a/u/user/withdraw/list", method = RequestMethod.GET)
    public String fundWithdrawList(HttpServletRequest request, ModelMap model, HttpServletResponse response, Integer page, Integer size) throws Exception {

        log.info("get user withdraw list ");

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        try {
            Long uid = cookieUtil.getID(request);
            log.info("get user detail : " + uid);
            User user = userService.getObjectById(uid);

            WithdrawWaterQueryIn in = new WithdrawWaterQueryIn();
            in.setUserId(user.getId()+"");
            in.setBranchNo(GlobalConstant.BRANCH_NO);
            in.setFundAccount(user.getFundAccount());
            in.setCurrentPage(page);
            in.setPageSize(size);
            in.setUserNameText(user.getName());
            in.setPassword(user.getPayPwd());
            if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
                Person person = personService.getObjectById(user.getId());
                if(null == person){
                    model.addAttribute("code", -3013);
                    return "/common/success";
                }
                in.setCertType("0");
                in.setCertId(person.getIdNo());
            } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
                Organization organization = organizationService.getObjectById(user.getId());
                if(null == organization){
                    model.addAttribute("code", -3014);
                    return "/common/success";
                }
                in.setCertType(Constant.IDKIND);
                in.setCertId(organization.getUseCertId());
            }

            List<WithdrawWaterQueryOut> outs = consignmentService.getWithdrawWaterQuery(in);
            log.info("withdraw out : " + outs);

            if(CollectionUtils.isNotEmpty(outs)){
                WithdrawWaterQueryOut out = outs.get(0);
                model.addAttribute("respCode", out.getRespCode());
                model.addAttribute("respDesc", out.getRespDesc());
                model.addAttribute("totalPage", out.getTotalPage());
            }

            model.addAttribute("code", 0);
            model.addAttribute("outs", outs);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" get fund withdraw list error ");
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/fundHistory/json/fundWithdrawJson";
    }


    //余额账户线下充值记录
    @RequestMapping(value = "/a/u/user/recharge/offline/list", method = RequestMethod.GET)
    public String fundRechargeOfflineList(HttpServletRequest request, ModelMap model, HttpServletResponse response, Integer page, Integer size) throws Exception {

        log.info("get user recharge offline list ");

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        try {
            Long uid = cookieUtil.getID(request);
            log.info("get user detail : " + uid);
            User user = userService.getObjectById(uid);

            OfflineRechargeQueryIn offlineRechargeQueryIn = new OfflineRechargeQueryIn();
            offlineRechargeQueryIn.setUserId(user.getId()+"");
            offlineRechargeQueryIn.setBranchNo(GlobalConstant.BRANCH_NO);
            offlineRechargeQueryIn.setFundAccount(user.getFundAccount());
            offlineRechargeQueryIn.setUserNameText(user.getName());
            offlineRechargeQueryIn.setBusinessType("00");
            offlineRechargeQueryIn.setCurrentPage(page);
            offlineRechargeQueryIn.setPageSize(size);
            offlineRechargeQueryIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());

            List<OfflineRecharge> offlineRecharges = consignmentService.getRechargeOfflineRecord(offlineRechargeQueryIn);
            log.info("offline recharge out : " + offlineRecharges);
            if(CollectionUtils.isNotEmpty(offlineRecharges)){
                OfflineRecharge out = offlineRecharges.get(0);
                model.addAttribute("respCode", out.getRespCode());
                model.addAttribute("respDesc", out.getRespDesc());
                model.addAttribute("totalPage", out.getTotalPage());
            }

            model.addAttribute("code", 0);
            model.addAttribute("outs", offlineRecharges);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" get fund withdraw list error ");
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/fundHistory/json/offlineRechargeJson";
    }


    //余额账户交易记录
    @RequestMapping(value = "/a/u/user/query/record/list", method = RequestMethod.GET)
        public String queryRecord(HttpServletRequest request, ModelMap model, HttpServletResponse response, Integer page, Integer size) throws Exception {

        log.info("get user query record list ");

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        try {
            Long uid = cookieUtil.getID(request);
            log.info("get user detail : " + uid);
            User user = userService.getObjectById(uid);

            // 查询理财交易记录接口

            TransactionRecordQueryIn trqi = new TransactionRecordQueryIn();
            trqi.setFunctionId(FunctionConstants.queryRecord);
            trqi.setUserId(user.getId() + "");
            trqi.setBranchNo(GlobalConstant.BRANCH_NO);
            trqi.setFundAccount(user.getFundAccount());
            trqi.setPageNo(page);
            trqi.setRequestNum(size);
            trqi.setmEntrustStatus("!");
            trqi.setmStockType("y");
            trqi.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
            trqi.setBeginDate(20130101);
            trqi.setEndDate(getDate(0));

            log.info("trqi : " + trqi);
            List<TransactionRecordQueryOut> recordQueryOuts = consignmentService.queryRecord(trqi);
            log.info("recordQueryOuts : " + recordQueryOuts);



            TransactionRecordCountIn countIn = new TransactionRecordCountIn();
            countIn.setFunctionId(FunctionConstants.queryRecord);
            countIn.setUserId(user.getId() + "");
            countIn.setBranchNo(GlobalConstant.BRANCH_NO);
            countIn.setFundAccount(user.getFundAccount());
            countIn.setmEntrustStatus("!");
            countIn.setmStockType("y");
            countIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
            countIn.setBeginDate(20130101);
            countIn.setEndDate(getDate(0));

            log.info("countIn : " + countIn);
            TransactionRecordCountOut countOut = consignmentService.getRecordCount(countIn);
            log.info("countOut : " + countOut);

            Integer totalSize = countOut.getSumRowcount();
            Integer totalPage = (((totalSize - 1)) / (size)) + 1;

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("recordQueryOuts", recordQueryOuts);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" get fund flow list error ");
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/fundHistory/json/queryRecordJson";
    }


    //余额账户整体流水记录
    @RequestMapping(value = "/a/u/user/fund/list", method = RequestMethod.GET)
    public String fundFlowList(HttpServletRequest request, ModelMap model, HttpServletResponse response, Integer page, Integer size) throws Exception {

        log.info("get user fund flow list ");

        if (null == page) {
            page = 1;
        }
        if (null == size) {
            size = 10;
        }
        int firstNmuber = (page - 1) * size;
        Boolean next = false;

        try {
            Long uid = cookieUtil.getID(request);
            log.info("get user detail : " + uid);
            User user = userService.getObjectById(uid);

            //支付记录总数
            CapitalFlowIn capitalFlowIn = new CapitalFlowIn();
            capitalFlowIn.setUserId(user.getId()+"");
            capitalFlowIn.setBranchNo(GlobalConstant.BRANCH_NO);
            capitalFlowIn.setFundAccount(user.getFundAccount());
            capitalFlowIn.setUserNameText(user.getName());
            capitalFlowIn.setCurrentPage(page);
            capitalFlowIn.setPageSize(size);
            if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
                Person person = personService.getObjectById(user.getId());
                if(null == person){
                    model.addAttribute("code", -3013);
                    return "/common/success";
                }
                capitalFlowIn.setCertType("0");
                capitalFlowIn.setCertId(person.getIdNo());
            } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
                Organization organization = organizationService.getObjectById(user.getId());
                if(null == organization){
                    model.addAttribute("code", -3014);
                    return "/common/success";
                }
                capitalFlowIn.setCertType(Constant.IDKIND);
                capitalFlowIn.setCertId(organization.getUseCertId());
            }

            log.info("capitalFlowIn : " + capitalFlowIn);
            List<CapitalFlowOut> capitalFlowOuts = consignmentService.getCapitalFlows(capitalFlowIn);
            log.info("fund flow : " + capitalFlowOuts);
            if(CollectionUtils.isNotEmpty(capitalFlowOuts)){
                CapitalFlowOut out = capitalFlowOuts.get(0);
                model.addAttribute("respCode", out.getRespCode());
                model.addAttribute("respDesc", out.getRespDesc());
                model.addAttribute("totalPage", out.getTotalPage());
            }

            model.addAttribute("code", 0);
            model.addAttribute("outs", capitalFlowOuts);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" get fund flow list error ");
            model.addAttribute("code", -1);
        }

        return "/wealth-finance-service/fundHistory/json/fundListJson";
    }

    public static Integer getDate(int day) {
        Date date = new Date(System.currentTimeMillis() + day * DebtConstant.DAILY_TIME);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String updateTime = dateFormat.format(date);
        Integer result = Integer.valueOf(updateTime);
        return result;
    }
}

