package com.ptteng.wealth.finance.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.admin.util.ConstantParams;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.LoanApply;
import com.ptteng.wealth.finance.model.LoanProduct;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.user.model.User;
import com.sun.org.apache.xpath.internal.operations.Bool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by arthur on 16/8/26.
 */
@Controller
public class CreditController extends BaseController {


    private Log creditLog = LogFactory.getLog("credit_pay");

    private Integer getVerifyCode(Long uid, Long loanProductId, Long orderId, String paypwd) throws Exception {
        Integer result = 0;
        if (null == loanProductId || null == paypwd || null == orderId || null == uid) {
            creditLog.info("params is null");
            return -1000;
        }
        //冻结用户不能支付订单
        User user = userService.getObjectById(uid);
        if (User.FREEZE_YES.equals(user.getFreezeStatus())) {
            creditLog.info("USER IS FREEZEN");
            return -3021;
        }
        //验证订单是否已经处于完结状态
        Order order = orderService.getObjectById(orderId);
        if (Order.STATUS_COMPLETE.equals(order.getStatus())) {
            creditLog.info(" Order  is complete ");
            return -3009;
        }
        //验证产品类型是否符合
        LoanProduct loanProduct = loanProductService.getObjectById(loanProductId);

        Boolean debt = Order.Pay_Type_Debt.equals(order.getPayType()) && LoanProduct.SALE_ON_CREDIT_NOT.equals(loanProduct.getPayManner());
        Boolean loan = Order.Pay_Type_Loan.equals(order.getPayType()) && LoanProduct.SALE_ON_CREDIT.equals(loanProduct.getPayManner());
        if(!debt && !loan){
            creditLog.info("Order pay type not conform to loanProduct pay manner");
            return -3033;
        }
        //验证订单是否已经提交过
        if (order.getProductStatus().equals(Order.product_status_choice)) {
            creditLog.info(" Order has been checked");
            return -3023;
        }
        //验证登陆密码
        String pass = PasswordUtils.encode(paypwd);
        String passwords = user.getPwd();
        creditLog.info(" inputpass: " + pass + "  dbpasswords: " + passwords);
        boolean verify = passwords.trim().equals(pass.trim());
        creditLog.info(" PASSWORD verify: " + verify);
        if (!verify) {
            creditLog.info(uid + " wrong password " + paypwd);
            return -2004;
        }
        return result;
    }

    @RequestMapping(value = "/a/u/creditpay/{orderId}", method = RequestMethod.POST)
    public String b2bPay(HttpServletRequest request, ModelMap model,
                         @PathVariable Long orderId, String paypwd, Long loanProductId) throws Exception {
        String jumpUrl = "";
        Integer code = 0;
        try {
            creditLog.info("=======================================================================");
            creditLog.info("PARAM orderId = " + orderId + " paypassword = " + paypwd + " loanProductId = " + loanProductId);
            Long uid = getUserId(request);
            creditLog.info("PARAM uid = " + uid);
            User user = userService.getObjectById(uid);
            Integer result = getVerifyCode(uid, loanProductId, orderId, paypwd);
            creditLog.info("Step 1: verify result: " + result);
            if (result.equals(0)) {
                Order order = orderService.getObjectById(orderId);

                Boolean ifLineEnough = creditLineCheck(order.getPriceTot(), uid);
                if (!ifLineEnough) {
                    creditLog.info("user loan line not enough");
                    jumpUrl = "https://" + environment.getFsp() + "/external/externalPayFail?code=-3020&message=可用信用额度不足&url=" + order.getReturnUrl();
                    creditLog.info("JUMP URL : " + jumpUrl);
                    model.addAttribute("code", code);
                    model.addAttribute("jumpurl", jumpUrl);
                    return "/common/loan";
                }
                //判断是否是赊销
                LoanProduct loanProduct = loanProductService.getObjectById(loanProductId);
                if (loanProduct.getPayManner().equals(LoanProduct.SALE_ON_CREDIT)) {
                    //赊销的处理流程
                    creditLog.info("Step 2: She Xiao ..... ");
                    loanApplyService.addLoanApply(order, loanProductId, user);

                    jumpUrl = "https://" + environment.getFsp() + "/account/loan";
                } else {
                    //借贷的处理流程
                    creditLog.info("Step 2: Jie Dai .....");
                    debtApplyService.addDebtApply(order, loanProductId, user);

                    jumpUrl = "https://" + environment.getFsp() + "/account/loan";
                }

                //改变订单产品选择状态
                order.setProductStatus(Order.product_status_choice);
                orderService.update(order);
//                loanApplyService.addLoanApply(order, loanProductId, user);
//                jumpUrl = "https://" + environment.getFsp() + "/account/onCredit";
            } else {
                Order order = orderService.getObjectById(orderId);
                jumpUrl = "https://" + environment.getFsp() + "/external/externalPayFail?code=" + result + "&url=" + order.getReturnUrl();
            }
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            creditLog.error(t.getMessage());
            creditLog.error("oms pay error");
            creditLog.info("EXCEPTION END ========== ");
            code = -1;
            model.addAttribute("code", -1);
            jumpUrl = "https://" + environment.getFsp() + "/external/externalPayFail?code=-1000";
        }
        creditLog.info("JUMP URL : " + jumpUrl);
        model.addAttribute("code", code);
        model.addAttribute("jumpurl", jumpUrl);
        return "/common/loan";
    }

    //判断用户信用额度是否足够
    private Boolean creditLineCheck(BigDecimal price, Long uid) throws ServiceException, ServiceDaoException {
        creditLog.info("check user : " + uid + " credit line about price : " + price);
        Boolean result = false;

        BigDecimal totalLoanMoney = new BigDecimal("0");
        List<Long> idLs = loanApplyService.getLoanApplyIdsByUid(uid, 0, Integer.MAX_VALUE);
        List<LoanApply> loanApplies = loanApplyService.getObjectsByIds(idLs);
        for (LoanApply loanApply : loanApplies) {
            if (loanApply.getStatus().equals(LoanApply.STATUS_CLEAR) || loanApply.getStatus().equals(LoanApply.STATUS_REFUSE)
                    || loanApply.getStatus().equals(LoanApply.STATUS_KAILIN_REFUSE) || loanApply.getStatus().equals(LoanApply.STATUS_CANCEL)) {
                continue;
            }
            totalLoanMoney = totalLoanMoney.add(loanApply.getDebtCount());
        }

        Fund fund = fundService.getObjectById(uid);
        creditLog.info("total loan money : " + totalLoanMoney + " , and total debt money : " + fund.getLoanNowTot() + " , and credit line : " + fund.getCreditLine());

        BigDecimal creditLineLeft = fund.getCreditLine().subtract(fund.getLoanNowTot()).subtract(totalLoanMoney);
        Integer enough = creditLineLeft.compareTo(price);
        creditLog.info("user loan line : " + creditLineLeft + " , and totalFee : " + price);

        if (enough == 1) {
            creditLog.info("user loan line " + creditLineLeft + " bigger than priceFee" + price);
            result = true;
            return result;
        }

        creditLog.info("loan line check result : " + result);
        return result;
    }
}
