package com.ptteng.wealth.finance.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.UserService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.finance.model.Address;
import com.ptteng.wealth.finance.service.AddressService;

import static com.ptteng.wealth.finance.model.Address.TYPE_DEFAULT;
import static com.ptteng.wealth.finance.model.Address.TYPE_NORMAL;

/**
 * Address  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class AddressController {
	private static final Log log = LogFactory.getLog(AddressController.class);

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private UserService userService;

	@Autowired
	private AddressService addressService;


	/**
	 * @param
	 * @return
	 * @throws Exception
	 */
	//个人添加地址
	@RequestMapping(value = "/a/u/address", method = RequestMethod.POST)
	public String addBankCard(@RequestBody Address address, ModelMap model, HttpServletRequest request, HttpServletResponse response) throws Exception {

		Long uid = cookieUtil.getID(request);
		log.info("person " + uid + " add address ");
		User user = userService.getObjectById(uid);

		if (null == uid) {
			model.addAttribute("code", -2000);
			log.info("user not exist");
			return "/common/success";
		}

		try {
			if(DataUtils.isNullOrEmpty(address.getType()) ||  DataUtils.isNullOrEmpty(address.getArea()) || DataUtils.isNullOrEmpty(address.getCity())
					|| DataUtils.isNullOrEmpty(address.getDetail()) || DataUtils.isNullOrEmpty(address.getProvice()) || DataUtils.isNullOrEmpty(address.getReciverMobile())
					|| DataUtils.isNullOrEmpty(address.getReciverName()) || DataUtils.isNullOrEmpty(address.getReciverPhone()) || DataUtils.isNullOrEmpty(address.getStation())
					|| DataUtils.isNullOrEmpty(address.getZipCode())){
				model.addAttribute("code", -1000);
				log.info("params is null");
				return "/common/success";
			}

			List<Long> addressListIds = addressService.getAddressIdsByUid(uid, 0, Integer.MAX_VALUE);
			address.setId(null);
			address.setUid(uid);

			if (CollectionUtils.isEmpty(addressListIds)) {
				address.setType(TYPE_DEFAULT);
			} else {
				if (1 == address.getType()) {
					List<Long> ids = addressService.getAddressIdsByUidAndType(uid, TYPE_DEFAULT, 0, Integer.MAX_VALUE);
					if (CollectionUtils.isEmpty(ids)) {
						address.setType(TYPE_DEFAULT);
					} else {
						Address defaultaddress = addressService.getObjectById(ids.get(0));
						defaultaddress.setType(0);
						addressService.update(defaultaddress);
					}
				}
			}
			addressService.insert(address);

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("person " + uid + " add card error");
			// for test
			model.addAttribute("code", -100000);
		}
		return "/common/success";
	}


	/**
	 * @param
	 * @return
	 * @throws Exception
	 */
	//设置默认地址
	@RequestMapping(value = "/a/u/default/address/{id}", method = RequestMethod.PUT)
	public String defaultaddress(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
								 Integer status) throws Exception {

		Long uid = cookieUtil.getID(request);
		User user = userService.getObjectById(uid);
		log.info("set default address id : " + id + " status " + status);

		if (null == uid) {
			model.addAttribute("code", -2000);
			log.info("user not exist");
			return "/common/success";
		}

		try {
			Address address = addressService.getObjectById(id);

			if(!(uid.equals(address.getUid()))){
				model.addAttribute("code", -3000);
				log.info("is not your address");
				return "/common/success";
			}

			List<Long> addressListIds = addressService.getAddressIdsByUid(uid, 0, Integer.MAX_VALUE);
			if (TYPE_DEFAULT == address.getType()) {
				if (TYPE_DEFAULT == status) {
					model.addAttribute("code", 0);
					log.info("address is already default");
					return "/common/success";
				} else {
					address.setType(TYPE_NORMAL);
					addressService.update(address);
					model.addAttribute("code, 0");
					return "/common/success";
				}
			} else {
				if (TYPE_DEFAULT == status) {
					List<Long> ids = addressService.getAddressIdsByUidAndType(uid, TYPE_DEFAULT, 0, Integer.MAX_VALUE);
					log.info("user old default address is : " + ids.size());
					if (CollectionUtils.isEmpty(ids)) {
						log.info("no old default address");
						address.setType(TYPE_DEFAULT);
						addressService.update(address);
					} else {
						log.info("change default address");
						Address defaultaddress = addressService.getObjectById(ids.get(0));
						defaultaddress.setType(0);
						addressService.update(defaultaddress);
						address.setType(TYPE_DEFAULT);
						addressService.update(address);
					}
				} else {
					model.addAttribute("code", 0);
					log.info("address is already normal");
					return "/common/success";
				}
			}

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add address error");
			// for test
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}


	/**
	 * @param
	 * @return
	 * @throws Exception
	 */
	//删除地址记录
	@RequestMapping(value = "/a/u/address/{id}", method = RequestMethod.DELETE)
	public String deleteaddress(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		log.info("delete address : " + id);
		Long uid = cookieUtil.getID(request);
		User user = userService.getObjectById(uid);

		if (null == uid) {
			model.addAttribute("code", -2000);
			log.info("user not exist");
			return "/common/success";
		}

		try {
			Address address = addressService.getObjectById(id);
			Long addressUid = address.getUid();
			if(!(uid.equals(addressUid))){
				model.addAttribute("code", -3000);
				log.info("is not your address");
				return "/common/success";
			}

			addressService.delete(id);
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete address : " + id);
			// for test
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}


	//修改地址记录
	@RequestMapping(value = "/a/u/address/{id}", method = RequestMethod.PUT)
	public String getaddressJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
								 @PathVariable Long id, @RequestBody Address addressNew) throws Exception {

		log.info("update address : " + id);
		Long uid = cookieUtil.getID(request);
		User user = userService.getObjectById(uid);

		if (null == uid) {
			model.addAttribute("code", -2000);
			log.info("user not exist");
			return "/common/success";
		}

		try {

			Address addressOld = addressService.getObjectById(id);
			if(null==addressOld){
				model.addAttribute("code", -4002);
				log.info("address not exist");
				return "/common/success";
			}
			Long addressUid = addressOld.getUid();
			if(!(uid.equals(addressUid))){
				model.addAttribute("code", -3000);
				log.info("is not your address");
				return "/common/success";
			}

			addressNew.setUid(uid);
			addressNew.setId(id);
			addressNew.setType(addressOld.getType());
			addressNew.setCreateAt(addressOld.getCreateAt());
			addressNew.setCreateBy(addressOld.getCreateBy());
			addressService.update(addressNew);

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get address error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	//查询用户地址记录列表
	@RequestMapping(value = "/a/u/address/list", method = RequestMethod.GET)
	public String getaddressList(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

		List<Address> addressList = new ArrayList<>();
		Long uid = cookieUtil.getID(request);
		User user = userService.getObjectById(uid);
		log.info("get address list : " + uid);

		if (null == uid) {
			model.addAttribute("code", -2000);
			log.info("user not exist");
			return "/common/success";
		}

		try {

			List<Long> addressIds = addressService.getAddressIdsByUid(uid, 0 ,Integer.MAX_VALUE);

			System.out.println("addressIds : " + addressIds);
			if (CollectionUtils.isNotEmpty(addressIds)) {
				addressList = addressService.getObjectsByIds(addressIds);
			}

			List<Long> defaultId = addressService.getAddressIdsByUidAndType(uid, TYPE_DEFAULT, 0, Integer.MAX_VALUE);
			if (CollectionUtils.isNotEmpty(defaultId)) {
				model.addAttribute("default", defaultId.get(0));
			}

			model.addAttribute("code", 0);
			model.addAttribute("addressList", addressList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update address error,id is  " + uid);
			model.addAttribute("code", -6003);

		}

		return "/wealth-finance-service/address/json/addressListJson";
	}
	
	
}

