package com.ptteng.wealth.user.controller;

import java.net.URLEncoder;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.StringUtil;
import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.Environment;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.user.model.*;
import com.ptteng.wealth.user.model.work.CardModel;
import com.ptteng.wealth.user.service.OrganizationService;
import com.ptteng.wealth.user.service.UserOpenidRelationService;
import com.ptteng.wealth.user.service.UserService;
import com.ptteng.wealth.user.util.Constant;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.user.service.OrgApplyService;

/**
 * OrgApply  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class OrgApplyController extends BaseController {

    private static final Log log = LogFactory.getLog(OrgApplyController.class);
    private static final Log orgLog = LogFactory.getLog("orgApply");
    private static final Log orgActiveLog = LogFactory.getLog("orgActive");

    @Autowired
    private OrgApplyService orgApplyService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private ConsignmentService consignmentService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private UserOpenidRelationService userOpenidRelationService;

    @Autowired
    private Environment environment;


    /**
     *    ===================================   CRM  过来的用户激活流程   ===============================================
     */

    /**
     * 19、根据手机号，获取机构用户的申请信息
     */
    @RequestMapping(value = "/a/org/apply/{mobile}", method = RequestMethod.GET)
    public String getPersonApplyJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable String mobile) throws Exception {
        try {
            log.info(" mobile = " + mobile);
            Long orgApplyId = orgApplyService.getOrgApplyIdByMobile(mobile);
            log.info(" orgApplyId = " + orgApplyId);
            if (null == orgApplyId) {
                model.addAttribute("code", -12000);
                return "/data/json";
            }
            OrgApply orgApply = orgApplyService.getObjectById(orgApplyId);
            log.info("get personApply data is " + orgApply);
            model.addAttribute("code", 0);
            model.addAttribute("orgApply", orgApply);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get personApply error  ");
            model.addAttribute("code", -1);
        }
        return "/wealth-user-service/orgApply/json/orgApplyDetailJson";
    }

    //20、机构用户:   激活的流程
    @RequestMapping(value = "/a/organzation/active", method = RequestMethod.POST)
    public String active(ModelMap model, @RequestBody OrgApply orgApply) throws Exception {




        orgActiveLog.info("============================================================");
        orgActiveLog.info("orgApply ------------------" + orgApply);
        try {
            if (null == orgApply || null == orgApply.getUid()) {
                orgActiveLog.error(" orgApply is null  or user id " + orgApply);
                model.addAttribute("code", -2021);
                return "/data/json";
            }
            //第一步： 更新申请信息
            Long oldOrgApplyId = orgApplyService.getOrgApplyIdByMobile(orgApply.getMobile());
            orgActiveLog.info(" old apply id : " + oldOrgApplyId);
            orgApply.setStatus(PersonApply.STATUS_1);
            orgApply.setUpdateAt(System.currentTimeMillis());
            if (null != oldOrgApplyId) {
                orgApply.setCreateAt(System.currentTimeMillis());
                orgApply.setId(oldOrgApplyId);
                orgApplyService.update(orgApply);
            } else {
                orgApply.setCreateAt(System.currentTimeMillis());
                Long result = orgApplyService.insert(orgApply);
                orgApply.setId(result);
                orgActiveLog.info(" result = " + result);
            }
            orgActiveLog.info("============================================================");
            model.addAttribute("result", orgApply.getId());
            model.addAttribute("code", 0);
        } catch (Exception e) {
            orgActiveLog.error("get  error", e);
            model.addAttribute("code", -1);
        }
        return "/common/success1";
    }

    /**
     *    ===================================   机构用户直接注册来的流程    ===============================================
     */

    //21、机构注册开户绑卡
    @RequestMapping(value = "/a/organzation/apply", method = RequestMethod.POST)
    public String orgApply( ModelMap model,Integer times, @RequestBody OrgApply orgApply) throws Exception {
        orgLog.info("===================================================================================================");
        orgLog.info("orgApply: " + orgApply);
        long code = 0l;
        try {
            if(null == orgApply || StringUtils.isBlank(orgApply.getMobile())){
                if(null == orgApply){
                    code = -2001;
                }
                else{
                    code = -2021;
                }
                orgLog.error("ERROR: orgApply is null or mobile is null ");
                orgLog.info("===================================================================================================");
            }
            else if(null== orgApply.getPassword() || orgApply.getPassword().equals(orgApply.getPayPwd())){
                code = -2018;
            }
            else{
                orgLog.info("SUBMIT MOBILE : " + orgApply.getMobile());
                Long oldOrgApplyId = orgApplyService.getOrgApplyIdByMobile(orgApply.getMobile());
                if(null != oldOrgApplyId){
                    OrgApply oldOrgApply = orgApplyService.getObjectById(oldOrgApplyId);
                    if (null != oldOrgApply) {
                        updateOrgApplyInfo(orgApply, oldOrgApplyId, oldOrgApply,orgLog);
                    }
                }
                else{
                    Long userId =  userService.getLatestUserId();
                    orgApply.setStatus(OrgApply.STATUS_1);
                    orgApply.setUid(userId);
                    Long result = orgApplyService.insert(orgApply);
                    orgLog.info(" org apply id " + result);
                    //第二步： 创建用户及登录表
                    createUserInfo(orgApply, userId, orgApply.getName(), orgLog,"",false);
                }
            }
        } catch (Exception e) {
            orgLog.error("get captchaVerify error", e);
            code =-1;
        }

        model.addAttribute("code", code);
        return "/common/success1";
    }


    //22、机构:补录信息，上传三张图片
    @RequestMapping(value = "/a/organzation/add", method = RequestMethod.POST)
    public String updateOrgApply(HttpServletRequest request, HttpServletResponse response, ModelMap model, @RequestBody OrgApply orgApply) throws Exception {
        orgLog.info("orgApply ------------------" + orgApply);
        try {
            if (StringUtil.isEmpty(orgApply.getMobile())
                    || StringUtil.isEmpty(orgApply.getLicenceImg())
                    || StringUtil.isEmpty(orgApply.getPermitImg())
                    || StringUtil.isEmpty(orgApply.getPermitImg())) {
                model.addAttribute("code", -1000);
                return "/data/json";
            }
            Long oldOrgApplyId = orgApplyService.getOrgApplyIdByMobile(orgApply.getMobile());
            log.info(" ");
            if (null == oldOrgApplyId) {
                model.addAttribute("code", -2021);
                return "/data/json";
            }
            OrgApply oldOrgApply = orgApplyService.getObjectById(oldOrgApplyId);
            oldOrgApply.setTaxImg(orgApply.getTaxImg());
            oldOrgApply.setPermitImg(orgApply.getPermitImg());
            oldOrgApply.setLicenceImg(orgApply.getLicenceImg());
            oldOrgApply.setStatus(PersonApply.STATUS_1);
            Boolean result = orgApplyService.update(oldOrgApply);
            log.info(" result = " + result);

            orgLog.info("================================result :" + result);
            model.addAttribute("result", result);
            model.addAttribute("code", 0);
        } catch (Exception e) {
            log.error("get captchaVerify error", e);
            model.addAttribute("code", -1);
        }
        return "/common/success1";
    }


}

