package com.ptteng.wealth.common.controller;

import java.io.File;
import java.util.UUID;
import com.ptteng.wealth.util.FastdfsUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import com.qding.common.util.FileUtil;

@Controller
public class ImageController {

    private static final Log log = LogFactory.getLog(ImageController.class);


    // 图片上传
    @RequestMapping(value = "/a/img/{module}", method = RequestMethod.POST)
    public String uploadFile(ModelMap model, @RequestParam MultipartFile file, @PathVariable String module)
            throws Exception {
        int code = 0;
        log.info(file.getOriginalFilename());
        try {
            String extend = FileUtil.getFileExtension(file.getOriginalFilename());
            String fileName = UUID.randomUUID().toString() + "." + extend;
            log.info("new name is " + fileName);
//
            File tempPic = new File(fileName);
            file.transferTo(tempPic);
            log.info(" UPLOAD FILE PATH : "+tempPic.getAbsolutePath());
            String url = FastdfsUtil.upload(tempPic.getAbsolutePath());
            log.info("URL : "+url);
            tempPic.delete();
            log.info("remove temp file " + fileName);
            model.addAttribute("url", url);
            model.addAttribute("code", 0);

            return "/common/img";
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

}
