package com.ptteng.wealth.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.gemantic.common.util.StringUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by asus on 2016/11/16.
 */
public class sqlUtil {

    private static final Log log = LogFactory.getLog("sql");

    public static String getDynamicSql(String orderNo, Long uid, String status, Integer type, Integer start, Integer limit) {
        Map<String, Object> debtParams = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            debtParams.put("uid", "'" + uid + "'");
        }
        if (DataUtils.isNotNullOrEmpty(orderNo)) {
            debtParams.put("order_no", "'" + orderNo + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            debtParams.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            debtParams.put("status", status);
        }
        debtParams.put("@query", " * ");
        debtParams.put("@table", "  debtapply ");
        String debtSql = SQLUtil.convert2Sql(debtParams, 0, Integer.MAX_VALUE);


        Map<String, Object> loanParams = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            loanParams.put("uid", "'" + uid + "'");
        }
        if (DataUtils.isNotNullOrEmpty(orderNo)) {
            loanParams.put("order_no", "'" + orderNo + "'");
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            loanParams.put("type", type);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            loanParams.put("status", status);
        }
        loanParams.put("@query", " * ");
        loanParams.put("@table", "  loan_apply ");
        String loanSql = SQLUtil.convert2Sql(loanParams, 0, Integer.MAX_VALUE);

        String limitSql = " limit " + start + " , " + limit;

        String sql = "SELECT * FROM ((" + debtSql + ") UNION ALL (" + loanSql + ")) as total order by create_at desc" + limitSql;

        return sql;

    }

    public static String getNotDynamicSql(String orderNo, Long uid, String status, Integer noType, Integer start, Integer limit) {
        Map<String, Object> debtParams = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            debtParams.put("uid", "'" + uid + "'");
        }
        if (DataUtils.isNotNullOrEmpty(orderNo)) {
            debtParams.put("order_no", "'" + orderNo + "'");
        }
        if (DataUtils.isNotNullOrEmpty(noType)) {
            debtParams.put("type & !=", noType);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            debtParams.put("status", status);
        }
        debtParams.put("@query", " * ");
        debtParams.put("@table", "  debtapply ");
        String debtSql = SQLUtil.convert2Sql(debtParams, 0, Integer.MAX_VALUE);


        Map<String, Object> loanParams = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            loanParams.put("uid", "'" + uid + "'");
        }
        if (DataUtils.isNotNullOrEmpty(orderNo)) {
            loanParams.put("order_no", "'" + orderNo + "'");
        }
        if (DataUtils.isNotNullOrEmpty(noType)) {
            loanParams.put("type & !=", noType);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            loanParams.put("status", status);
        }
        loanParams.put("@query", " * ");
        loanParams.put("@table", "  loan_apply ");
        String loanSql = SQLUtil.convert2Sql(loanParams, 0, Integer.MAX_VALUE);

        String limitSql = " limit " + start + " , " + limit;

        String sql = "SELECT * FROM ((" + debtSql + ") UNION ALL (" + loanSql + ")) as total order by create_at desc" + limitSql;

        return sql;

    }

}
