package com.ptteng.wealth.user.controller;

import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.consign.model.in.RiskLevelModifyIn;
import com.ptteng.wealth.consign.model.out.RiskLevelModifyOut;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.UserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;

/**
 * Created by arthur on 16/6/8.
 */
@Controller
public class UserRiskController extends BaseController {
    private static final Log log = LogFactory.getLog(UserRiskController.class);

    @Autowired
    private UserService userService;

    @RequestMapping(value = "/a/userrisk/modify")
    public String queryBuyInfo(Integer riskLevel,HttpServletRequest request,HttpServletResponse response){
        HashMap<String, String> errorMap = new HashMap<String, String>();
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        try {
            User user = getUser(request);
            log.info(" user id = "+user.getId());
            user.setRisk(riskLevel);
            Boolean update = userService.update(user);
            log.info(" update = "+update);
            RiskLevelModifyIn riskLevelModifyIn = new RiskLevelModifyIn(user.getFundAccount(),user.getId()+"", riskLevel);
            RiskLevelModifyOut riskLevelModifyOut = consignmentService.modifyRiskLevel(riskLevelModifyIn);
            handleResult(true,200,response.getWriter(),response);
        } catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace(System.out);
        }
        return null;
    }

}
