/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl.account;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.account.AccountRecord;
import com.ptteng.wealth.finance.service.account.AccountRecordService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccountRecordServiceImpl
extends BaseDaoServiceImpl
implements AccountRecordService {
    private static final Log log = LogFactory.getLog(AccountRecordServiceImpl.class);

    public Long insert(AccountRecord accountRecord) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + accountRecord));
        if (accountRecord == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        accountRecord.setCreateAt(Long.valueOf(currentTimeMillis));
        accountRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)accountRecord);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + accountRecord));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<AccountRecord> insertList(List<AccountRecord> accountRecordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (accountRecordList == null ? "null" : Integer.valueOf(accountRecordList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(accountRecordList)) {
            return new ArrayList<AccountRecord>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (AccountRecord accountRecord : accountRecordList) {
            accountRecord.setCreateAt(Long.valueOf(currentTimeMillis));
            accountRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(accountRecordList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + accountRecordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(AccountRecord.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(AccountRecord accountRecord) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (accountRecord == null ? "null" : accountRecord.getId())));
        boolean result = false;
        if (accountRecord == null) {
            return true;
        }
        accountRecord.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)accountRecord);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + accountRecord));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + accountRecord));
        }
        return result;
    }

    public boolean updateList(List<AccountRecord> accountRecordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (accountRecordList == null ? "null" : Integer.valueOf(accountRecordList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(accountRecordList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (AccountRecord accountRecord : accountRecordList) {
            accountRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(accountRecordList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + accountRecordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + accountRecordList.size()));
        return result;
    }

    public AccountRecord getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        AccountRecord accountRecord = null;
        if (id == null) {
            return accountRecord;
        }
        try {
            accountRecord = (AccountRecord)this.dao.get(AccountRecord.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return accountRecord;
    }

    public List<AccountRecord> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List accountRecord = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<AccountRecord>();
        }
        try {
            accountRecord = this.dao.getList(AccountRecord.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (accountRecord == null ? "null" : Integer.valueOf(accountRecord.size()))));
        return accountRecord;
    }

    public List<Long> getAccountRecordIdsByUserIdOrderByUpdateAt(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by userId,start,limit  : " + userId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAccountRecordIdsByUserIdOrderByUpdateAt", new Object[]{userId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by userId,start,limit)  : " + userId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countAccountRecordIdsByUserIdOrderByUpdateAt(Long userId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by userId  : " + userId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getAccountRecordIdsByUserIdOrderByUpdateAt", new Object[]{userId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by userId)  : " + userId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getAccountRecordIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAccountRecordIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countAccountRecordIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getAccountRecordIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getAccountRecordIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

