/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.LoanApply;
import com.ptteng.wealth.finance.model.LoanProduct;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.service.FundService;
import com.ptteng.wealth.finance.service.LoanApplyService;
import com.ptteng.wealth.finance.service.LoanProductService;
import com.ptteng.wealth.finance.service.OrderService;
import com.ptteng.wealth.user.model.User;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="LoanApplyServiceImpl")
public class LoanApplyServiceImpl
extends BaseDaoServiceImpl
implements LoanApplyService {
    private static final Log log = LogFactory.getLog(LoanApplyServiceImpl.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private FundService fundService;
    @Autowired
    private LoanProductService loanProductService;

    public Long insert(LoanApply loanApply) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + loanApply));
        if (loanApply == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        loanApply.setCreateAt(Long.valueOf(currentTimeMillis));
        loanApply.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)loanApply);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + loanApply));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<LoanApply> insertList(List<LoanApply> loanApplyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (loanApplyList == null ? "null" : Integer.valueOf(loanApplyList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(loanApplyList)) {
            return new ArrayList<LoanApply>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (LoanApply loanApply : loanApplyList) {
            loanApply.setCreateAt(Long.valueOf(currentTimeMillis));
            loanApply.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(loanApplyList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + loanApplyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(LoanApply.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(LoanApply loanApply) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (loanApply == null ? "null" : loanApply.getId())));
        boolean result = false;
        if (loanApply == null) {
            return true;
        }
        loanApply.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)loanApply);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + loanApply));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + loanApply));
        }
        return result;
    }

    public boolean updateList(List<LoanApply> loanApplyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (loanApplyList == null ? "null" : Integer.valueOf(loanApplyList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(loanApplyList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (LoanApply loanApply : loanApplyList) {
            loanApply.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(loanApplyList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + loanApplyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + loanApplyList.size()));
        return result;
    }

    public LoanApply getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        LoanApply loanApply = null;
        if (id == null) {
            return loanApply;
        }
        try {
            loanApply = (LoanApply)this.dao.get(LoanApply.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return loanApply;
    }

    public List<LoanApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List loanApply = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<LoanApply>();
        }
        try {
            loanApply = this.dao.getList(LoanApply.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (loanApply == null ? "null" : Integer.valueOf(loanApply.size()))));
        return loanApply;
    }

    public Long getLoanApplyIdByOrderNoAndAdditional(String orderNo, String additional) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by orderNo  : " + orderNo + " additional : " + additional));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getLoanApplyIdByOrderNoAndAdditional", new Object[]{orderNo, additional});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by orderNo  : " + orderNo + " additional : " + additional));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getLoanApplyIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLoanApplyIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getLoanApplyIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLoanApplyIdsByStatus", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getLoanApplyIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLoanApplyIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getLoanApplyIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,type,start,limit  : " + uid + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLoanApplyIdsByUidAndType", new Object[]{uid, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,type,start,limit)  : " + uid + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getLoanApplyIdsByUidAndOrderType(Long uid, Integer orderType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,type,start,limit  : " + uid + " , " + orderType + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLoanApplyIdsByUidAndOrderType", new Object[]{uid, orderType}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,orderType,start,limit)  : " + uid + " , " + orderType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countLoanApplyIdsByUidAndType(Long uid, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,type  : " + uid + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getLoanApplyIdsByUidAndType", new Object[]{uid, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,type)  : " + uid + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countLoanApplyIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getLoanApplyIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countLoanApplyIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,status  : " + uid + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getLoanApplyIdsByUidAndStatus", new Object[]{uid, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,status)  : " + uid + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getLoanApplyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLoanApplyIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countLoanApplyIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getLoanApplyIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getLoanApplyIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Boolean addLoanApply(Order order, Long loanProductId, User user) throws ServiceException, ServiceDaoException {
        log.info((Object)("add loan apply oid : " + order.getId() + " loan product id : " + loanProductId + " user : " + user.getId()));
        LoanProduct loanProduct = this.loanProductService.getObjectById(loanProductId);
        Long id = this.getLoanApplyIdByOrderNoAndAdditional(order.getOrderNo(), order.getAdditional());
        if (null == id) {
            LoanApply loanApply = new LoanApply();
            Boolean result = false;
            loanApply.setUid(order.getUid());
            loanApply.setUserMobile(user.getMobile());
            loanApply.setUserName(user.getName());
            loanApply.setOrderID(order.getId());
            loanApply.setOrderNo(order.getOrderNo());
            loanApply.setTotal(order.getPriceTot());
            loanApply.setDebtCount(order.getPriceTot());
            loanApply.setRate(loanProduct.getRate());
            loanApply.setOverRate(loanProduct.getOverRate());
            loanApply.setStatus(LoanApply.STATUS_VERIFYING);
            loanApply.setType(LoanApply.TYPE_VERIFYING);
            loanApply.setVerifyAt(Long.valueOf(0L));
            loanApply.setRepayWay(LoanApply.REPAYWAY_1);
            loanApply.setSecondVerifyAt(Long.valueOf(0L));
            loanApply.setRepayLine(loanProduct.getRepayLine());
            loanApply.setOrderType(loanProduct.getPayManner());
            loanApply.setAdditional(order.getAdditional());
            id = this.insert(loanApply);
        }
        log.info((Object)("now insert loanApply success and loanApplyId is " + id));
        return true;
    }

    public Boolean addSmallLoanApply(Order order, User user, Boolean ifVerify) throws ServiceException, ServiceDaoException {
        log.info((Object)("add small loan apply order : " + order.getId() + " user : " + user.getId() + " if verify : " + ifVerify));
        Long id = this.getLoanApplyIdByOrderNoAndAdditional(order.getOrderNo(), order.getAdditional());
        if (null == id) {
            LoanApply loanApply = new LoanApply();
            Boolean result = false;
            if (ifVerify.booleanValue()) {
                loanApply.setStatus(LoanApply.STATUS_PASS);
                loanApply.setType(LoanApply.TYPE_REPAY);
                loanApply.setDebtAt(Long.valueOf(System.currentTimeMillis()));
            } else {
                loanApply.setStatus(LoanApply.STATUS_VERIFYING);
                loanApply.setType(LoanApply.TYPE_VERIFYING);
            }
            loanApply.setUid(order.getUid());
            loanApply.setUserMobile(user.getMobile());
            loanApply.setUserName(user.getName());
            loanApply.setOrderID(order.getId());
            loanApply.setOrderNo(order.getOrderNo());
            loanApply.setTotal(order.getPriceTot());
            loanApply.setDebtCount(order.getPriceTot());
            loanApply.setVerifyAt(Long.valueOf(System.currentTimeMillis()));
            loanApply.setRepayWay(LoanApply.REPAYWAY_1);
            loanApply.setSecondVerifyAt(Long.valueOf(System.currentTimeMillis()));
            loanApply.setOrderType(LoanApply.ORDER_TYPE_SMALL);
            loanApply.setRate(BigDecimal.ZERO);
            loanApply.setOverRate(BigDecimal.ZERO);
            loanApply.setRepayLine(Integer.valueOf(Integer.MAX_VALUE));
            loanApply.setAdditional(order.getAdditional());
            id = this.insert(loanApply);
        }
        log.info((Object)("now insert smallLoanApply success and loanApplyId is " + id));
        return true;
    }
}

