/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.Invoice;
import com.ptteng.wealth.finance.service.InvoiceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InvoiceServiceImpl
extends BaseDaoServiceImpl
implements InvoiceService {
    private static final Log log = LogFactory.getLog(InvoiceServiceImpl.class);

    public Long insert(Invoice invoice) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + invoice));
        if (invoice == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        invoice.setCreateAt(Long.valueOf(currentTimeMillis));
        invoice.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)invoice);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + invoice));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Invoice> insertList(List<Invoice> invoiceList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (invoiceList == null ? "null" : Integer.valueOf(invoiceList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(invoiceList)) {
            return new ArrayList<Invoice>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Invoice invoice : invoiceList) {
            invoice.setCreateAt(Long.valueOf(currentTimeMillis));
            invoice.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(invoiceList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + invoiceList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Invoice.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Invoice invoice) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (invoice == null ? "null" : invoice.getId())));
        boolean result = false;
        if (invoice == null) {
            return true;
        }
        invoice.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)invoice);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + invoice));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + invoice));
        }
        return result;
    }

    public boolean updateList(List<Invoice> invoiceList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (invoiceList == null ? "null" : Integer.valueOf(invoiceList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(invoiceList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Invoice invoice : invoiceList) {
            invoice.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(invoiceList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + invoiceList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + invoiceList.size()));
        return result;
    }

    public Invoice getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Invoice invoice = null;
        if (id == null) {
            return invoice;
        }
        try {
            invoice = (Invoice)this.dao.get(Invoice.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return invoice;
    }

    public List<Invoice> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List invoice = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Invoice>();
        }
        try {
            invoice = this.dao.getList(Invoice.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (invoice == null ? "null" : Integer.valueOf(invoice.size()))));
        return invoice;
    }

    public List<Long> getInvoiceIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,type,start,limit  : " + uid + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getInvoiceIdsByUidAndType", new Object[]{uid, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,type,start,limit)  : " + uid + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getInvoiceIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getInvoiceIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countInvoiceIdsByUidAndType(Long uid, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,type  : " + uid + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getInvoiceIdsByUidAndType", new Object[]{uid, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,type)  : " + uid + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countInvoiceIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getInvoiceIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getInvoiceIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getInvoiceIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countInvoiceIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getInvoiceIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getInvoiceIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

