package com.ptteng.wealth.finance.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.ProExt;
import com.ptteng.wealth.finance.service.ProExtService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ProExtServiceImpl extends BaseDaoServiceImpl implements ProExtService {


    private static final Log log = LogFactory.getLog(ProExtServiceImpl.class);


    @Override
    public Long insert(ProExt proExt) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + proExt);

        if (proExt == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        proExt.setCreateAt(currentTimeMillis);
        proExt.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(proExt);
        } catch (DaoException e) {
            log.error(" insert wrong : " + proExt);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<ProExt> insertList(List<ProExt> proExtList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (proExtList == null ? "null" : proExtList.size()));

        List<ProExt> resultList = null;

        if (CollectionUtils.isEmpty(proExtList)) {
            return new ArrayList<ProExt>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (ProExt proExt : proExtList) {
            proExt.setCreateAt(currentTimeMillis);
            proExt.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<ProExt>) dao.batchSave(proExtList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + proExtList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(ProExt.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(ProExt proExt) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (proExt == null ? "null" : proExt.getId()));

        boolean result = false;

        if (proExt == null) {
            return true;
        }

        proExt.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(proExt);
        } catch (DaoException e) {
            log.error(" update wrong : " + proExt);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + proExt);
        }
        return result;
    }


    @Override
    public boolean updateList(List<ProExt> proExtList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (proExtList == null ? "null" : proExtList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(proExtList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (ProExt proExt : proExtList) {
            proExt.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(proExtList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + proExtList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + proExtList.size());

        return result;
    }


    @Override
    public ProExt getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        ProExt proExt = null;

        if (id == null) {
            return proExt;
        }

        try {
            proExt = (ProExt) dao.get(ProExt.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return proExt;
    }


    @Override
    public List<ProExt> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<ProExt> proExt = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ProExt>();
        }

        try {
            proExt = (List<ProExt>) dao.getList(ProExt.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (proExt == null ? "null" : proExt.size()));

        return proExt;
    }


    @Override
    public List<Long> getProExtIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getProExtIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countProExtIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getProExtIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getProExtIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

