package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.Invoice;
import com.ptteng.wealth.finance.model.LoanProduct;
import com.ptteng.wealth.finance.service.LoanProductService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by arthur on 16/8/26.
 */
public class LoanProductServiceImpl extends BaseDaoServiceImpl implements LoanProductService {

    private Log log = LogFactory.getLog(LoanProductServiceImpl.class);

    @Override
    public Long insert(LoanProduct loanProduct) throws ServiceException, ServiceDaoException {

        log.info(" insert data : " + loanProduct);

        if (loanProduct == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        loanProduct.setCreateAt(currentTimeMillis);
        loanProduct.setUpdateAt(currentTimeMillis);
        loanProduct.setDal(1);

        Long result = null;
        try {
            result = (Long) dao.save(loanProduct);
        } catch (DaoException e) {
            log.error(" insert wrong : " + loanProduct);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        log.info(" insert data success : " + result);

        return result;
    }

    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        log.info(" delete data : " + id);
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = dao.delete(LoanProduct.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;
    }

    @Override
    public boolean update(LoanProduct loanProduct) throws ServiceException, ServiceDaoException {
        log.info(" update data : " + (loanProduct == null ? "null" : loanProduct.getId()));

        boolean result = false;

        if (loanProduct == null) {
            return true;
        }

        loanProduct.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(loanProduct);
        } catch (DaoException e) {
            log.error(" update wrong : " + loanProduct);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + loanProduct);
        }
        return result;
    }

    @Override
    public LoanProduct getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        LoanProduct loanProduct  = null;

        if (id == null) {
            return loanProduct;
        }

        try {
            loanProduct = (LoanProduct) dao.get(LoanProduct.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return loanProduct;
    }

    @Override
    public List<LoanProduct> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<LoanProduct> loanProducts = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<LoanProduct>();
        }

        try {
            loanProducts = (List<LoanProduct>) dao.getList(LoanProduct.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (loanProducts == null ? "null" : loanProducts.size()));

        return loanProducts;
    }

    @Override
    public List<Long> getLoanIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = dao.getIdList("getLoanProductAll", new Object[]{1}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<LoanProduct> getLoanProductByManner(Integer payManner) throws ServiceException, ServiceDaoException {
        List<Long> idList = null;
        List<LoanProduct> loanProducts = new ArrayList<LoanProduct>();
        try {
            idList = dao.getIdList("getLoanProductManner", new Object[]{payManner}, 0, Integer.MAX_VALUE, false);
            loanProducts = getObjectsByIds(idList);

        } catch (DaoException e) {
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return loanProducts;
    }


}
