package com.ptteng.wealth.finance.service.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.account.AccountService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.user.model.User;
import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.FundHistory;
import com.ptteng.wealth.finance.service.FundHistoryService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;


public class FundHistoryServiceImpl extends BaseDaoServiceImpl implements FundHistoryService {


    private static final Log log = LogFactory.getLog(FundHistoryServiceImpl.class);

    @Autowired
    public AccountService accountService;
    @Autowired
    public UserAccountRelationService userAccountRelationService;

    @Override
    public Long insert(FundHistory fundHistory) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + fundHistory);

        if (fundHistory == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        fundHistory.setCreateAt(currentTimeMillis);
        fundHistory.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(fundHistory);
        } catch (DaoException e) {
            log.error(" insert wrong : " + fundHistory);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<FundHistory> insertList(List<FundHistory> fundHistoryList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (fundHistoryList == null ? "null" : fundHistoryList.size()));

        List<FundHistory> resultList = null;

        if (CollectionUtils.isEmpty(fundHistoryList)) {
            return new ArrayList<FundHistory>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (FundHistory fundHistory : fundHistoryList) {
            fundHistory.setCreateAt(currentTimeMillis);
            fundHistory.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<FundHistory>) dao.batchSave(fundHistoryList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + fundHistoryList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(FundHistory.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(FundHistory fundHistory) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (fundHistory == null ? "null" : fundHistory.getId()));

        boolean result = false;

        if (fundHistory == null) {
            return true;
        }

        fundHistory.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(fundHistory);
        } catch (DaoException e) {
            log.error(" update wrong : " + fundHistory);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + fundHistory);
        }
        return result;
    }


    @Override
    public boolean updateList(List<FundHistory> fundHistoryList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (fundHistoryList == null ? "null" : fundHistoryList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(fundHistoryList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (FundHistory fundHistory : fundHistoryList) {
            fundHistory.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(fundHistoryList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + fundHistoryList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + fundHistoryList.size());

        return result;
    }


    @Override
    public FundHistory getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        FundHistory fundHistory = null;

        if (id == null) {
            return fundHistory;
        }

        try {
            fundHistory = (FundHistory) dao.get(FundHistory.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return fundHistory;
    }


    @Override
    public List<FundHistory> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<FundHistory> fundHistory = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<FundHistory>();
        }

        try {
            fundHistory = (List<FundHistory>) dao.getList(FundHistory.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (fundHistory == null ? "null" : fundHistory.size()));

        return fundHistory;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getFundHistoryIdsByUidAndStatusAndType(Long uid, Integer status, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,status,type,start,limit  : " + uid + " , " + status + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getFundHistoryIdsByUidAndStatusAndType", new Object[]{uid, status, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,status,type,start,limit)  : " + uid + " , " + status + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getFundHistoryIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,type,start,limit  : " + uid + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getFundHistoryIdsByUidAndType", new Object[]{uid, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,type,start,limit)  : " + uid + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countFundHistoryIdsByUidAndStatusAndType(Long uid, Integer status, Integer type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,status,type  : " + uid + " , " + status + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getFundHistoryIdsByUidAndStatusAndType", new Object[]{uid, status, type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,status,type)  : " + uid + " , " + status + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countFundHistoryIdsByUidAndType(Long uid, Integer type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,type  : " + uid + " , " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getFundHistoryIdsByUidAndType", new Object[]{uid, type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,type)  : " + uid + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getFundHistoryIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getFundHistoryIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countFundHistoryIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getFundHistoryIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getFundHistoryIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public Long insertTransaction(Order order, User user, Integer type, Integer detail, Long payAccount,
                                  BigDecimal amount, String comment, Integer flag, Integer status, String serialNum,
                                  BigDecimal before, BigDecimal after) throws ServiceException, ServiceDaoException {
        log.info("add transaction : order " + order + " , user : " + user + " , type : " + type + " , detailedType : " +
        " payAccount : " + payAccount + " amount : " + amount + " comment : " + comment + " flag : " +
        flag + " status : " + status + " serialNum : " + serialNum + " beforeAmount : " + before + " afterAmount : " + after);

        FundHistory fundHistory = new FundHistory();
        Long id = 0L;

        try{
            UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(payAccount);
            Long accountId = accountService.getObjectByCode(userAccountRelation.getAccountCode());
            Account account = accountService.getObjectById(accountId);
            log.info("account : " + account);

            fundHistory.setUid(user.getId());
            fundHistory.setName(user.getName());
            fundHistory.setMobile(user.getMobile());
            fundHistory.setUserType(user.getType());
            fundHistory.setType(type);
            fundHistory.setDetail(detail);
            fundHistory.setPayAccountId(payAccount);
            fundHistory.setPayAccountName(account.getName());
            fundHistory.setAmount(amount);
            fundHistory.setComment(comment);
            if(null != order){
                log.info("order exist");
                fundHistory.setOrderNo(order.getOrderNo());
                fundHistory.setAdditional(order.getAdditional());
            }
            fundHistory.setFlag(flag);
            fundHistory.setStatus(status);
            fundHistory.setSerialNum(serialNum);
            fundHistory.setBeforeTransaction(before);
            fundHistory.setAfterTransaction(after);
            id = insert(fundHistory);

        }catch (Exception e){
            log.error(" count by getFundHistoryIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info("transaction amount : " + amount);
        log.info("now insert transaction success and user : " + user.getId() + " account : " + payAccount + " amount " + before + " >>>>>>>>>> " + after);

        return id;
    }

}

