package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.Bank;
import com.ptteng.wealth.finance.service.BankService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class BankServiceImpl extends BaseDaoServiceImpl implements BankService {

 

	private static final Log log = LogFactory.getLog(BankServiceImpl.class);



		   
		@Override
		public Long insert(Bank bank)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + bank);

		if (bank == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		bank.setCreateAt(currentTimeMillis);
		bank.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(bank);
		} catch (DaoException e) {
			log.error(" insert wrong : " + bank);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Bank> insertList(List<Bank> bankList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (bankList == null ? "null" : bankList.size()));
      
		List<Bank> resultList = null;

		if (CollectionUtils.isEmpty(bankList)) {
			return new ArrayList<Bank>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Bank bank : bankList) {
			bank.setCreateAt(currentTimeMillis);
			bank.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Bank>) dao.batchSave(bankList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + bankList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Bank.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Bank bank)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (bank == null ? "null" : bank.getId()));

		boolean result = false;

		if (bank == null) {
			return true;
		}

		bank.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(bank);
		} catch (DaoException e) {
			log.error(" update wrong : " + bank);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + bank);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Bank> bankList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (bankList == null ? "null" : bankList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(bankList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Bank bank : bankList) {
			bank.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(bankList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + bankList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + bankList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Bank getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Bank bank = null;

		if (id == null) {
			return bank;
		}

		try {
			bank = (Bank) dao.get(Bank.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return bank;		
		}	
		  
    	   
		@Override
		public List<Bank> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Bank> bank = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Bank>();
		}

		try {
			bank = (List<Bank>) dao.getList(Bank.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (bank == null ? "null" : bank.size()));
    
		return bank;	
		}




	@Override
	public Long  getBankIdByCode(String bankCode)throws ServiceException, ServiceDaoException{

		log.info(" get id by bankCode  : " + bankCode);
		Long id = null;
		// TODO 参数检查!
		try {
			id = (Long) dao.getMapping("getBankIdByCode", new Object[]{bankCode});
		} catch (DaoException e) {
			log.error(" get id wrong by bankCode  : " + bankCode);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get id success : " + id);
		}
		return id;

	}
	
		
	
	
	
		
	@Override
	public List<Long> getBankIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getBankIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countBankIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getBankIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getBankIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

