package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.AnnualYield;
import com.ptteng.wealth.finance.service.AnnualYieldService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class AnnualYieldServiceImpl extends BaseDaoServiceImpl implements AnnualYieldService {

 

	private static final Log log = LogFactory.getLog(AnnualYieldServiceImpl.class);



		   
		@Override
		public Long insert(AnnualYield annualYield)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + annualYield);

		if (annualYield == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		annualYield.setCreateAt(currentTimeMillis);
		annualYield.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(annualYield);
		} catch (DaoException e) {
			log.error(" insert wrong : " + annualYield);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<AnnualYield> insertList(List<AnnualYield> annualYieldList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (annualYieldList == null ? "null" : annualYieldList.size()));
      
		List<AnnualYield> resultList = null;

		if (CollectionUtils.isEmpty(annualYieldList)) {
			return new ArrayList<AnnualYield>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (AnnualYield annualYield : annualYieldList) {
			annualYield.setCreateAt(currentTimeMillis);
			annualYield.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<AnnualYield>) dao.batchSave(annualYieldList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + annualYieldList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(AnnualYield.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(AnnualYield annualYield)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (annualYield == null ? "null" : annualYield.getId()));

		boolean result = false;

		if (annualYield == null) {
			return true;
		}

		annualYield.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(annualYield);
		} catch (DaoException e) {
			log.error(" update wrong : " + annualYield);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + annualYield);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<AnnualYield> annualYieldList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (annualYieldList == null ? "null" : annualYieldList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(annualYieldList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (AnnualYield annualYield : annualYieldList) {
			annualYield.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(annualYieldList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + annualYieldList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + annualYieldList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public AnnualYield getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		AnnualYield annualYield = null;

		if (id == null) {
			return annualYield;
		}

		try {
			annualYield = (AnnualYield) dao.get(AnnualYield.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return annualYield;		
		}	
		  
    	   
		@Override
		public List<AnnualYield> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<AnnualYield> annualYield = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<AnnualYield>();
		}

		try {
			annualYield = (List<AnnualYield>) dao.getList(AnnualYield.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (annualYield == null ? "null" : annualYield.size()));
    
		return annualYield;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getAnnualYieldIdsByProductId(Long productId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by productId,start,limit  : " + productId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO �������!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getAnnualYieldIdsByProductId", new Object[] { productId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by productId,start,limit)  : " + productId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countAnnualYieldIdsByProductId(Long productId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by productId  : " + productId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getAnnualYieldIdsByProductId", new Object[] { productId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by productId)  : " + productId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getAnnualYieldIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getAnnualYieldIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countAnnualYieldIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getAnnualYieldIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getAnnualYieldIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

