-- ----------------------------
-- Table structure for `address`
-- ----------------------------
-- DROP TABLE IF EXISTS `address`;
CREATE TABLE `address` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` int NOT NULL  ,  
    `provice` int NOT NULL  ,  
    `city` int NOT NULL  ,  
    `area` varchar(20) NOT NULL  ,  
    `detail` varchar(500)   ,  
    `station` varchar(100)   ,  
    `zip_code` int NOT NULL  ,  
    `reciver_name` varchar(20) NOT NULL  ,  
    `reciver_mobile` varchar(20) NOT NULL  ,  
    `reciver_phone` varchar(20)   ,  
    `type` int NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `invoice`
-- ----------------------------
-- DROP TABLE IF EXISTS `invoice`;
CREATE TABLE `invoice` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `name` varchar(20) NOT NULL  ,  
    `tax_no` bigint NOT NULL  ,  
    `bank` varchar(100) NOT NULL  ,  
    `provice` varchar(20) NOT NULL  ,  
    `city` varchar(20) NOT NULL  ,  
    `branch_bank` varchar(100) NOT NULL  ,  
    `account` bigint NOT NULL  ,  
    `reciver` varchar(20) NOT NULL  ,  
    `phone` varchar(20) NOT NULL  ,  
    `address` varchar(500) NOT NULL  ,  
    `type` int NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `product`
-- ----------------------------
-- DROP TABLE IF EXISTS `product`;
CREATE TABLE `product` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `pro_code` bigint NOT NULL  ,  
    `pro_name` varchar(20) NOT NULL  ,  
    `manager` varchar(20) NOT NULL  ,  
    `risk` int NOT NULL  ,  
    `reward` varchar(20) NOT NULL  ,  
    `validaty` int NOT NULL  ,  
    `fund_line` int NOT NULL  ,  
    `top_line` int NOT NULL  ,  
    `pro_value` varchar(20) NOT NULL  ,  
    `price` varchar(20) NOT NULL  ,  
    `intro_start` bigint NOT NULL  ,  
    `intro_stop` bigint NOT NULL  ,  
    `reward_start` bigint NOT NULL  ,  
    `reward_stop` bigint NOT NULL  ,  
    `fertilizer` varchar(20)   ,  
    `status` int NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `proExt`
-- ----------------------------
-- DROP TABLE IF EXISTS `proExt`;
CREATE TABLE `proExt` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `publish_org` varchar(20) NOT NULL  ,  
    `public_org_code` varchar(20) NOT NULL  ,  
    `alias` varchar(20) NOT NULL  ,  
    `permit_img` varchar(100) NOT NULL  ,  
    `tax_img` varchar(100) NOT NULL  ,  
    `org_code` varchar(20) NOT NULL  ,  
    `licence_code` varchar(20) NOT NULL  ,  
    `credit_code` int NOT NULL  ,  
    `status` int NOT NULL  ,  
    `limit` int NOT NULL  ,  
    `occur` int NOT NULL  ,
    `buy_status` int NOT NULL  ,  
    `active_status` int NOT NULL  ,  
    `type_status` int NOT NULL  ,  
    `buy_unit` int NOT NULL  ,  
    `investor` varchar(500) NOT NULL  ,  
    `buy_protocol` varchar(1000) NOT NULL  ,  
    `buy_line` varchar(20) NOT NULL  ,  
    `comment` varchar(1000) NOT NULL  ,  
    `continue_explain` varchar(1000) NOT NULL  ,  
    `continue_explain_simple` varchar(1000) NOT NULL  ,  
    `continue_buy_tips` varchar(1000) NOT NULL  ,  
    `content` text   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `debtApply`
-- ----------------------------
-- DROP TABLE IF EXISTS `debtApply`;
CREATE TABLE `debtApply` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `order_no` varchar(20) NOT NULL  ,  
    `total` varchar(20) NOT NULL  ,  
    `debt_count` varchar(20)   ,  
    `reason` varchar(1000)   ,  
    `status` bigint NOT NULL  ,  
    `verify_at` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `creditApply`
-- ----------------------------
-- DROP TABLE IF EXISTS `creditApply`;
CREATE TABLE `creditApply` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `org_name` varchar(20) NOT NULL  ,  
    `name` varchar(20) NOT NULL  ,  
    `mobile` varchar(20) NOT NULL  ,  
    `line_before` varchar(20)   ,  
    `line_left` varchar(20)   ,  
    `line_apply` varchar(20)   ,  
    `line_final` varchar(20)   ,  
    `verify_manager` varchar(20)   ,  
    `status` bigint NOT NULL  ,  
    `verify_at` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `cashApply`
-- ----------------------------
-- DROP TABLE IF EXISTS `cashApply`;
CREATE TABLE `cashApply` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `expenditure_count` varchar(20) NOT NULL  ,  
    `type` int NOT NULL  ,  
    `card_no` varchar(20) NOT NULL  ,  
    `manner` int   ,  
    `status` int NOT NULL  ,  
    `verify_at` bigint   ,  
    `reason` varchar(1000)   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `fund`
-- ----------------------------
-- DROP TABLE IF EXISTS `fund`;
CREATE TABLE `fund` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `fund` bigint NOT NULL  ,  
    `frozen` varchar(20) NOT NULL  ,  
    `credit_line` bigint NOT NULL  ,  
    `fast_count` int NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `fundHistory`
-- ----------------------------
-- DROP TABLE IF EXISTS `fundHistory`;
CREATE TABLE `fundHistory` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `amount` bigint NOT NULL  ,  
    `bank` varchar(20) NOT NULL  ,  
    `card_no` varchar(20) NOT NULL  ,  
    `certificate` varchar(20) NOT NULL  ,  
    `status` int NOT NULL  ,  
    `type` int NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





-- ----------------------------
-- Table structure for `account`
-- ----------------------------
-- DROP TABLE IF EXISTS `account`;
CREATE TABLE `account` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,
    `name` varchar(200) NOT NULL  ,
    `remark` text  NULL  ,
    `create_by` bigint NOT NULL  ,
    `update_by` bigint   ,
    `update_at` bigint NOT NULL  ,
    `create_at` bigint NOT NULL  ,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_account_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_account_relation`;
CREATE TABLE `user_account_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,
    `user_id` bigint NOT NULL  ,
    `account_id` bigint NOT NULL  ,
    `money` varchar(50)   ,
    `create_by` bigint NOT NULL  ,
    `update_by` bigint   ,
    `update_at` bigint NOT NULL  ,
    `create_at` bigint NOT NULL  ,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;



-- ----------------------------
-- Table structure for `accountRecord`
-- ----------------------------
-- DROP TABLE IF EXISTS `accountRecord`;
CREATE TABLE `accountRecord` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,
    `user_id` bigint NOT NULL  ,
    `org_code` varchar(20)   ,
    `org_name` varchar(225)   ,
    `account_id` bigint NOT NULL  ,
    `account_code` varchar(200) NOT NULL  ,
    `type` int NOT NULL  ,
    `serial_num` varchar(300) NOT NULL  ,
    `add_money` varchar(50) NOT NULL  ,
    `last_money` varchar(50) NOT NULL  ,
    `create_by` bigint NOT NULL  ,
    `update_by` bigint   ,
    `update_at` bigint NOT NULL  ,
    `create_at` bigint NOT NULL  ,
    `money_type` bigint NOT NULL  ,

    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `productDaily`
-- ----------------------------
-- DROP TABLE IF EXISTS `productDaily`;
CREATE TABLE `productDaily` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '������  id',
    `static_at` bigint NOT NULL   COMMENT 'ͳ��ʱ��:ÿ���23��58��',
    `product_id` bigint NOT NULL   COMMENT '��ƷID',
    `buy_person_sum` varchar(30) NOT NULL   COMMENT '����������',
    `buy_count` varchar(30) NOT NULL   COMMENT '�����ܱ���',
    `buy_sum_amount` varchar(30) NOT NULL   COMMENT '�����ܽ��',
    `withdrawal_person_sum` varchar(30) NOT NULL   COMMENT '���������',
    `withdrawal_count` varchar(30) NOT NULL   COMMENT '����ܱ���',
    `withdrawal_amount` varchar(30) NOT NULL   COMMENT '����ܽ��',
    `create_by` bigint NOT NULL   COMMENT '������id',
    `update_by` bigint    COMMENT '������id',
    `update_at` bigint NOT NULL   COMMENT '���ݸ���ʱ��',
    `create_at` bigint NOT NULL   COMMENT '���ݴ���ʱ��',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `product`
-- ----------------------------
-- DROP TABLE IF EXISTS `product`;
CREATE TABLE `product` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '������  id',
    `product_no` varchar(30) NOT NULL   COMMENT '��Ʒ����',
    `name` varchar(100) NOT NULL   COMMENT '��Ʒ��',
    `second_level_no` varchar(30) NOT NULL   COMMENT '��������',
    `product_type` int(3) NOT NULL   COMMENT '��Ʒ����',
    `buy_status` int(3) NOT NULL   COMMENT '����״̬',
    `fixed_investment_satus` int(3) NOT NULL   COMMENT '��Ͷ״̬',
    `fund_no` varchar(30) NOT NULL   COMMENT '������',
    `scale_upper_limit` varchar(30) NOT NULL   COMMENT '�ƻ����й�ģ����',
    `product_desc` varchar(100) NOT NULL   COMMENT '��Ʒ����',
    `period` varchar(30) NOT NULL   COMMENT '����',
    `annual_yield` varchar(30) NOT NULL   COMMENT '�껯���棨%)',
    `amount` varchar(30) NOT NULL   COMMENT '�𹺽��',
    `investment_confirm_date` int(3) NOT NULL   COMMENT 'Ͷ��ȷ����',
    `Interest_start_date` int(3) NOT NULL   COMMENT '��Ϣ��ʼ��',
    `status` int(3) NOT NULL   COMMENT '״̬',
    `create_by` bigint NOT NULL   COMMENT '������id',
    `update_by` bigint    COMMENT '������id',
    `update_at` bigint NOT NULL   COMMENT '���ݸ���ʱ��',
    `create_at` bigint NOT NULL   COMMENT '���ݴ���ʱ��',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





-- ----------------------------
-- Table structure for `annualYield`
-- ----------------------------
-- DROP TABLE IF EXISTS `annualYield`;
CREATE TABLE `annualYield` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长  id',
    `product_id` bigint NOT NULL   COMMENT '产品ID',
    `static_at` bigint NOT NULL   COMMENT '日期',
    `annual_yield` varchar(30) NOT NULL   COMMENT '当日年化收益率',
    `create_by` bigint NOT NULL   COMMENT '创建人id',
    `update_by` bigint    COMMENT '更新人id',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;
