/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl.account;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.config.helper.GroupHelper;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.SwapDao;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component(value="UserAccountRelationServiceImpl")
public class UserAccountRelationServiceImpl
extends BaseDaoServiceImpl
implements UserAccountRelationService {
    private static final Log log = LogFactory.getLog(UserAccountRelationServiceImpl.class);
    protected SwapDao swapDao = new SwapDao(GroupHelper.getDataSource((String)"wealth_finance"));

    public Long insert(UserAccountRelation userAccountRelation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userAccountRelation));
        if (userAccountRelation == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userAccountRelation.setCreateAt(Long.valueOf(currentTimeMillis));
        userAccountRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userAccountRelation);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userAccountRelation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserAccountRelation> insertList(List<UserAccountRelation> userAccountRelationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userAccountRelationList == null ? "null" : Integer.valueOf(userAccountRelationList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userAccountRelationList)) {
            return new ArrayList<UserAccountRelation>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserAccountRelation userAccountRelation : userAccountRelationList) {
            userAccountRelation.setCreateAt(Long.valueOf(currentTimeMillis));
            userAccountRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userAccountRelationList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userAccountRelationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserAccountRelation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserAccountRelation userAccountRelation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userAccountRelation == null ? "null" : userAccountRelation.getId())));
        boolean result = false;
        if (userAccountRelation == null) {
            return true;
        }
        userAccountRelation.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userAccountRelation);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userAccountRelation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userAccountRelation));
        }
        return result;
    }

    public boolean updateList(List<UserAccountRelation> userAccountRelationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userAccountRelationList == null ? "null" : Integer.valueOf(userAccountRelationList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userAccountRelationList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserAccountRelation userAccountRelation : userAccountRelationList) {
            userAccountRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userAccountRelationList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userAccountRelationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userAccountRelationList.size()));
        return result;
    }

    public UserAccountRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserAccountRelation userAccountRelation = null;
        if (id == null) {
            return userAccountRelation;
        }
        try {
            userAccountRelation = (UserAccountRelation)this.dao.get(UserAccountRelation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userAccountRelation;
    }

    public List<UserAccountRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userAccountRelation = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserAccountRelation>();
        }
        try {
            userAccountRelation = this.dao.getList(UserAccountRelation.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userAccountRelation == null ? "null" : Integer.valueOf(userAccountRelation.size()))));
        return userAccountRelation;
    }

    public Long getUserAccountRelationIdByUserIdAndAccountId(Long userId, Long accountId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by userId,accountId  : " + userId + " , " + accountId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserAccountRelationIdByUserIdAndAccountId", new Object[]{userId, accountId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by userId,accountId  : " + userId + " , " + accountId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getUserAccountRelationIdByUserIdAndAccountCode(Long userId, String accountCode) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by userId,accountCode  : " + userId + " , " + accountCode));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserAccountRelationIdByUserIdAndAccountCode", new Object[]{userId, accountCode});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by userId,accountCode  : " + userId + " , " + accountCode));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getUserAccountRelationIdsByUserId(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by userId,start,limit  : " + userId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserAccountRelationIdsByUserId", new Object[]{userId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by userId,start,limit)  : " + userId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserAccountRelationIdsByUserId(Long userId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by userId  : " + userId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserAccountRelationIdsByUserId", new Object[]{userId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by userId)  : " + userId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserAccountRelationIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserAccountRelationIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserAccountRelationIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserAccountRelationIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserAccountRelationIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public int swapMoney(Long fromId, Long toId, Double money, String serialNo, Long mid, String comments) throws ServiceException, ServiceDaoException {
        Map map = this.swapDao.getResult(fromId, toId, money, serialNo, mid, comments, System.currentTimeMillis());
        log.info((Object)("swap money map : " + map.toString() + " and errorcode : " + map.get("errorcode").toString()));
        String errocode = (String)map.get("errorcode");
        log.info((Object)(" error code : " + errocode));
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    public int execMoney(Long recordId, Long userId) throws ServiceException, ServiceDaoException {
        Map map = this.swapDao.execResult(recordId, userId, System.currentTimeMillis());
        String errocode = (String)map.get("errorcode");
        log.info((Object)(" error code : " + errocode));
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    public int addResult(Long acountid, Double amount, String serialNo, Integer mtype, Long mid, Long postLine, Integer needCheck, Integer receiveCheck, String fromParty, String fromBank, String fromAt, String comment) throws ServiceException, ServiceDaoException {
        log.info((Object)(acountid + "  " + amount + " " + serialNo + "  " + mtype + "  " + mid + "  " + postLine + "  " + needCheck + "  " + receiveCheck + "  " + fromParty + "  " + fromBank + "  " + fromAt + "  " + comment));
        Map map = this.swapDao.addResult(acountid, amount, serialNo, mtype, mid, System.currentTimeMillis(), postLine, needCheck, receiveCheck, fromParty, fromBank, fromAt, comment);
        log.info((Object)("add result map : " + map.toString() + " and errorcode : " + map.get("errorcode").toString()));
        String errocode = (String)map.get("errorcode");
        log.info((Object)(" error code : " + errocode));
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    public int addExec(Long recordId, Long mid) throws ServiceException, ServiceDaoException {
        Map map = this.swapDao.addExec(recordId, mid, System.currentTimeMillis());
        String errocode = (String)map.get("errorcode");
        log.info((Object)(" error code : " + errocode));
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    public int payOrder(Long orderId, Long userAccountId, Integer payType) throws ServiceException, ServiceDaoException {
        log.info((Object)("payOrder orderId : " + orderId + " userAccountId : " + userAccountId + " payType : " + payType));
        Map map = this.swapDao.payorder(orderId, userAccountId, payType);
        String errocode = (String)map.get("errorcode");
        log.info((Object)(" error code : " + errocode));
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    public int payDeposit(Long userAccountId, Double paymoney, Double debtCount, Long debtApplyId, Long uid, Long orderId, Long overAt) {
        log.info((Object)(" payDeposit userAccountId: " + userAccountId + " paymoney: " + paymoney + " debtCount: " + debtCount + " debtApplyId: " + debtApplyId + " uid: " + uid + " orderId: " + orderId + " overAt: " + overAt));
        Map map = this.swapDao.paydeposit(userAccountId, paymoney, debtCount, debtApplyId, uid, orderId, overAt);
        String errocode = (String)map.get("errorcode");
        log.info((Object)(" error code : " + errocode));
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    public int payDepositdaixiao(Double debtCount, Long debtApplyId, Long uid, Long orderId, Long overAt) {
        log.info((Object)("payDepositdaixiao  DebtCount: " + debtCount + " debtApplyId: " + debtApplyId + " uid: " + uid + " orderId: " + orderId + " overAt: " + overAt));
        Map map = this.swapDao.paydepositdaixiao(debtCount, debtApplyId, uid, orderId, overAt);
        String errocode = (String)map.get("errorcode");
        log.info((Object)(" error code : " + errocode));
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    public int shexiaoKL(Long userAccountId, Double repayTot, Double clearInte, Double clearOverInte, Double overDayCount, Long clearAt, Long loanApplyId, Long orderId, Long currenttime) {
        Map map = this.swapDao.shexiaoKL(userAccountId, repayTot, clearInte, clearOverInte, overDayCount, clearAt, loanApplyId, orderId, currenttime);
        String errocode = (String)map.get("errorcode");
        log.info((Object)(" error code : " + errocode));
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }

    public int shexiaoDX(Double repayTot, Double clearInte, Double clearOverInte, Double overDayCount, Long clearAt, Long loanApplyId, Long orderId, Long currenttime) {
        log.info((Object)("shexiaoDX repayTot : " + repayTot + " clearInte : " + clearInte + " clearOverInte : " + clearOverInte + " overDayCount : " + overDayCount + " clearAt : " + clearAt + " loanApplyId : " + loanApplyId + " orderId : " + orderId + " currenttime : " + currenttime));
        Map map = this.swapDao.shexiaoDX(repayTot, clearInte, clearOverInte, overDayCount, clearAt, loanApplyId, orderId, currenttime);
        String errocode = (String)map.get("errorcode");
        log.info((Object)(" error code : " + errocode));
        Integer errorcode = Integer.parseInt(errocode);
        return errorcode;
    }
}

