/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.service.OrderService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderServiceImpl
extends BaseDaoServiceImpl
implements OrderService {
    private static final Log orderLog = LogFactory.getLog((String)"order");

    public Long insert(Order order) throws ServiceException, ServiceDaoException {
        orderLog.info((Object)(" insert data : " + order));
        if (order == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        order.setCreateAt(Long.valueOf(currentTimeMillis));
        order.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)order);
        }
        catch (DaoException e) {
            orderLog.error((Object)(" insert wrong : " + order));
            orderLog.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        orderLog.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Order> insertList(List<Order> orderList) throws ServiceException, ServiceDaoException {
        orderLog.info((Object)(" insert lists : " + (orderList == null ? "null" : Integer.valueOf(orderList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(orderList)) {
            return new ArrayList<Order>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Order order : orderList) {
            order.setCreateAt(Long.valueOf(currentTimeMillis));
            order.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(orderList);
        }
        catch (DaoException e) {
            orderLog.error((Object)(" insert list wrong : " + orderList));
            orderLog.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        orderLog.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        orderLog.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Order.class, (Serializable)id);
        }
        catch (DaoException e) {
            orderLog.error((Object)(" delete wrong : " + id));
            orderLog.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        orderLog.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Order order) throws ServiceException, ServiceDaoException {
        orderLog.info((Object)(" update data : " + (order == null ? "null" : order.getId())));
        boolean result = false;
        if (order == null) {
            return true;
        }
        order.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)order);
        }
        catch (DaoException e) {
            orderLog.error((Object)(" update wrong : " + order));
            orderLog.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (orderLog.isInfoEnabled()) {
            orderLog.info((Object)(" update data success : " + order));
        }
        return result;
    }

    public boolean updateList(List<Order> orderList) throws ServiceException, ServiceDaoException {
        orderLog.info((Object)(" update lists : " + (orderList == null ? "null" : Integer.valueOf(orderList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(orderList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Order order : orderList) {
            order.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(orderList);
        }
        catch (DaoException e) {
            orderLog.error((Object)(" update list wrong : " + orderList));
            orderLog.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        orderLog.info((Object)(" update lists success : " + orderList.size()));
        return result;
    }

    public Order getObjectById(Long id) throws ServiceException, ServiceDaoException {
        orderLog.info((Object)(" get data : " + id));
        Order order = null;
        if (id == null) {
            return order;
        }
        try {
            order = (Order)this.dao.get(Order.class, (Serializable)id);
        }
        catch (DaoException e) {
            orderLog.error((Object)(" get wrong : " + id));
            orderLog.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        orderLog.info((Object)(" get data success : " + id));
        return order;
    }

    public List<Order> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        orderLog.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List order = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Order>();
        }
        try {
            order = this.dao.getList(Order.class, ids);
        }
        catch (DaoException e) {
            orderLog.error((Object)(" get wrong : " + ids));
            orderLog.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        orderLog.info((Object)(" get data success : " + (order == null ? "null" : Integer.valueOf(order.size()))));
        return order;
    }

    public List<Long> getOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        orderLog.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            orderLog.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            orderLog.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (orderLog.isInfoEnabled()) {
            orderLog.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            orderLog.error((Object)" count by getOrderIds ");
            orderLog.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (orderLog.isInfoEnabled()) {
            orderLog.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (orderLog.isInfoEnabled()) {
            orderLog.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrderIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            orderLog.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            orderLog.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (orderLog.isInfoEnabled()) {
            orderLog.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getOrderIdByOrderNo(String orderNo) throws ServiceException, ServiceDaoException {
        if (orderLog.isInfoEnabled()) {
            orderLog.info((Object)(" get id by orderNo  : " + orderNo));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getOrderIdByOrderNo", new Object[]{orderNo, orderNo});
        }
        catch (DaoException e) {
            orderLog.error((Object)(" get id wrong by orderNo : " + orderNo));
            orderLog.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (orderLog.isInfoEnabled()) {
            orderLog.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getOrderIdByOrderNoAndAdditional(String orderNo, String additional) throws ServiceException, ServiceDaoException {
        orderLog.info((Object)(" get id by orderNo  : " + orderNo + " and additional : " + additional));
        if (orderLog.isInfoEnabled()) {
            orderLog.info((Object)(" get id by orderNo  : " + orderNo + " and additional : " + additional));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getOrderIdByOrderNoAndAdditional", new Object[]{orderNo, additional});
        }
        catch (DaoException e) {
            orderLog.error((Object)(" get id wrong by orderNo : " + orderNo + " and additional : " + additional));
            orderLog.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (orderLog.isInfoEnabled()) {
            orderLog.info((Object)(" get id success : " + id));
        }
        return id;
    }
}

