/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.LoanProduct;
import com.ptteng.wealth.finance.service.LoanProductService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoanProductServiceImpl
extends BaseDaoServiceImpl
implements LoanProductService {
    private Log log = LogFactory.getLog(LoanProductServiceImpl.class);

    public Long insert(LoanProduct loanProduct) throws ServiceException, ServiceDaoException {
        this.log.info((Object)(" insert data : " + loanProduct));
        if (loanProduct == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        loanProduct.setCreateAt(Long.valueOf(currentTimeMillis));
        loanProduct.setUpdateAt(Long.valueOf(currentTimeMillis));
        loanProduct.setDal(Integer.valueOf(1));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)loanProduct);
        }
        catch (DaoException e) {
            this.log.error((Object)(" insert wrong : " + loanProduct));
            this.log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        this.log.info((Object)(" insert data success : " + result));
        return result;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        this.log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(LoanProduct.class, (Serializable)id);
        }
        catch (DaoException e) {
            this.log.error((Object)(" delete wrong : " + id));
            this.log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        this.log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(LoanProduct loanProduct) throws ServiceException, ServiceDaoException {
        this.log.info((Object)(" update data : " + (loanProduct == null ? "null" : loanProduct.getId())));
        boolean result = false;
        if (loanProduct == null) {
            return true;
        }
        loanProduct.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)loanProduct);
        }
        catch (DaoException e) {
            this.log.error((Object)(" update wrong : " + loanProduct));
            this.log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)(" update data success : " + loanProduct));
        }
        return result;
    }

    public LoanProduct getObjectById(Long id) throws ServiceException, ServiceDaoException {
        this.log.info((Object)(" get data : " + id));
        LoanProduct loanProduct = null;
        if (id == null) {
            return loanProduct;
        }
        try {
            loanProduct = (LoanProduct)this.dao.get(LoanProduct.class, (Serializable)id);
        }
        catch (DaoException e) {
            this.log.error((Object)(" get wrong : " + id));
            this.log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        this.log.info((Object)(" get data success : " + id));
        return loanProduct;
    }

    public List<LoanProduct> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        this.log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List loanProducts = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<LoanProduct>();
        }
        try {
            loanProducts = this.dao.getList(LoanProduct.class, ids);
        }
        catch (DaoException e) {
            this.log.error((Object)(" get wrong : " + ids));
            this.log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        this.log.info((Object)(" get data success : " + (loanProducts == null ? "null" : Integer.valueOf(loanProducts.size()))));
        return loanProducts;
    }

    public List<Long> getLoanIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        this.log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLoanProductAll", new Object[]{1}, start, limit, false);
        }
        catch (DaoException e) {
            this.log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            this.log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<LoanProduct> getLoanProductByManner(Integer payManner) throws ServiceException, ServiceDaoException {
        List idList = null;
        ArrayList<LoanProduct> loanProducts = new ArrayList();
        try {
            idList = this.dao.getIdList("getLoanProductManner", new Object[]{payManner}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
            loanProducts = this.getObjectsByIds(idList);
        }
        catch (DaoException e) {
            this.log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return loanProducts;
    }
}

