/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.Invest;
import com.ptteng.wealth.finance.service.InvestService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InvestServiceImpl
extends BaseDaoServiceImpl
implements InvestService {
    private static final Log log = LogFactory.getLog(InvestServiceImpl.class);

    public Long insert(Invest invest) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + invest));
        if (invest == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        invest.setCreateAt(Long.valueOf(currentTimeMillis));
        invest.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)invest);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + invest));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Invest> insertList(List<Invest> investList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (investList == null ? "null" : Integer.valueOf(investList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(investList)) {
            return new ArrayList<Invest>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Invest invest : investList) {
            invest.setCreateAt(Long.valueOf(currentTimeMillis));
            invest.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(investList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + investList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Invest.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Invest invest) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (invest == null ? "null" : invest.getId())));
        boolean result = false;
        if (invest == null) {
            return true;
        }
        invest.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)invest);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + invest));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + invest));
        }
        return result;
    }

    public boolean updateList(List<Invest> investList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (investList == null ? "null" : Integer.valueOf(investList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(investList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Invest invest : investList) {
            invest.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(investList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + investList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + investList.size()));
        return result;
    }

    public Invest getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Invest invest = null;
        if (id == null) {
            return invest;
        }
        try {
            invest = (Invest)this.dao.get(Invest.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return invest;
    }

    public List<Invest> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List invest = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Invest>();
        }
        try {
            invest = this.dao.getList(Invest.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (invest == null ? "null" : Integer.valueOf(invest.size()))));
        return invest;
    }

    public List<Long> getInvestIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getInvestIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getInvestIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getInvestIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getInvestIdsByUidAndPid(Long uid, Long pid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,pid,start,limit  : " + uid + " , " + pid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getInvestIdsByUidAndPid", new Object[]{uid, pid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,pid,start,limit)  : " + uid + " , " + pid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countInvestIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,status  : " + uid + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getInvestIdsByUidAndStatus", new Object[]{uid, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,status)  : " + uid + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countInvestIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getInvestIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countInvestIdsByUidAndPid(Long uid, Long pid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,pid  : " + uid + " , " + pid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getInvestIdsByUidAndPid", new Object[]{uid, pid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,pid)  : " + uid + " , " + pid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getInvestIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getInvestIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countInvestIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getInvestIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getInvestIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long addInvest(Long uid, Long pid, Integer paymentType, BigDecimal amount, String bankName, String name, String mobile, String cardNo, Long inteAt) throws ServiceException, ServiceDaoException {
        Long id = 0L;
        try {
            Invest invest = new Invest();
            invest.setUid(uid);
            invest.setPid(pid);
            invest.setPaymentType(paymentType);
            invest.setName(name);
            invest.setCardNo(cardNo);
            invest.setStatus(Invest.STATUS_COMPLETE);
            invest.setAmount(amount);
            invest.setBankName(bankName);
            invest.setInteAt(inteAt);
            log.info((Object)("invest record : " + invest));
            id = this.insert(invest);
        }
        catch (Exception e) {
            log.error((Object)" count by getInvestIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)" insert invest wrong");
        }
        return id;
    }
}

