/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance;

import com.gemantic.dal.id.dao.SequenceDao;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcCall;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SwapDao {
    private static final Log log = LogFactory.getLog(SequenceDao.class);
    protected DataSource dataSource;
    protected SimpleJdbcTemplate simpleJdbcTemplate;
    protected SimpleJdbcCall swapproc;
    protected SimpleJdbcCall execproc;
    protected SimpleJdbcCall addproc;
    protected SimpleJdbcCall addprocexec;
    protected SimpleJdbcCall payorderexec;
    protected SimpleJdbcCall paydepositexec;
    protected SimpleJdbcCall paydepositdaixiaoexec;
    protected SimpleJdbcCall repayshexiaodaixiaoexec;
    protected SimpleJdbcCall repayshexiaoexec;

    public SwapDao(DataSource db) {
        this.dataSource = db;
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(this.dataSource);
        this.swapproc = new SimpleJdbcCall(this.dataSource).withProcedureName("swap_money").useInParameterNames(new String[]{"fromid", "toid", "amount", "serialNo", "mid", "comments", "currenttime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        this.execproc = new SimpleJdbcCall(this.dataSource).withProcedureName("execute_change").useInParameterNames(new String[]{"recordid", "mid", "currenttime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        this.addproc = new SimpleJdbcCall(this.dataSource).withProcedureName("add_money_record").useInParameterNames(new String[]{"acountid", "amount", "serialNo", "mtype", "mid", "currenttime", "postLine", "needCheck", "receiveCheck", "fromParty", "fromBank", "fromAt", "comments"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        this.addprocexec = new SimpleJdbcCall(this.dataSource).withProcedureName("add_money_exec").useInParameterNames(new String[]{"recordid", "mid", "currenttime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        this.payorderexec = new SimpleJdbcCall(this.dataSource).withProcedureName("pay_order").useInParameterNames(new String[]{"orderId", "payType", "userAccountId", "currenttime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        this.paydepositexec = new SimpleJdbcCall(this.dataSource).withProcedureName("pay_deposit").useInParameterNames(new String[]{"userAccountId", "paymoney", "debtCount", "debtApplyId", "uid", "orderId", "currenttime", "overattime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        this.paydepositdaixiaoexec = new SimpleJdbcCall(this.dataSource).withProcedureName("pay_deposit_daixiao").useInParameterNames(new String[]{"debtApplyId", "debtCount", "uid", "orderId", "currenttime", "overattime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        this.repayshexiaodaixiaoexec = new SimpleJdbcCall(this.dataSource).withProcedureName("pay_shexiao_daixiao").useInParameterNames(new String[]{"repayTot", "clearInte", "clearOverInte", "overDayCount", "clearAt", "loanApplyId", "orderId", "currenttime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
        this.repayshexiaoexec = new SimpleJdbcCall(this.dataSource).withProcedureName("pay_shexiao").useInParameterNames(new String[]{"userAccountId", "repayTot", "clearInte", "clearOverInte", "overDayCount", "clearAt", "loanApplyId", "orderId", "currenttime"}).declareParameters(new SqlParameter[]{new SqlOutParameter("errorcode", 0)});
    }

    public Map shexiaoKL(Long userAccountId, Double repayTot, Double clearInte, Double clearOverInte, Double overDayCount, Long clearAt, Long loanApplyId, Long orderId, Long currenttime) {
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("userAccountId", (Object)userAccountId).addValue("repayTot", (Object)repayTot).addValue("clearInte", (Object)clearInte).addValue("clearOverInte", (Object)clearOverInte).addValue("overDayCount", (Object)overDayCount).addValue("clearAt", (Object)clearAt).addValue("loanApplyId", (Object)loanApplyId).addValue("orderId", (Object)orderId).addValue("currenttime", (Object)currenttime);
        Map map = null;
        try {
            map = this.repayshexiaoexec.execute((SqlParameterSource)params);
        }
        catch (Exception var5) {
            var5.printStackTrace(System.out);
        }
        return map;
    }

    public Map shexiaoDX(Double repayTot, Double clearInte, Double clearOverInte, Double overDayCount, Long clearAt, Long loanApplyId, Long orderId, Long currenttime) {
        log.info((Object)(" shexiaoDX DAO: repayTot:  " + repayTot + "  clearInte: " + clearInte + "  clearOverInte: " + clearOverInte + "  overDayCount: " + overDayCount + " clearAt: " + clearAt + " loanApplyId: " + loanApplyId + " orderId: " + orderId + " currenttime: " + currenttime));
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("repayTot", (Object)repayTot).addValue("clearInte", (Object)clearInte).addValue("clearOverInte", (Object)clearOverInte).addValue("overDayCount", (Object)overDayCount).addValue("clearAt", (Object)clearAt).addValue("loanApplyId", (Object)loanApplyId).addValue("orderId", (Object)orderId).addValue("currenttime", (Object)currenttime);
        Map map = null;
        try {
            map = this.repayshexiaodaixiaoexec.execute((SqlParameterSource)params);
        }
        catch (Exception var5) {
            var5.printStackTrace(System.out);
        }
        return map;
    }

    public Map paydepositdaixiao(Double debtCount, Long debtApplyId, Long uid, Long orderId, Long overAt) {
        log.info((Object)(" PAY Deposit DaiXiao DAO: debtCount:  " + debtCount + "  debtApplyId: " + debtApplyId + "  uid: " + uid + "  orderId: " + orderId));
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("debtCount", (Object)debtCount).addValue("debtApplyId", (Object)debtApplyId).addValue("uid", (Object)uid).addValue("orderId", (Object)orderId).addValue("currenttime", (Object)System.currentTimeMillis()).addValue("overattime", (Object)overAt);
        Map map = null;
        try {
            map = this.paydepositdaixiaoexec.execute((SqlParameterSource)params);
        }
        catch (Exception var5) {
            var5.printStackTrace(System.out);
        }
        return map;
    }

    public Map paydeposit(Long userAccountId, Double paymoney, Double debtCount, Long debtApplyId, Long uid, Long orderId, Long overAt) {
        log.info((Object)(" PAY Deposit  DAO: userAccountId: " + userAccountId + " paymoney: " + paymoney + " debtApplyId: " + debtApplyId + " uid: " + uid + " orderId: " + orderId));
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("userAccountId", (Object)userAccountId).addValue("paymoney", (Object)paymoney).addValue("debtCount", (Object)debtCount).addValue("debtApplyId", (Object)debtApplyId).addValue("uid", (Object)uid).addValue("orderId", (Object)orderId).addValue("currenttime", (Object)System.currentTimeMillis()).addValue("overattime", (Object)overAt);
        Map map = null;
        try {
            map = this.paydepositexec.execute((SqlParameterSource)params);
        }
        catch (Exception var5) {
            log.warn((Object)"Warn:IdCenter Exception --> when execute stored procedure \r\n");
            var5.printStackTrace(System.err);
        }
        return map;
    }

    public Map payorder(Long orderId, Long userAccountId, Integer payType) {
        log.info((Object)(" PAYORDER DAO: orderId: " + orderId + " userAccountId: " + userAccountId));
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("orderId", (Object)orderId).addValue("payType", (Object)payType).addValue("userAccountId", (Object)userAccountId).addValue("currenttime", (Object)System.currentTimeMillis());
        Map map = null;
        try {
            map = this.payorderexec.execute((SqlParameterSource)params);
        }
        catch (Exception var5) {
            log.warn((Object)"Warn:IdCenter Exception --> when execute stored procedure \r\n");
            var5.printStackTrace(System.err);
        }
        return map;
    }

    public Map execResult(Long recordId, Long mid, Long currentTime) {
        log.info((Object)(" SWAP DAO: recordId: " + recordId + " mid: " + mid + "  currentTime: " + currentTime));
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("recordid", (Object)recordId).addValue("mid", (Object)mid).addValue("currenttime", (Object)currentTime);
        Map map = null;
        try {
            map = this.execproc.execute((SqlParameterSource)params);
        }
        catch (Exception var5) {
            log.warn((Object)"Warn:IdCenter Exception --> when execute stored procedure \r\n");
            var5.printStackTrace(System.err);
        }
        return map;
    }

    public Map getResult(Long fromId, Long toId, Double amount, String serialNo, Long mid, String comments, Long currentTime) {
        log.info((Object)(" SWAP DAO: fromId: " + fromId + " toId: " + toId + "  amount: " + amount));
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("fromid", (Object)fromId).addValue("toid", (Object)toId).addValue("amount", (Object)amount).addValue("serialNo", (Object)serialNo).addValue("mid", (Object)mid).addValue("comments", (Object)comments).addValue("currenttime", (Object)currentTime);
        Map map = null;
        try {
            map = this.swapproc.execute((SqlParameterSource)params);
        }
        catch (Exception var5) {
            log.warn((Object)"Warn:IdCenter Exception --> when execute stored procedure \r\n");
            var5.printStackTrace(System.err);
        }
        return map;
    }

    public Map addExec(Long recordId, Long mid, Long currentTime) {
        log.info((Object)(" ADD EXEC DAO: recordId: " + recordId + " mid: " + mid + "  currentTime: " + currentTime));
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("recordid", (Object)recordId).addValue("mid", (Object)mid).addValue("currenttime", (Object)currentTime);
        Map map = null;
        try {
            map = this.addprocexec.execute((SqlParameterSource)params);
        }
        catch (Exception var5) {
            log.warn((Object)"Warn:IdCenter Exception --> when execute stored procedure \r\n");
            var5.printStackTrace(System.err);
        }
        return map;
    }

    public Map addResult(Long acountid, Double amount, String serialNo, Integer mtype, Long mid, Long currentTime, Long postLine, Integer needCheck, Integer receiveCheck, String fromParty, String fromBank, String fromAt, String comment) {
        log.info((Object)(" ADD DAO: acountid: " + acountid + "amount: " + amount + "  serialNo : " + serialNo + " mtype: " + mtype + " mid: " + mid + "  currentTime: " + currentTime + " postLine: " + postLine + " needCheck: " + needCheck + " receiveCheck: " + receiveCheck + " fromParty: " + fromParty + " fromBank: " + fromBank + " fromAt: " + fromAt + " comments: " + comment));
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("acountid", (Object)acountid).addValue("amount", (Object)amount).addValue("serialNo", (Object)serialNo).addValue("mtype", (Object)mtype).addValue("mid", (Object)mid).addValue("currenttime", (Object)currentTime).addValue("postLine", (Object)postLine).addValue("needCheck", (Object)needCheck).addValue("receiveCheck", (Object)receiveCheck).addValue("fromParty", (Object)fromParty).addValue("fromBank", (Object)fromBank).addValue("fromAt", (Object)fromAt).addValue("comments", (Object)comment);
        Map map = null;
        try {
            map = this.addproc.execute((SqlParameterSource)params);
        }
        catch (Exception var5) {
            log.warn((Object)"Warn:IdCenter Exception --> when execute stored procedure \r\n");
            var5.printStackTrace(System.err);
        }
        return map;
    }
}

