package com.ptteng.wealth.finance.service.impl.account;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.account.AccountRecord;
import com.ptteng.wealth.finance.service.account.AccountRecordService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class AccountRecordServiceImpl extends BaseDaoServiceImpl implements AccountRecordService {


    private static final Log log = LogFactory.getLog(AccountRecordServiceImpl.class);


    @Override
    public Long insert(AccountRecord accountRecord) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + accountRecord);

        if (accountRecord == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        accountRecord.setCreateAt(currentTimeMillis);
        accountRecord.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(accountRecord);
        } catch (DaoException e) {
            log.error(" insert wrong : " + accountRecord);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<AccountRecord> insertList(List<AccountRecord> accountRecordList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (accountRecordList == null ? "null" : accountRecordList.size()));

        List<AccountRecord> resultList = null;

        if (CollectionUtils.isEmpty(accountRecordList)) {
            return new ArrayList<AccountRecord>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (AccountRecord accountRecord : accountRecordList) {
            accountRecord.setCreateAt(currentTimeMillis);
            accountRecord.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<AccountRecord>) dao.batchSave(accountRecordList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + accountRecordList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(AccountRecord.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(AccountRecord accountRecord) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (accountRecord == null ? "null" : accountRecord.getId()));

        boolean result = false;

        if (accountRecord == null) {
            return true;
        }

        accountRecord.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(accountRecord);
        } catch (DaoException e) {
            log.error(" update wrong : " + accountRecord);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + accountRecord);
        }
        return result;
    }


    @Override
    public boolean updateList(List<AccountRecord> accountRecordList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (accountRecordList == null ? "null" : accountRecordList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(accountRecordList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (AccountRecord accountRecord : accountRecordList) {
            accountRecord.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(accountRecordList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + accountRecordList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + accountRecordList.size());

        return result;
    }


    @Override
    public AccountRecord getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        AccountRecord accountRecord = null;

        if (id == null) {
            return accountRecord;
        }

        try {
            accountRecord = (AccountRecord) dao.get(AccountRecord.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return accountRecord;
    }


    @Override
    public List<AccountRecord> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<AccountRecord> accountRecord = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<AccountRecord>();
        }

        try {
            accountRecord = (List<AccountRecord>) dao.getList(AccountRecord.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (accountRecord == null ? "null" : accountRecord.size()));

        return accountRecord;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getAccountRecordIdsByUserIdOrderByUpdateAt(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by userId,start,limit  : " + userId + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO �������!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getAccountRecordIdsByUserIdOrderByUpdateAt", new Object[]{userId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by userId,start,limit)  : " + userId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countAccountRecordIdsByUserIdOrderByUpdateAt(Long userId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by userId  : " + userId);
        }
        Integer count = null;


        try {

            count = dao.count("getAccountRecordIdsByUserIdOrderByUpdateAt", new Object[]{userId});


        } catch (DaoException e) {
            log.error(" count ids  wrong by userId)  : " + userId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getAccountRecordIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getAccountRecordIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countAccountRecordIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getAccountRecordIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getAccountRecordIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

