package com.ptteng.wealth.finance.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.UserProductRelation;
import com.ptteng.wealth.finance.service.UserProductRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserProductRelationServiceImpl extends BaseDaoServiceImpl implements UserProductRelationService {

 

	private static final Log log = LogFactory.getLog(UserProductRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserProductRelation userProductRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userProductRelation);

		if (userProductRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userProductRelation.setCreateAt(currentTimeMillis);
		userProductRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userProductRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userProductRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserProductRelation> insertList(List<UserProductRelation> userProductRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userProductRelationList == null ? "null" : userProductRelationList.size()));
      
		List<UserProductRelation> resultList = null;

		if (CollectionUtils.isEmpty(userProductRelationList)) {
			return new ArrayList<UserProductRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserProductRelation userProductRelation : userProductRelationList) {
			userProductRelation.setCreateAt(currentTimeMillis);
			userProductRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserProductRelation>) dao.batchSave(userProductRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userProductRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserProductRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserProductRelation userProductRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userProductRelation == null ? "null" : userProductRelation.getId()));

		boolean result = false;

		if (userProductRelation == null) {
			return true;
		}

		userProductRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userProductRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userProductRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userProductRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserProductRelation> userProductRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userProductRelationList == null ? "null" : userProductRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userProductRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserProductRelation userProductRelation : userProductRelationList) {
			userProductRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userProductRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userProductRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userProductRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserProductRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserProductRelation userProductRelation = null;

		if (id == null) {
			return userProductRelation;
		}

		try {
			userProductRelation = (UserProductRelation) dao.get(UserProductRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userProductRelation;		
		}	
		  
    	   
		@Override
		public List<UserProductRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserProductRelation> userProductRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserProductRelation>();
		}

		try {
			userProductRelation = (List<UserProductRelation>) dao.getList(UserProductRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userProductRelation == null ? "null" : userProductRelation.size()));
    
		return userProductRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getUserProductRelationIdByUidAndPid(Long uid,Long pid)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by uid,pid  : " + uid+" , "+pid );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getUserProductRelationIdByUidAndPid", new Object[] {uid,pid });
   } catch (DaoException e) {
			log.error(" get id wrong by uid,pid  : " + uid+" , "+pid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserProductRelationIdsByPid(Long pid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by pid,start,limit  : " + pid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserProductRelationIdsByPid", new Object[] { pid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by pid,start,limit)  : " + pid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getUserProductRelationIdsByPidAndUid(Long pid, Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by pid,start,limit  : " + pid+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserProductRelationIdsByPidAndUid", new Object[] { pid,uid},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by pid,uid,start,limit)  : " + pid+" , "+uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	@Override
	public Integer countUserProductRelationIdsByPidAndUid(Long pid, Long uid) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" count ids by pid  : " + pid );
		}
		Integer count=null;



		try {

			count = dao.count("getUserProductRelationIdsByPidAndUid", new Object[] { pid,uid});


		} catch (DaoException e) {
			log.error(" count ids  wrong by pid)  : " + pid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserProductRelationIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserProductRelationIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserProductRelationIdsByPid(Long pid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by pid  : " + pid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserProductRelationIdsByPid", new Object[] { pid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by pid)  : " + pid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserProductRelationIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserProductRelationIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserProductRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserProductRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserProductRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserProductRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserProductRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

