package com.ptteng.wealth.finance.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.Refunds;
import com.ptteng.wealth.finance.service.RefundsService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class RefundsServiceImpl extends BaseDaoServiceImpl implements RefundsService {

 

	private static final Log log = LogFactory.getLog(RefundsServiceImpl.class);



		   
		@Override
		public Long insert(Refunds refunds)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + refunds);

		if (refunds == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		refunds.setCreateAt(currentTimeMillis);
		refunds.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(refunds);
		} catch (DaoException e) {
			log.error(" insert wrong : " + refunds);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Refunds> insertList(List<Refunds> refundsList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (refundsList == null ? "null" : refundsList.size()));
      
		List<Refunds> resultList = null;

		if (CollectionUtils.isEmpty(refundsList)) {
			return new ArrayList<Refunds>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Refunds refunds : refundsList) {
			refunds.setCreateAt(currentTimeMillis);
			refunds.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Refunds>) dao.batchSave(refundsList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + refundsList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Refunds.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Refunds refunds)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (refunds == null ? "null" : refunds.getId()));

		boolean result = false;

		if (refunds == null) {
			return true;
		}

		refunds.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(refunds);
		} catch (DaoException e) {
			log.error(" update wrong : " + refunds);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + refunds);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Refunds> refundsList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (refundsList == null ? "null" : refundsList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(refundsList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Refunds refunds : refundsList) {
			refunds.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(refundsList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + refundsList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + refundsList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Refunds getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Refunds refunds = null;

		if (id == null) {
			return refunds;
		}

		try {
			refunds = (Refunds) dao.get(Refunds.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return refunds;		
		}	
		  
    	   
		@Override
		public List<Refunds> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Refunds> refunds = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Refunds>();
		}

		try {
			refunds = (List<Refunds>) dao.getList(Refunds.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (refunds == null ? "null" : refunds.size()));
    
		return refunds;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getRefundsIdByOrderNoAndRefundNo(String orderNo, String refundNo)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by orderNo  : " + orderNo );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getRefundsIdByOrderNoAndRefundNo", new Object[] {orderNo, refundNo });
   } catch (DaoException e) {
			log.error(" get id wrong by orderNo  : " + orderNo );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}

	@Override
	public Long getRefundsIdByRefundNo(String refundNo) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get id by refundNo  : " + refundNo );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getRefundsIdByRefundNo", new Object[] { refundNo });
		} catch (DaoException e) {
			log.error(" get id wrong by refundNo  : " + refundNo );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;

	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getRefundsIdsByUidAndStatus(Long uid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,status,start,limit  : " + uid+" , "+status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getRefundsIdsByUidAndStatus", new Object[] { uid,status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,status,start,limit)  : " + uid+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getRefundsIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getRefundsIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countRefundsIdsByUidAndStatus(Long uid,Integer status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid,status  : " + uid+" , "+status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getRefundsIdsByUidAndStatus", new Object[] { uid,status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid,status)  : " + uid+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countRefundsIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getRefundsIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getRefundsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getRefundsIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countRefundsIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getRefundsIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getRefundsIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

